d("customSubscriptionView",['ccrz', 'util', 'customSubscriptionModel'], function(CCRZ, UTIL, customSubscriptionModel) {

    return {
        extendcustomSubscriptionView: function() {
            CCRZ.custom = _.extend(CCRZ.custom||{}); 
            CCRZ.custom.views = _.extend(CCRZ.custom.views||{}); 
            CCRZ.custom.models = _.extend(CCRZ.custom.models||{}); 
            CCRZ.remoteActions = _.extend(CCRZ.remoteActions||{});
            let subscBackUpModel = '';
            CCRZ.remoteActions.subscriptionRemoting =  _.extend(CCRZ.RemoteInvocation,{ 
                className : 'DCMB2B_subscription_controller', 
                addToCart : function( reqData,callback){ 
                    this.invokeCtx('addToCart', 
                        reqData,  
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                proceedToCart : function( reqData,callback){ 
                    this.invokeCtx('proceedToCart', 
                        reqData,  
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                updateSubscription : function( reqData,callback){ 
                    this.invokeCtx('updateSubscription', 
                        reqData,  
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                getRelatedProducts: function( reqData,callback){ 
                    this.invokeCtx('getRelatedProducts', 
                        reqData,  
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                getCartDetails : function( reqData,callback){ 
                    this.invokeCtx('getCartDetails', 
                        reqData,  
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                getSubscriptionList : function( reqData,callback){ 
                    this.invokeCtx('getSubscriptionList',
                    reqData, 
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                updateAutoRenew : function( reqData,callback){ 
                    this.invokeCtx('updateAutoRenew',
                    reqData, 
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                },
                renewSubscription : function( reqData,callback){ 
                    this.invokeCtx('renewSubscription', 
                        reqData,  
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                }
            });

            CCRZ.views.customSubscriptionView = CCRZ.CloudCrazeView.extend({
                el: CCRZ.uiProperties.customSubscriptionView.desktop.selector,
                viewName: "customSubscriptionView",
                subscriptionTemplate: CCRZ.util.template(CCRZ.uiProperties.customSubscriptionView.desktop.tmpl),
                init: function(){
                    let v = this;
                    this.model.fetch(JSON.stringify({}),function(res,event){
                        if(res && res.data  ){
                            v.sortSubsc(v, res);
                        }
                    });
                },
                render: function(isModal){
                    let _this = this;
                    _this.model.set('isModal', isModal);
                    if(subscBackUpModel.get('isInit') && !_.isEmpty(CCRZ.myaccountView.subViewArray) && CCRZ.myaccountView.subViewArray[CCRZ.myaccountView.currIndex].title == 'My Subscriptions'){
                        subscBackUpModel.set('isInit', false);
                        _this.model = subscBackUpModel;
                        CCRZ.customSubscriptionView.model = subscBackUpModel;
                    }
                    this.$el.html(this.subscriptionTemplate(this.model.toJSON()));
                    if(isModal){
                        $('.mod').addClass('modal-backdrop fade in');
                        $('#actionPopUp').addClass('in show');
                    }
                    setTimeout(function() {
                        UTIL.hideLoader();
                    }, 100);
                },
                events: {
                    "click #active": "filterSubscription",
                    "click #inactive": "filterSubscription",
                    "change .incProd": "onSubQuantityChange",
                    "click .plus": "onSubQuantityChange",
                    "click .minus": "onSubQuantityChange",
                    "click .proceedCart": "proceedCart",
                    "click .editOrderItems": "handleEditOrderItems",
                    "click .changeFrequency": "handleChangeFrequency",
                    "click .cancelSubsc": "handleCancelSubsc",
                    "click .pauseSubsc": "handlePauseSubsc",
                    "click .restartSubsc": "handleRestartSubsc",
                    "click .renewSubsc": "renewSubsc",
                    "click .upgradeProduct": "getAddOn",
                    "click .convertProduct": "getAddOn",
                    "click .renewProduct": "getAddOn",
                    "click .addProduct": "getAddOn",
                    "click .addBoltOn": "getAddOn",
                    "click .addCheckbox": "onClickAutoRenew",
                    "click .autoRenew" : "handleAutoRenew",
                    "click .closeModal": "closeModal",
                    "click .cancelBtn" : "updateAction",
                    "click .pauseBtn" : "updateAction",
                    "click .restartBtn" : "updateAction",
                    "click .editBtn" : "updateAction",
                    "click .changeBtn" : "updateAction",
                    "change .product_select": "onCompositeProductChange",
                    "change .convertProduct_spt_select": "onSptChange",
                    "change .changeProduct_spt_select" : "onHandleChangeFrequency",
                    "click .quantityContainer .compositePlus" : "onHandleCompositeProducts",
                    "click .quantityContainer .compositeMinus" : "onHandleCompositeProducts",
                    "focus .datePickerChange": "handlePickerFocus",
                    "focus .datePickerRestart": "handleRestartPickerFocus",
                    "change .paymentTypes": "onHandleChangePaymentType",
                    "change .edit_payment_card": "onHandleChangePaymentInformation",
                    "change .poNumberEditPaymentInput": "onHandleChangePaymentInformation",
                },
                sortSubsc: function(v, res){

                    v.model.set("isActive", true);
                    v.model.set("isInactive", true);
                    let subscriptionList = [];
                    if(res.data.subsDataList && res.data.subsDataList.length > 0){ 
                        let subscriptionListActive = res.data.subsDataList.filter(function(e){
                            return e.subs.subscriptionStatus == 'Active';
                        }); 
                        if(subscriptionListActive && subscriptionListActive.length){
                            for(let i = 0; i < subscriptionListActive.length; i++){
                                subscriptionList.push(subscriptionListActive[i]);
                            }
                        }  
                        let subscriptionListInActive = res.data.subsDataList.filter(function(e){
                            return e.subs.subscriptionStatus != 'Active' && e.subs.subscriptionStatus != 'Renewed';
                        }); 
                        if(subscriptionListInActive && subscriptionListInActive.length){
                            for(let i = 0; i < subscriptionListInActive.length; i++){
                                subscriptionList.push(subscriptionListInActive[i]);
                            }
                        } 
                    }
                    v.model.set("subscriptionList", subscriptionList);
                    v.model.set("filterSubscriptionList", subscriptionList);
                    v.model.set("prodListList", res.data.productList);
                    v.model.set("orderList", res.data.orderList);
                    v.model.set("storedPayments", res.data.storedPayments);
                    v.model.set("isInit", true);
                    subscBackUpModel = v.model;
                    v.model.set("subscriptionListNew", res.data.subscriptionList);
                    v.render(false);
                },
                handlePickerFocus: function(event){
                    let currentDate = new Date(this.model.attributes.selectedSubscription.orderNextDate);
                    $( ".datePickerChange" ).datepicker({ 
                        minDate: 1,
                        dateFormat: "mm/dd/yyyy",
                        defaultDate: currentDate
                    });
                    setTimeout(function(){
                        $('.datepicker.datepicker-dropdown.dropdown-menu').addClass('show');
                    }, 500);
                },
                handleRestartPickerFocus: function(event){
                    let currentDate = new Date();
                    currentDate.setDate(currentDate.getDate() + 1);
                    $( ".datePickerRestart" ).datepicker({ 
                        minDate: 1,
                        dateFormat: "mm/dd/yyyy",
                        defaultDate: currentDate
                    });
                    setTimeout(function(){
                        $('.datepicker.datepicker-dropdown.dropdown-menu').addClass('show');
                    }, 500);
                },
                handleRestartSubsc: function(event){
                    this.getAddOn(event);
                },
                handleCancelSubsc: function(event){
                    this.getAddOn(event);
                },
                handlePauseSubsc: function(event){
                    this.getAddOn(event);
                },  
                handleChangeFrequency: function(event){
                    this.getAddOn(event);
                },
                handleEditOrderItems: function(event){
                    this.getAddOn(event);
                },
                handleAutoRenew: function (event){
                    UTIL.showLoader();
                    let _this= this, reqData = {
                        "autoRenew" : event.target.checked,
                        "subscId" : event.currentTarget.dataset.id
                    };
                    CCRZ.remoteActions.subscriptionRemoting.className = 'DCMB2B_subscription_controller';
                    CCRZ.remoteActions.subscriptionRemoting.updateAutoRenew(JSON.stringify(reqData),function(res,event){
                        if(res && res.data){
                            if(res.success){
                                _this.sortSubsc(_this, res);
                            }
                        }
                    });  
                },
                onHandleChangePaymentInformation: function(event){
                    //UTIL.showLoader();
                    
                    let paymentType = $('.paymentTypes option:selected').val(), _this = this, isDisabled = true;
                    let prod = _this.model.get("selectedProduct"), subsc = _this.model.get("selectedSubscription");
                    let poInputVal = $('.poNumberEditPaymentInput').val();
                    let storedPaymentElement = document.querySelector('input[name="credit_card"]:checked');

                    if(paymentType == 'po'){
                        if(poInputVal !=null || poInputVal !=''){
                            subsc.PONumber = poInputVal;
                            _this.model.set("selectedSubscription", subsc);
                            isDisabled = false;
                        }
                        
                    } else if (paymentType == 'cc'){
                        if(document.querySelector('input[name="credit_card"]:checked') != null) {
                            subsc.storedPaymentId = document.querySelector('input[name="credit_card"]:checked').value;
                            _this.model.set("selectedSubscription", subsc);
                            isDisabled = false;
                        }                        
                    } 


                    _this.model.set('isDisabled', isDisabled);
                    _this.render(true);
                },
                onHandleChangePaymentType: function(event){
                    //UTIL.showLoader();
                    
                    let paymentType = $('.paymentTypes option:selected').val(), _this = this, isDisabled = true;
                    let prod = _this.model.get("selectedProduct"), subsc = _this.model.get("selectedSubscription");
                    
                    if(paymentType == 'po'){
                        subsc.paymentType = 'po';
                        if(subsc.PONumber){
                            isDisabled = false;
                        }
                        _this.model.set("selectedSubscription", subsc);
                        //$('.poNumberEditPayment').show();
                        //$('.storedPaymentList').hide();
                    } else if (paymentType == 'cc'){
                        subsc.paymentType = 'cc';
                        if(document.querySelector('input[name="credit_card"]:checked') != null) {
                            isDisabled = false;
                        }
                        _this.model.set("selectedSubscription", subsc);
                        //$('.poNumberEditPayment').hide();
                        //$('.storedPaymentList').show();                        
                    }


                    _this.model.set('isDisabled', isDisabled);
                    _this.render(true);
                },
                onHandleChangeFrequency: function(event){
                    //UTIL.showLoader();
                    let uom = $('.changeProduct_spt_select option:selected').text(), _this = this, isDisabled = false;
                    let prod = _this.model.get("selectedProduct"), subsc = _this.model.get("selectedSubscription")
                    , sfid = $('.changeProduct_spt_select option:selected').val();
                    prod['frequencyTerm'] = uom;
                    prod['frequencyTermId'] = sfid;
                    if(subsc.SPTOrderFrequencyUOM == uom){
                        _this.model.set('subscriptionAmountPerPrice', subsc.recurringPrice);
                        _this.model.set('subscriptionAmount', subsc.recurringPriceSubAmt);
                        isDisabled = true;
                    } else {
                        prod.subProdTerms.forEach(function(spt){
                            if(spt.sptUOM == uom){
                                currentRecurringPrice = spt.sptPrice;
                            }
                        })
                        _this.model.set('subscriptionAmount', currentRecurringPrice*subsc.quantity);
                        _this.model.set('subscriptionAmountPerPrice', currentRecurringPrice);
                    }
                    _this.model.set('isDisabled', isDisabled);
                    _this.render(true);
                    setTimeout(function(){
                        let currentDate = new Date(_this.model.attributes.selectedSubscription.orderNextDate);
                        $( ".datePickerChange" ).datepicker({ 
                            dateFormat: "mm/dd/yyyy",
                            defaultDate: currentDate
                        });
                        setTimeout(function(){
                            $('.datepicker.datepicker-dropdown.dropdown-menu').addClass('show');
                        }, 500);
                    }, 1000);
                },
                onSptChange: function(event){
                    //UTIL.showLoader();
                    let sfid = event.currentTarget.dataset.sfid, uom = $('.convertProduct_spt_select option:selected').text();;
                    this.model.attributes.upgradeProduct.frequencyTerm = uom;
                    calculatePricing(event, this);
                },
                onCompositeProductChange: function(event){
                    //UTIL.showLoader();
                    var target = $(event.target), _this = this;
                    var parentSFID = target.attr('data-parentSFID');
                    var selectedProdId = target.val();
                    var productInfo = this.model.get("relatedProductInfo");
                    if(productInfo && productInfo.productList){
                        productInfo.productList.forEach(function(relProduct){
                            if(relProduct.SKU == selectedProdId){
                                _this.model.set('upgradeProduct', relProduct);
                            }
                        });
                        calculatePricing(event, _this);
                    }
                },
                filterSubscription: function(event){
                    let isActive = $('#active').is(":checked"), isInactive = $('#inactive').is(":checked"), activeValue =$('#active').val(), inactiveValue = $('#inactive').val();
                    if(!isActive && !isInactive){
                        $('#active').prop('checked', true);
                        $('#inactive').prop('checked', true);
                        isActive = true;
                        isInactive = true;
                    }
                    let filterSubscriptionList = this.model.attributes.subscriptionList.filter(function(e){
                        return ((isActive && isInactive)? (e.subs.subscriptionStatus == activeValue || e.subs.subscriptionStatus != activeValue): (isActive?e.subs.subscriptionStatus == activeValue: e.subs.subscriptionStatus != activeValue));
                    });   
                    this.model.set("filterSubscriptionList", filterSubscriptionList); 
                    this.model.set("isActive", isActive);    
                    this.model.set("isInactive", isInactive);    
                    this.render(false);
                },
                licenceModal: function(event){
                    calculatePricing(event, this);
                },
                onSubQuantityChange: function(event){
                    //UTIL.showLoader();
                    calculatePricing(event, this);
                },
                onClickAutoRenew: function(event){
                    $('#auto_' + event.currentTarget.dataset.index).prop('checked', !$('#auto_' + event.currentTarget.dataset.index).prop('checked'));
                },
                onHandleCompositeProducts: function(event){
                    let sku = event.currentTarget.dataset.sku, type= event.currentTarget.dataset.type, quantity = parseInt($('#quantity_' + sku).text());
                    quantity = (type=='inc'?(quantity+1):(type=='dec'?(quantity>0?quantity-1:quantity):quantity));
                    this.model.attributes.selectedProduct.compositeProductsS.forEach(function(product){
                        if(sku == product.componentR.SKU){
                            product.quantity = quantity;
                            $('#quantity_' + product.componentR.SKU).text(quantity);
                        }
                    });
                },
                addMajorLine: function(prod, subsc){
                    return {
                        "sku": prod.SKU,
                        "quantity": subsc.quantity,
                        "subTermId" : subsc.SPT,
                        "parentSFID" : null,
                        "isMain" : true,
                        "tierPriced": prod.tierPriced
                    }; 
                },
                addMinorLines: function(prod, subsc, order){
                    let minorLines = [];
                    prod.compositeProductsS.forEach(function(product){
                        if(product.quantity > 0){
                            minorLines.push({
                                "sku": product.componentR.SKU,
                                "quantity": product.quantity,
                                "parentSku" : prod.SKU
                            });
                        }
                    });
                    return minorLines;
                },
                updateAction: function(event){
                    event.preventDefault();
                    let _this = this;
                    let prod = _this.model.get("selectedProduct"), subsc = _this.model.get("selectedSubscription"), changeDate = ''
                    , order = _this.model.get("selectedOrder"), action = _this.model.get("actionType"), paymentMethod = '', paymentInformation = '';
                    // Action Specfic Calls
                    if(action == 'edit'){
                        paymentMethod = subsc.paymentType;
                        if(subsc.paymentType == 'po'){
                            paymentInformation = subsc.PONumber;
                        }else{
                            paymentInformation = subsc.storedPaymentId;
                        }
                        
                    } /*else if(action == 'restart'){
                        changeDate = $( ".datePickerRestart" ).datepicker('getDate');
                        changeDate = changeDate.getUTCFullYear() + '-' + (changeDate.getUTCMonth() + 1) + '-' + changeDate.getUTCDate();
                    }*/ else if(action == 'change'){
                        changeDate = $( ".datePickerChange" ).datepicker('getDate');
                        changeDate = changeDate.getUTCFullYear() + '-' + (changeDate.getUTCMonth() + 1) + '-' + changeDate.getUTCDate();
                    }
                    let reqData = {"action": action,
                    "cartEncId": CCRZ.pagevars.currentCartID,
                    "subscriptionId": subsc.sfid,
                    "orderId": order.sfid,
                    "paymentMethod": paymentMethod,
                    "paymentInformation": paymentInformation,
                    "changeDate": changeDate,
                    "newSptId": prod.frequencyTermId,
                    "recurringSubAmount": _this.model.get('subscriptionAmount') + '',
                    "recurringPrice": _this.model.get('subscriptionAmountPerPrice') + ''
                    };
                    UTIL.showLoader();
                    CCRZ.remoteActions.subscriptionRemoting.className = 'DCMB2B_subscription_controller';
                    CCRZ.remoteActions.subscriptionRemoting.updateSubscription(JSON.stringify(reqData),function(res,event){
                        
                        if(res && res.data){
                            if(res.success){
                                $('body').css('overflow', 'scroll'); 
                                _this.sortSubsc(_this, res);
                                UTIL.hideLoader();
                                
                            } else {
                                UTIL.hideLoader();
                            }
                        } else {
                            UTIL.hideLoader();
                        }
                    }); 
                },
                renewSubsc: function(event){
                    let index = event.currentTarget.dataset.index;
                    let prevQty = parseInt(event.currentTarget.dataset.originalqty);
                    let addedQty = 0;
                    let totalQty = prevQty;
                    let subsList = this.model.attributes.subscriptionList[index];
                    let perCost;

                    
                    let tierPriceList = '', isTierPriced = this.model.attributes.subscriptionList[index].prod.tierPriced;
                    this.model.attributes.subscriptionList[index].prod.tierList.forEach(function(priceList){
                        if(priceList.currencyCode == CCRZ.pagevars.remoteContext.userIsoCode){
                            if(isTierPriced){
                                tierPriceList = priceList.tierPriceList;
                            } else {
                                perCost = priceList.listPrice;
                            }
                        }
                    });
                    if(isTierPriced){
                        perCost = UTIL.getTierPrice(tierPriceList, totalQty);
                    }

                    //let reqData = {"prodId": subsList.prod.sfid, "sptId" : subsList.prod.SPT, "quantity" : totalQty, "addedLicenses" : addedQty, "subscriptionId" : subsList.prod.subscriptionId, "perLicensePrice" : perCost};
                    let reqData = {"cartEncId": CCRZ.pagevars.currentCartID,
                    "quantity": totalQty,
                    "sku": subsList.prod.SKU,
                    "productSFID": subsList.prod.sfid,
                    "sellerId": null,
                    "sptSFID": subsList.subs.SPT,
                    "tierPriced": subsList.prod.tierPriced,
                    "currentUserCurrency" : CCRZ.pagevars.remoteContext.userIsoCode,
                    "isAdd": true,
                    "isAddOn": false,
                    "isFullQuantity": true,
                    "pricePerItem" : perCost,
                    "addedLicenses" : addedQty,
                    "subscriptionId" : subsList.subs.sfid,
                    "prodId": subsList.prod.sfid,
                    "perLicensePrice" : perCost,
                    "isAutoRenew" : subsList.subs.autoRenew,
                    "parentSFID": null};
                    UTIL.showLoader();
                    CCRZ.remoteActions.subscriptionRemoting.className = 'DCMB2B_subscription_controller';
                    CCRZ.remoteActions.subscriptionRemoting.renewSubscription(JSON.stringify(reqData),function(res,event){
                        if(res && res.data){
                            if(res.success){
                                UTIL.showLoader();
                                window.open(UTIL.getNavigateURL('cart', {"cartID": res.data}), '_self');
                            }
                        }
                    });  
                },
                proceedCart: function(event){
                    let attributes = this.model.attributes, action = attributes.actionType;
                    let prevQty = attributes.selectedSubscription.quantity, addedQty = parseInt($('.incProd').val()) - prevQty;
                    let totalQty = (action == 'renew'?prevQty:(prevQty + addedQty)), perCost = null, sptId = null;
                    let tierPriceList = '', isTierPriced = ((action == 'add' || action == 'renew')?attributes.selectedProduct.tierPriced:attributes.upgradeProduct.tierPriced);
                    let tierList = ((action == 'add' || action == 'renew')?attributes.selectedProduct.tierList:attributes.upgradeProduct.tierList);
                    tierList.forEach(function(priceList){
                        if(priceList.currencyCode == CCRZ.pagevars.remoteContext.userIsoCode){
                            if(isTierPriced){
                                tierPriceList = priceList.tierPriceList;
                            } else {
                                perCost = priceList.listPrice;
                            }
                        }
                    });
                    if(action == 'add' || action == 'renew'){
                        sptId = attributes.selectedSubscription.SPT;
                    } else {
                        attributes.upgradeProduct.subProdTerms.forEach(function(spt){
                            if(spt.installmentFrequencyUOM == attributes.upgradeProduct.frequencyTerm){
                                sptId = spt.sfid;
                            }
                        });
                    }
                    if(isTierPriced){
                        perCost = UTIL.getTierPrice(tierPriceList, totalQty);
                    }
                    let reqData = {
                        "cartEncId": CCRZ.pagevars.currentCartID,
                        "quantity": totalQty,
                        "sku": ((action == 'add' || action == 'renew')?attributes.selectedProduct.SKU:attributes.upgradeProduct.SKU),
                        "sellerId": null,
                        "sptSFID": sptId,
                        "tierPriced": isTierPriced,
                        "currentUserCurrency" : CCRZ.pagevars.remoteContext.userIsoCode,
                        "pricePerItem" : perCost,
                        "proratedPricePerItem" : (action == 'renew')?0:attributes.proratedPricePerItem,
                        "addedLicenses" : (action == 'renew')?0:addedQty,
                        "prevQty": prevQty,
                        "subscriptionId" : attributes.selectedSubscription.sfid,
                        "prodId": ((action == 'add' || action == 'renew')?attributes.selectedProduct.sfid:attributes.upgradeProduct.sfid),
                        "isAutoRenew" : attributes.selectedSubscription.autoRenew,
                        "parentSFID": null,
                        "action": attributes.actionType
                    };
                    UTIL.showLoader();
                    CCRZ.remoteActions.subscriptionRemoting.className = 'DCMB2B_subscription_controller';
                    CCRZ.remoteActions.subscriptionRemoting.proceedToCart(JSON.stringify(reqData),function(res,event){
                        if(res.data && res.data.success){
                            if(res.data.cartEncId){
                                UTIL.showLoader();
                                window.open(UTIL.getNavigateURL('cart', {"cartID": res.data.cartEncId}), '_self');
                            }
                        }
                    });  
                },
                updateEditLines: function(_this){
                    /*let prod = _this.model.get("selectedProduct"), subsc = _this.model.get("selectedSubscription"), order = _this.model.get("selectedOrder");
                    prod.compositeProductsS.forEach(function(product){
                        order.EOrderItemsS.forEach(function(orderItem){
                            if(orderItem.parentOrderItem && orderItem.parentOrderItem == subsc.CCOrderItem && orderItem.productR.SKU == product.componentR.SKU){
                                product.quantity = orderItem.quantity;
                            }
                        });
                    });
                    _this.model.set("selectedProduct", prod);*/
                    _this.render(true);
                },
                closeModal: function(event){
                    this.model.set('isModal', false);
                    $('#actionPopUp').removeClass('in show');
                    $('.mod').removeClass('modal-backdrop fade in');
                    $('.cc_main_body').removeClass('modal-open');
                    $('.cc_main_body').css("padding-right", "0px")
                    $('.cc_main_body').css('overflow','scroll');
                },
                getAddOn: function(event){
                    UTIL.showLoader();
                    let action = event.currentTarget.dataset.action, isPopUp = false, _this = this;
                    _this.model.set("actionType", action);
                    $('.cc_main_body').css('overflow','hidden');
                    let prodId = event.target.attributes["data-id"].value;
                    let subscId = event.target.attributes["data-sfid"].value;
                    let subscriptionList = _this.model.get('subscriptionList');
                    if(subscriptionList && subscriptionList.length > 0) {
                        subscriptionList.forEach(function(subsc){
                            if(subsc.order.PONumber){
                                subsc.subs.paymentType = 'po';
                            }else{
                                subsc.subs.paymentType = 'cc';
                            }
                            if(subsc.subs.sfid == subscId){
                                subsc.subs.quantity = subsc.subs.quantity++; 
                                _this.model.set("selectedProduct", subsc.prod);
                                _this.model.set("selectedSubscription", subsc.subs);
                                _this.model.set("selectedOrder", subsc.order);
                            }
                        });
                    }
                    var reqData = {
                        "productId": prodId,
                        "locale": CCRZ.pagevars.userLocale,
                        "addOnType": event.currentTarget.dataset.type,
                        "action": event.currentTarget.dataset.action
                    };
                    if(action != 'renew' || action != 'addOn'){
                        _this.model.set('isModal', true);
                    }
                    if(action != 'add' && action != 'renew' && action != 'cancel' && action != 'pause' && action != 'restart' && action != 'edit'){
                        CCRZ.remoteActions.subscriptionRemoting.className = 'DCMB2B_subscription_controller';
                        CCRZ.remoteActions.subscriptionRemoting.getRelatedProducts(JSON.stringify(reqData),function(res,e){
                            let currencySymbol = '';
                            let dataRes = '';
                            if(res && res.data){
                                dataRes = res.data;
                                if(action == 'change'){
                                    let product = _this.model.get("selectedProduct"), subsc = _this.model.get("selectedSubscription");
                                    product['subProdTerms'] = dataRes;
                                    product['frequencyTerm'] = subsc.SPTOrderFrequencyUOM;
                                    product['frequencyTermId'] = subsc.sfid;
                                    _this.model.set("selectedProduct", product);
                                    _this.model.set('subscriptionAmountPerPrice', subsc.recurringPrice);
                                    _this.model.set('subscriptionAmount', subsc.recurringPriceSubAmt);
                                    _this.model.set('isDisabled', true);
                                    _this.model.set('isModal', true);
                                    _this.render(true);
                                } else {
                                    if(dataRes.productList && dataRes.productList.length > 0){
                                        for(var i=0; i<dataRes.productList.length; i++){
                                            var localProd = dataRes.productList[i];
                                            if(i == 0){
                                                if(action == 'upgrade'){
                                                    _this.model.set('upgradeProduct', localProd);
                                                }
                                            }
                                            if(action == 'convert'){
                                                if(localProd.trialProductR.SKU == _this.model.attributes.selectedProduct.SKU)
                                                _this.model.set('upgradeProduct', localProd);
                                            }
                                            dataRes.productList[i]['frequencyTerm'] = 'Monthly';
                                            dataRes.productList[i]['currencySymbol'] = currencySymbol;
                                            if(dataRes.productPricingData[localProd.sfid]){
                                                var localPricing = dataRes.productPricingData[localProd.sfid];
                                                if(localPricing.productPrice){
                                                    dataRes.productList[i]['price'] = localPricing.productPrice.price;
                                                }else if(localPricing.basePrice){
                                                    dataRes.productList[i]['price'] = localPricing.productPrice.price;
                                                }
                                            }
                                            if(dataRes.productList[i].compositeProductsS && dataRes.productList[i].compositeProductsS.length > 0){
                                                for(var j=0; j<dataRes.productList[i].compositeProductsS.length; j++){
                                                    var compositeProd = dataRes.productList[i].compositeProductsS[j];
                                                    compositeProd['isChecked'] = (j == 0?true:false);
                                                    if(dataRes.productPricingData && dataRes.productPricingData[compositeProd.component]){
                                                        var pricingInfo = dataRes.productPricingData[compositeProd.component];
                                                        if(pricingInfo.productPrice){
                                                            dataRes.productList[i].compositeProductsS[j]['price'] = pricingInfo.productPrice.price;
                                                        }else if(pricingInfo.basePrice){
                                                            dataRes.productList[i].compositeProductsS[j]['price'] = pricingInfo.productPrice.price;
                                                        }else{
                                                            dataRes.productList[i].compositeProductsS[j]['price'] = 0;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    _this.model.set("relatedProductInfo", dataRes);
                                    $('.incProd').val(_this.model.attributes.selectedSubscription.quantity);
                                    calculatePricing(event, _this);
                                }
                            } 
                        });
                    } else {
                        if(action == 'renew'){
                            //Call a method to create a cart Item and navigate to the cart page.
                            _this.proceedCart(event);
                        } else if(action == 'add'){
                            $('.incProd').val(_this.model.attributes.selectedSubscription.quantity);
                            calculatePricing(event, _this);
                        } else if(action == 'cancel' || action == 'pause' || action == 'restart'){
                            let date = new Date();
                            date.setDate(date.getDate()+1);
                            $( "#datepicker" ).datepicker();
                            _this.render(true);
                        } else if(action == 'edit'){
                            _this.model.set('isDisabled', true);
                            _this.updateEditLines(_this);
                        }
                    }
                }
            });


            function calculatePricing(event, _this){
                let prevPricePerItem = '', currPricePerItem= '', prevTotal = '', currentTotal = '', currentPriceList = '';
                let sfid = event.currentTarget.dataset.sfid, isAdd = event.currentTarget.dataset.isadd
                , isRemove = event.currentTarget.dataset.isremove, action = _this.model.attributes.actionType;
                let quantity = parseInt($('.incProd').val()), originalQty = _this.model.attributes.selectedSubscription.quantity; 
                _this.model.attributes.selectedProduct.tierList.forEach(function(priceList){
                    if(priceList.currencyCode == CCRZ.pagevars.remoteContext.userIsoCode && priceList.subscriptionInstallmentUOM == _this.model.attributes.selectedSubscription.SPTInstallmentFrequencyUOM){
                        currentPriceList = priceList;
                    }
                });
                let min = parseInt(event.currentTarget.dataset.min), max = parseInt(event.currentTarget.dataset.max);
                if(isNaN(quantity) || typeof quantity == 'undefined'){
                    quantity = (action == 'add')?_this.model.attributes.selectedSubscription.quantity + currentPriceList.minQuantity:_this.model.attributes.selectedSubscription.quantity;
                }
                if(typeof isAdd != 'undefined'){
                    quantity = quantity + currentPriceList.minQuantity;
                }
                if(typeof isRemove != 'undefined'){
                    quantity = (quantity - currentPriceList.minQuantity < currentPriceList.minQuantity?currentPriceList.minQuantity:quantity - currentPriceList.minQuantity);
                }  
                if(typeof currentPriceList.maxQuantity != 'undefined' && (originalQty + quantity) > currentPriceList.maxQuantity){
                    $('#qtyErrorFlow').modal({backdrop: true, show: true}); 
                    $('#qtyErrorFlow').removeClass('fade');
                    quantity = currentPriceList.maxQuantity - originalQty;
                }
                if(!quantity || quantity <= 0){
                    quantity = 1;
                }
                if(action == 'add'){
                    if(quantity <= (originalQty+currentPriceList.minQuantity)){
                        quantity = (originalQty+currentPriceList.minQuantity);
                    }
                } else if(action == 'upgrade'){
                    if(quantity < originalQty){
                        quantity = originalQty;
                    }
                }
                if(typeof _this.model.attributes.selectedSubscription.updateQuantity != 'undefined'){
                    _this.model.attributes.selectedSubscription.updateQuantity = quantity;
                } else {
                    _this.model.attributes.selectedSubscription['updateQuantity'] = (action == 'add')?_this.model.attributes.selectedSubscription.quantity + currentPriceList.minQuantity:_this.model.attributes.selectedSubscription.quantity;
                }
                if(_this.model.attributes.selectedProduct.tierPriced){
                    prevPricePerItem = UTIL.getTierPrice(currentPriceList.tierPriceList, originalQty);
                    currPricePerItem = UTIL.getTierPrice(currentPriceList.tierPriceList, originalQty + quantity);
                } else{
                    if(action == 'upgrade' || action == 'convert'){
                        let upgradeProduct = _this.model.get('upgradeProduct');
                        if(upgradeProduct.isSubscriptionAvailable && upgradeProduct.subProdTerms && upgradeProduct.subProdTerms.length > 0){
                            upgradeProduct.subProdTerms.forEach(function(spt){
                                if(spt.installmentFrequencyUOM == _this.model.attributes.selectedSubscription.SPTInstallmentFrequencyUOM){
                                    prevPricePerItem = spt.productPrice;
                                    currPricePerItem = spt.productPrice;
                                }
                            });
                        }
                    } else {
                        prevPricePerItem = currentPriceList.listPrice;
                        currPricePerItem = currentPriceList.listPrice;
                    }
                }
                let currDate = new Date();
                currDate = new Date(currDate);
                let currentLocale = 'en-US';
                currDate = new Date(currDate.toLocaleString(currentLocale, { timeZone: "UTC" }));
                currDate = new Date(currDate.getUTCFullYear(), (currDate.getUTCMonth()), currDate.getUTCDate(), 0, 0, 0, 0);
                currDate = currDate.getTime() + (currDate.getTimezoneOffset() * 1000);
                let orderstartDate = _this.model.attributes.selectedSubscription.subscriptionStartDate;
                orderstartDate = new Date(orderstartDate);
                orderstartDate = new Date(orderstartDate.toLocaleString(currentLocale, { timeZone: "UTC" }));
                orderstartDate = new Date(orderstartDate.getUTCFullYear(), (orderstartDate.getUTCMonth()), orderstartDate.getUTCDate(), 0, 0, 0, 0);
                orderstartDate = orderstartDate.getTime() + (orderstartDate.getTimezoneOffset() * 1000);
                let orderEndDate = _this.model.attributes.selectedSubscription.installmentNextDate;
                orderEndDate = new Date(orderEndDate);
                orderEndDate = new Date(orderEndDate.toLocaleString(currentLocale, { timeZone: "UTC" }));
                orderEndDate = new Date(orderEndDate.getUTCFullYear(), (orderEndDate.getUTCMonth()), orderEndDate.getUTCDate(), 0, 0, 0, 0);
                orderEndDate = orderEndDate.getTime() + (orderEndDate.getTimezoneOffset() * 1000);
                const dateDiff = Math.abs(orderEndDate - currDate);
                const dateTotalDiff = Math.abs(orderEndDate - orderstartDate);
                const totalDays = Math.ceil(dateTotalDiff / (1000 * 60 * 60 * 24));
                const remainingDays = Math.ceil(dateDiff / (1000 * 60 * 60 * 24));
                let proratedAmountPerLicense = (totalDays <=0?0:((action == 'upgrade'?currentPriceList.listPrice:currPricePerItem) * remainingDays)/totalDays), upgradeProratedAmountPerLicense = 0;
                if(action == 'upgrade'){
                    upgradeProratedAmountPerLicense = (totalDays <=0?0:(currPricePerItem * remainingDays)/totalDays);
                } else if(action == 'convert'){
                    let upgradeProduct = _this.model.attributes.upgradeProduct;
                    upgradeProduct.subProdTerms.forEach(function(spt){
                        if(spt.installmentFrequencyUOM == upgradeProduct.frequencyTerm){
                            currPricePerItem = spt.productPrice;
                        }
                    });
                    proratedAmountPerLicense = currPricePerItem;
                }
                prevTotal = prevPricePerItem * originalQty;
                currentTotal = currPricePerItem * (originalQty + quantity);
                _this.model.set('previousCost', prevPricePerItem);
                _this.model.set('newCost', currPricePerItem);
                _this.model.set('previousTotal', prevTotal);
                let proratedQuantity = (action == 'convert')?quantity:(action == 'add'?(quantity - originalQty):(action == 'upgrade'?quantity:quantity));
                let newTotal = (proratedAmountPerLicense * proratedQuantity);
                if(action == 'upgrade'){
                    newTotal = (upgradeProratedAmountPerLicense * proratedQuantity) - (proratedAmountPerLicense * originalQty)
                    proratedAmountPerLicense = newTotal/proratedQuantity;
                }
                
                _this.model.set('newTotal', newTotal);
                _this.model.set('proratedPricePerItem', proratedAmountPerLicense);
                _this.render(true);
            }

            CCRZ.customSubscriptionView = new CCRZ.views.customSubscriptionView({
                model : new customSubscriptionModel()
            });
            return CCRZ.customSubscriptionView;
        }
        
    } 
});


