d("storeView", ['ccrz', 'util', 'storeModel'], function (CCRZ, UTIL, storeModel) {
    return {
        extendStoreView: function () {
            var globalDeliveryMsg = '<span class="closeTooltip">×</span>' +
                '<span class="toolTipDeliveryZipError">Looks like your current store isn\'t near your delivery area. '+
                '<a class="toolTipOpenStore">Need to update your store?</a></span>';
            // Create Custom Store View
            CCRZ.views.storeView = CCRZ.CloudCrazeView.extend({
                el: CCRZ.uiProperties.storeView.selector,
                viewName: "storeView",
                template: CCRZ.util.template(CCRZ.uiProperties.storeView.tmpl),
                init: function () {
                    Handlebars.registerPartial("storeListing", $(CCRZ.uiProperties.storeView.partials.storeListing).html());
                    this.prepAndRender();
                },
                render: function () {
                    this.setElement($(CCRZ.uiProperties.storeView.selector));
                    this.$el.html(this.template(this.model.toJSON()));
                    if (this.model.get('isInit')) {
                        this.postRender();
                        this.model.set('isInit', false);
                        if (CCRZ.pagevars.currentPageName !== 'ccrz__Cart') {
                            UTIL.hideLoader();
                        }
                    } else {
                        this.postRender();
                        UTIL.hideLoader();
                    }
                },
                events: {
                    'click .toolTipOpenStore': 'openSelectInStores',
                    'click #btn_sStore': 'openSelectInStores',
                    'click #btn_SelectInstore': 'searchStore',
                    'keydown #select_store_zipCode': 'handleSearchKeyDown',
                    'click #SelectInstore_close': 'closeStore',
                    'click #btn_saveStore': 'saveStore',
                    'click .storeDetails': 'handleToggleDetails',
                    'change #radius_id': 'handleRadiusChange',
                    'click #pdpTodayFilter': 'handleTodayFilter',
                    'click .toggle-map': 'handleMapToggle',
                    'click #btn_sDeliveryZip': 'openZipEntry',
                    'click .toolTipOpenZip': 'openZipEntry',
                    'click #UpdateDeliveryZip_close' : 'closeZipEntry',
                    'click #btn_UpdateDeliveryZip': 'handleSaveZip',
                    'keydown #update_delivery_zipCode': 'handleDeliveryZipKeyDown',
                    'click #btn_mobileStoreDrop' : 'toggleMobileModal',
                    'click .closeTooltip':'closeToolTip'
                },
                prepAndRender: function () {
                    let _this = this;
                    // initial setters
                    _this.model.set('storeList', []);
                    _this.model.set('selectedStoreList', []);
                    _this.model.set('selectedStoreName', 'Select A Store');
                    _this.model.set('isSave', false);
                    _this.model.set('isPDP', false);
                    _this.model.set('isSelectedStore', true);
                    _this.model.set('isFiltered', false);
                    _this.model.set('isCart', false);
                    _this.model.set('radiusList', ['10', '20', '30', '40', '50']);
                    _this.model.set('searchRadius', '30');
                    _this.model.set('currentProdQuantity', 0);
                    _this.model.set('isStoreAvailable', false);
                    _this.model.set('isInit', true);
                    // _this.model.set('isOpenZipModal', false);
                    _this.listenTo(CCRZ.pubSub, 'fetchStoreByZip', function (_inputData) {

                        if (_this.model.get('isSelectedStore') || (!_this.model.get('isSelectedStore') && (_inputData['zipCode'] == '' || (_inputData['zipCode'] != '' && this.isValidZip(_inputData['zipCode']))))) {
                            switch (_inputData['type']) {
                                case 'header':
                                    _this.model.set('selectedStoreZip', _inputData['zipCode']);
                                    _this.fetchStores(false);
                                    break;
                                case 'pdp':
                                    _this.model.set('isPDP', true);
                                    _this.model.set('selectedStoreZip', _inputData['zipCode']);
                                    _this.model.set('pdpStoreName', _inputData['pdpStoreName']);
                                    _this.model.set('currentProdQuantity', _inputData['quantity']);
                                    _this.model.set('productSKU', _inputData['sku']);
                                    _this.model.set('viewType', _inputData['viewType']);
                                    _this.model.set('backOrderElgible', _inputData['backOrderElgible']);
                                    _this.model.set('backOrderinStockDate', _inputData['backOrderinStockDate']);
                                    if (_inputData['isAggregatePDP'])
                                        _this.fetchStoresBySku(_inputData['openModal'], false, false);
                                    else
                                        _this.fetchStoresBySku(_inputData['openModal'], true, false);

                                    break;
                                case 'cart':
                                    // For cart callout
                                    _this.model.set('isFiltered', true);

                                    _this.model.set('isSelectedStore', false);
                                    _this.model.set('isCart', true);
                                    _this.model.set('selectedCartZip', _inputData['zipCode']);
                                    _this.model.set('productSKU', _inputData['sku']);
                                    _this.model.set('viewType', _inputData['viewType']);
                                    _this.model.set('cartStoreName', _inputData['cartStoreName']);
                                    _this.model.set('cartItemData', _inputData['cartItemData']);
                                    _this.model.set('currentProdQuantity', _inputData['cartItemData']['quantity']);
                                    _this.model.set('backOrderElgible', _inputData['cartItemData']['product']['LPMBBBackOrderEligible']);
                                    _this.model.set('backOrderinStockDate', _inputData['cartItemData']['product']['LPMBBInStockDate']);
                                    if (_inputData['zipCode'] == '') {
                                        _this.model.set('storeList', []);
                                        _this.model.set('selectedStoreList', []);
                                        _this.openModal();
                                        _this.render();
                                    } else {
                                        _this.fetchStoresBySku(true, false, false);
                                    }
                                    break;
                            }
                        } else {
                            _this.model.set('isError', true);
                            _this.model.set('errorLocation', 'header');
                            _this.model.set('errorMessage', 'Enter a valid zip code');
                            _this.openModal();
                            _this.render();
                        }
                    });
                    // Adding Event Listener for backdrop
                    $('#sidebarBackdrop').on("click", function () {
                        var modelOpen = _this.model.get('isOpen');
                        var zipModal = _this.model.get('isOpenZipModal');
                        if(modelOpen) {
                            _this.closeStore();
                        } else if (zipModal) {
                            _this.closeZipEntry();
                        } else {
                            $('.Header_mobileDropDown').addClass('hide');
                            $('#sidebarBackdrop').addClass('hide');
                        }

                    });
                    if (CCRZ.pagevars.currentPageName == 'ccrz__ProductDetails') {
                        _this.model.set('isPDP', true);
                        _this.model.set('isFiltered', true);
                        _this.model.set('productSKU', CCRZ.pagevars.queryParams.sku);
                        // By Default show pick up for both normal and subsc
                        CCRZ.productDetailModel.set('showPickupSubscription', true);
                        if (CCRZ.productDetailModel.get('showNewSubscriptionSelection')) {
                            // on load the option will be nosuboption
                            CCRZ.productDetailModel.set('subTermId', 'nosuboption');
                            /*if($(".subscriptionInputOption:checked").val() == 'nosuboption'){
                                CCRZ.productDetailModel.set('showPickupSubscription', true);
                                CCRZ.productDetailModel.set('subTermId', 'nosuboption');
                            }else{
                                CCRZ.productDetailModel.set('showPickupSubscription', false);
                                let subProdTerms = CCRZ.productDetailModel.get('subProdTerms');
                                for(let i=0;i<subProdTerms.length; i++){
                                    if(subProdTerms[i].sfid == $(".subscriptionInputOption:checked").val()){
                                        CCRZ.productDetailModel.set('subTermId', subProdTerms[i].sfid);
                                    }
                                }
                            }  */
                        }
                        _this.fetchStoresBySku(false, true, false);
                    } else if(CCRZ.pagevars.currentPageName == 'ccrz__Cart') {
                        _this.model.set('isCart', true);

                        let zipCode = _this.model.get('selectedCartZip');
                        if(zipCode = '' || zipCode === undefined) {
                            if (_this.isSessionData('storeData')) {
                                let storeInfo = JSON.parse(_this.getSessionData('storeData'));
                                zipCode = storeInfo.zip;
                                _this.model.set('selectedStoreZip', storeInfo.zip);
                                _this.model.set('selectedStoreName', storeInfo.storename);
                            } else if (navigator.geolocation) {
                                navigator.geolocation.getCurrentPosition(_this.fetchGeo.bind(_this), _this.selectAStore.bind(_this));
                                zipCode = _this.model.get('selectedStoreZip');
                            } else {
                                zipCode = _this.model.get('selectedStoreZip');
                            }
                        }
                        this.model.set('selectedCartZip', zipCode);
                        this.model.set('initCartSetup', true);
                        this.fetchStores(true);
                    }
                    else {
                        _this.fetch();
                    }
                },
                postRender: function() {
                    this.checkDeliveryZip();
                    if(this.model.get('isPDP') && this.model.get('isInit')) {
                        let storeZip = this.model.get('selectedStoreZip');
                        let inputData = {
                            'zipCode': storeZip,
                            'itemID': CCRZ.productDetailModel.attributes.product.prodBean.SKU,
                            'quantity': 1,
                            'isHome': false
                        }
                        CCRZ.pubSub.trigger('fetchPromiseDate', inputData);
                    }
                },
                handleRadiusChange: function (event) {
                    this.model.set('searchRadius', event.target.value);
                },
                handleToggleDetails: function () {
                    var storeId = $(event.target)[0].dataset.storeid
                    var hiddenStoreId = '#' + storeId + 'Hidden';
                    var buttonText = $(event.target)[0].innerHTML;
                    var showText = $(event.target).closest('.store-locator').find(hiddenStoreId)[0];
                    if (showText.style.display === "none") {
                        showText.style.display = "block";
                        buttonText.innerHTML = "Close Store Details";
                    } else {
                        showText.style.display = "none";
                        buttonText.innerHTML = "Store Details";
                    }
                    window.stop();
                },
                handleSearchKeyDown: function () {
                    let _this = this;
                    if (event.keyCode === 13) {
                        _this.searchStore();
                    }
                },
                openSelectInStores: function () {
                    $('.Header_mobileDropDown').addClass('hide');
                    this.closeZipModal();
                    let inputData = {'zipCode': this.model.get('selectedStoreZip'), 'type': 'header'}
                    this.model.set('isCart', false);
                    this.model.set('isSelectedStore', true);
                    if (CCRZ.pagevars.currentPageName == 'ccrz__ProductDetails') {
                        inputData.type = 'pdp';
                        inputData['pdpStoreName'] = this.model.get('selectedStoreName');
                        inputData['viewType'] = (this.model.get('selectedStoreName') != 'Select A Store') ? 'update' : 'new';
                        inputData['sku'] = CCRZ.pagevars.remoteContext.queryParams.sku;
                        inputData['openModal'] = true;
                        inputData['quantity'] = CCRZ.productDetailModel.attributes.quantity;
                        inputData['isAggregatePDP'] = !!$('.aggregate-product-type').length;
                        inputData['backOrderElgible'] = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBBackOrderEligible;
                        inputData['backOrderinStockDate'] = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBInStockDate;
                    } else {
                        this.model.set('isPDP', false);
                    }
                    CCRZ.pubSub.trigger('fetchStoreByZip', inputData);
                },
                searchStore: function () {
                    this.model.set('isError', false);
                    let zip = $.trim($(event.target).closest('.Select_stores').find('#select_store_zipCode').val());
                    if (this.isValidZip(zip)) {
                        if (this.model.get('isCart')) {
                            this.model.set('selectedCartZip', zip);
                            this.fetchStoresBySku(true, false, true);
                        } else if (this.model.get('isPDP')) {
                            this.model.set('selectedStoreZip', zip);
                            this.fetchStoresBySku(true, false, true);
                        } else {
                            this.model.set('selectedStoreZip', zip);
                            this.fetchStores(true);
                        }
                    } else {
                        this.model.set('isError', true);
                        this.model.set('errorLocation', 'body');
                        this.model.set('errorMessage', zip == '' ? 'Zipcode is a required field' : 'Enter a valid zip code');
                        this.render();
                    }
                },
                handleTodayFilter: function () {
                    let _this = this;
                    let filterBoolean = event.target.checked;
                    if (filterBoolean) {
                        _this.model.set('isFiltered', true);
                    } else {
                        _this.model.set('isFiltered', false);
                    }
                    if (_this.model.get('isError')) {
                        _this.model.set('isError', false);
                    }
                    _this.render();
                },
                fetchStores: function (isSearch) {
                    let _this = this;
                    _this.model.fetchStores(JSON.stringify({
                        zip: _this.model.get('selectedStoreZip'),
                        radius: _this.model.get('searchRadius')
                    }), function (res, evt) {
                        _this.model.set('isError', false);
                        if (res && res.success && res.data != undefined && (res.data.storesAPI != 'null' && res.data.storesAPI != undefined)) {
                            let responseData = JSON.parse(res.data.storesAPI), storeData = responseData['data']
                                , storeList = [], selectedStoreList = [];
                            if (storeData && storeData.length > 0) {
                                storeData.forEach(function (store, index) {
                                    if (_this.model.get('selectedStoreName') == store.name) {
                                        store['hideBtn'] = true;
                                        if ((store.c_enableSts && store.c_enableBopis)) {
                                            store['hideSequence'] = true;
                                            store['isSelectedStore'] = true;
                                            selectedStoreList.push(store);
                                        } else {
                                            storeList.push(store);
                                        }
                                    } else {
                                        if ((!store.c_enableSts || !store.c_enableBopis)) {
                                            store['hideBtn'] = true;
                                        }
                                        storeList.push(store);
                                    }
                                });
                                _this.model.set('storeList', storeList);
                                _this.model.set('selectedDeliveryZip', res.data.selectedDeliveryZip);

                                if (!_.isEmpty(selectedStoreList)) {
                                    _this.model.set('selectedStoreList', selectedStoreList);
                                    _this.model.set('differentStoreName', 'different'); //TBC
                                }
                            }

                            if(_this.model.get('isCart') && res.data.selectedDeliveryZip != undefined) {
                                _this.model.set('selectedDeliveryZip', res.data.selectedDeliveryZip);
                            }

                        } else {
                            if (isSearch) {
                                _this.model.set('isError', true);
                                _this.model.set('errorLocation', 'body');
                                _this.model.set('errorMessage', CCRZ.pagevars.pageLabels['LPM_BB_Store_Not_Available']);
                            }

                        }
                        _this.closeZipModal();
                        let initCartSetup = _this.model.get('initCartSetup');
                        if((initCartSetup || initCartSetup === undefined) && CCRZ.pagevars.currentPageName == 'ccrz__Cart') {
                            _this.model.set('initCartSetup', false);
                            _this.closeModal();
                            // _this.openModal();
                        } else {
                            _this.openModal();
                        }

                        //Default session store
                        let tempSelectedStoreName = _this.model.get('selectedStoreName');
                        if(tempSelectedStoreName == undefined ||tempSelectedStoreName == '' || tempSelectedStoreName == 'Select A Store'){
                            _this.defaultSessionStore();
                        } else {
                            _this.render();
                        }

                    });
                },
                fetchStoresBySku: function (isOpenModal, isUpdatePDP, isSearch, callback) {
                    let _this = this, zipCode = '';
                    if (_this.model.get('isCart')) {
                        $.trim($('#select_store_zipCode').val(_this.model.get('selectedCartZip')));
                        zipCode = _this.model.get('selectedCartZip');
                    } else {
                        let newQty = $.trim($('#qty').val());
                        CCRZ.productDetailModel.set('quantity', newQty);

                        //There is a chance isOpenModal is true but the modal is not open yet so it is blank
                        //Should use the stored store zip rather than setting it to blank...
                        if (isOpenModal) {
                            zipCode = $.trim($(event.target).closest('.Select_stores').find('#select_store_zipCode').val());
                        }
                        if (isOpenModal && zipCode != '') {
                            _this.model.set('selectedStoreZip', zipCode);
                        } else if (_this.isSessionData('storeData')) {
                            let storeInfo = JSON.parse(_this.getSessionData('storeData'));
                            zipCode = storeInfo.zip;
                            _this.model.set('selectedStoreZip', storeInfo.zip);
                            _this.model.set('selectedStoreName', storeInfo.storename);
                        } else if (navigator.geolocation) {
                            navigator.geolocation.getCurrentPosition(_this.fetchGeo.bind(_this), _this.selectAStore.bind(_this));
                            zipCode = _this.model.get('selectedStoreZip');
                        } else {
                            zipCode = _this.model.get('selectedStoreZip');
                        }
                    }
                    let reqData = {
                        'zip': zipCode,
                        'radius': _this.model.get('searchRadius'),
                        'sku': _this.model.get('productSKU')
                    };
                    _this.model.fetchStoresBySku(JSON.stringify(reqData), function (res, evt) {
                        _this.model.set('isError', false);
                        if (CCRZ.productDetailModel && CCRZ.productDetailModel.attributes && !CCRZ.productDetailModel.attributes.product) {
                            CCRZ.homePage();
                        }

                        if(_this.model.get('isPDP') && res.data.selectedDeliveryZip != undefined) {
                            CCRZ.productDetailModel.set('selectedDeliveryZip', res.data.selectedDeliveryZip);
                            _this.model.set('selectedDeliveryZip', res.data.selectedDeliveryZip);
                        }

                        if (res && res.success && res.data.storeData != "null") {

                            _this.model.set('isStoreAvailable', true);

                            /*
                            if(!_this.isSessionData('storeData')){
                                _this.setStoreInfo(_this, res.data.storeName, res.data.zip, false);
                            }
                            */

                            let responseData = JSON.parse(res.data.storeData), storeData = responseData['stores']
                                , storeList = [], selectedStoreList = [];

                            if (_this.model.get('isSelectedStore')) {
                                if (!_this.isSessionData('storeData')) {
                                    _this.setStoreInfo(_this, res.data.storeName, res.data.zip, false);
                                }
                            }
                            if (storeData && storeData.length > 0) {
                                storeData.forEach(function (store, index) {
                                    _this.updateStoreInvStatus(store, storeList, selectedStoreList, _this);
                                });
                                _this.model.set('storeList', storeList);

                                if (_this.model.get('isFiltered')) {
                                    if (_this.model.get('isPDP')) {
                                        if (!CCRZ.productDetailModel.attributes.product) {
                                            CCRZ.homePage();
                                        }
                                        LPMBBAvailableForInStorePickup = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBAvailableForInStorePickup;
                                        LPMBBIsInStoreOnly = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBIsInStoreOnly;
                                        if (!LPMBBAvailableForInStorePickup && !LPMBBIsInStoreOnly) {
                                            _this.model.set('isError', true);
                                            _this.model.set('errorLocation', 'body');
                                            _this.model.set('errorMessage', CCRZ.pagevars.pageLabels['LPM_BB_No_Stores_Found']);
                                        }
                                    } else if (_this.model.get('isCart')) {
                                        productSKU = _this.model.get('productSKU');
                                        CCRZ.cartDetailModel.attributes.ECartItemsS.models.forEach(function (cItem) {
                                            if (productSKU == cItem.attributes.product.SKU) {
                                                LPMBBAvailableForInStorePickup = cItem.attributes.product.LPMBBAvailableForInStorePickup;
                                                LPMBBIsInStoreOnly = cItem.attributes.product.LPMBBIsInStoreOnly;
                                            }
                                        });
                                        if (!LPMBBAvailableForInStorePickup && !LPMBBIsInStoreOnly) {
                                            _this.model.set('isError', true);
                                            _this.model.set('errorLocation', 'body');
                                            _this.model.set('errorMessage', CCRZ.pagevars.pageLabels['LPM_BB_No_Stores_Found']);
                                        }
                                    }
                                    let empty = true;
                                    storeList.forEach(function (store) {
                                        if (!(store.Status == 'OUT_OF_STOCK' || !store.hasQuantityNetworkWide || (!store.c_enableBopis && !store.c_enableSts))) {
                                            empty = false;
                                        }
                                    });

                                    if (empty) {
                                        _this.model.set('isError', true);
                                        _this.model.set('errorLocation', 'body');
                                        _this.model.set('errorMessage', CCRZ.pagevars.pageLabels['LPM_BB_No_Stores_Found']);
                                    }

                                }

                                if (!_.isEmpty(selectedStoreList)) {
                                    _this.model.set('selectedStoreList', selectedStoreList);
                                    if (_this.model.get('isPDP')) {
                                        CCRZ.productDetailModel.set('selectedStore', selectedStoreList[0]);
                                    }
                                } else {
                                    if (_this.model.get('isPDP')) {
                                        CCRZ.productDetailModel.set('selectedStore', '');
                                    }
                                }

                                _this.model.set('differentStoreName', ''); //TBC
                            }
                        } else if (res && !res.success && !res.data.validZip) {
                            // _this.model.set('selectedStoreName', 'Select A Store');
                            // _this.model.set('selectedStoreZip', '');
                            // _this.model.set('defaultUserZip', '');
                            // CCRZ.productDetailModel.set('selectedStore', '');
                        } else {
                            _this.model.set('isError', true);
                            _this.model.set('errorLocation', 'body');
                            _this.model.set('errorMessage', CCRZ.pagevars.pageLabels['LPM_BB_Store_Not_Available']);
                            CCRZ.productDetailModel.set('selectedStore', '');
                        }
                        if (isOpenModal) {
                            _this.closeZipModal();
                            _this.openModal();
                        } else {
                            _this.closeModal();
                            _this.closeZipModal();
                        }
                        _this.checkDeliveryZip();

                        //Default session store
                        let tempSelectedStoreName = _this.model.get('selectedStoreName');
                        if(tempSelectedStoreName == undefined ||tempSelectedStoreName == '' || tempSelectedStoreName == 'Select A Store'){
                            _this.defaultSessionStore();
                        }
                        if (isUpdatePDP) {
                            CCRZ.prodDetailView.render();
                        }
                        _this.render();
                        if (typeof callback === 'function') {
                            callback();
                        }
                    });
                },
                fetch: function () {
                    let _this = this;
                    _this.model.fetchInit(function (res, evt) {
                        if (res && res.success && !_.isEmpty(res.data)) {
                            let zipCode = _this.parseZip(res.data.storeZipCode);
                            _this.model.set('isStoreAvailable', true);
                            _this.setStoreInfo(_this, res.data.storename, zipCode, true);
                        } else if (_this.isSessionData('storeData')) {
                            let storeData = JSON.parse(_this.getSessionData('storeData'));
                            _this.model.set('selectedStoreName', storeData.storename);
                            _this.model.set('selectedStoreZip', storeData.zip);
                            _this.model.set('defaultUserZip', storeData.zip);
                        } else if (navigator.geolocation) {
                            navigator.geolocation.getCurrentPosition(_this.fetchGeo.bind(_this), _this.selectAStore.bind(_this));
                        } else {
                            _this.model.set('selectedStoreName', 'Select A Store');
                            _this.model.set('selectedStoreZip', '');
                            _this.model.set('defaultUserZip', '');
                        }

                        if(res && !_.isEmpty(res.data)) {
                            _this.model.set('isDeliveryZipError', false);
                            if(res.data.selectedDeliveryZip) {
                                let selectedDeliveryZip = res.data.selectedDeliveryZip;
                                let zipCode = _this.parseZip(res.data.storeZipCode);
                                if(selectedDeliveryZip != zipCode) {
                                    _this.model.set('isDeliveryZipError', true);
                                    _this.model.set('isDeliveryZipErrorMsg', globalDeliveryMsg);
                                }
                                _this.model.set('selectedDeliveryZip', selectedDeliveryZip);
                            } else {
                                _this.model.set('selectedDeliveryZip', '');
                            }

                        }
                        _this.closeModal();
                        _this.closeZipModal();
                        //Default session store
                        let tempSelectedStoreName = _this.model.get('selectedStoreName');
                        if(tempSelectedStoreName == undefined ||tempSelectedStoreName == '' || tempSelectedStoreName == 'Select A Store'){
                            _this.defaultSessionStore();
                        } else {
                            setTimeout(function () {
                                _this.render();
                            }, 1000);
                        }
                    });
                },
                selectAStore: function () {
                    let _this = this;
                    _this.model.set('selectedStoreName', 'Select A Store');
                    _this.model.set('selectedStoreZip', '');
                    _this.model.set('defaultUserZip', '');
                    _this.closeModal();
                    setTimeout(function () {
                        _this.render();
                    }, 1000);
                },
                fetchGeo: function (position) {
                    let _this = this;
                    let lat = position.coords.latitude;
                    let long = position.coords.longitude;
                    let userId = CCRZ.currentUser.ContactId;
                    _this.model.fetchStoreByGeo(userId, lat, long, function (res, evt) {
                        _this.model.set('isError', false);
                        if (res && res.success) {
                            let responseData = res.data;
                            _this.model.set('selectedStoreName', responseData.name);
                            _this.model.set('selectedStoreZip', responseData.postal_code.substring(0, 5));
                            _this.model.set('defaultUserZip', responseData.postal_code.substring(0, 5));
                            _this.setStoreInfo(_this, responseData.name, responseData.postal_code.substring(0, 5), false);
                        } else {
                            _this.model.set('selectedStoreName', 'Select A Store');
                            _this.model.set('selectedStoreZip', '');
                            _this.model.set('defaultUserZip', '');
                        }
                        _this.closeModal();
                        setTimeout(function () {
                            _this.render();
                        }, 1000);
                        //_this.openModal();
                        //_this.render();
                    });
                },
                saveStore: function () {
                    let userId = CCRZ.currentUser.ContactId, dataset = event.target.dataset, _this = this;
                    let storeId = dataset.storeid, address1 = dataset.storeaddress1, name = dataset.storename
                        , city = dataset.storecity, country_code = dataset.countrycode,
                        distance = parseFloat(dataset.distance)
                        , distance_unit = dataset.distanceunit, latitude = parseFloat(dataset.storelatitude)
                        , longitude = parseFloat(dataset.storelongitude), phone = dataset.storephonenumber
                        , postal_code = dataset.storepostalcode, state_code = dataset.storestatecode,
                        store_hours = dataset.storehours, timezone = dataset.timezone
                        , zip = $.trim($(event.target).closest('.Select_stores').find('#select_store_zipCode').val())
                        , zipCode = _this.parseZip(postal_code)
                        , isAggregate = !!$('.aggregate-product-type').length;

                    let saveAsDefault = $(event.target).parent().find('.saveAsDefault').prop('checked');

                    if (_this.model.get('isSave') || saveAsDefault) {
                        let data = JSON.stringify({
                            "uid": userId,
                            "zip": zip,
                            "id": storeId,
                            "address1": address1,
                            "name": name,
                            "city": city,
                            "country_code": country_code,
                            "distance": distance,
                            "distance_unit": distance_unit,
                            "latitude": latitude,
                            "longitude": longitude,
                            "phone": phone,
                            "postal_code": postal_code,
                            "state_code": state_code,
                            "store_hours": store_hours,
                            "timezone": timezone
                        });
                        _this.model.saveSelectedStore(data, function (res, event) {
                            if (res && res.success && res.data) {
                                _this.setStoreInfo(_this, name, zipCode, false);
                                _this.model.set('isSave', false);
                                window.location.reload();
                            } else {
                                _this.model.set('isError', true);
                                _this.model.set('errorLocation', 'header');
                                _this.model.set('errorMessage', 'Error Adding the selected Store');
                                _this.render();
                            }
                        });
                    } else {
                        if (_this.model.get('isSelectedStore')) {
                            _this.setStoreInfo(_this, name, zipCode, false);
                        }
                        _this.closeModal();
                        let storeList = _this.model.get('storeList'),
                            selectedStore = storeList.filter(function (store) {
                                return store.id == storeId;
                            });
                        if (selectedStore.length <= 0) {
                            selectedStore = _this.model.get('selectedStoreList');
                            selectedStore['hideSequence'] = true;
                        }
                        selectedStore['isSelectedStore'] = true;
                        _this.model.set('selectedStoreList', selectedStore);
                        if (_this.model.get('isPDP')) {
                            _this.model.set('isPDP', false);
                            CCRZ.productDetailModel.set('selectedStore', selectedStore[0]);
                            if (CCRZ.productDetailModel.attributes.product.prodBean.LPMBBAvailableForInStorePickup) {
                                CCRZ.productDetailModel.set('selectedShipType', 'store');
                            }
                            _this.setStoreInfo(_this, name, zipCode, false);
                            _this.render();
                            if (isAggregate) {
                                // UTIL.showLoader();
                                let id = $("select.aggSelection option:selected").val();
                                if(id) {
                                    CCRZ.aggregateView.renderSelectedProduct(id);
                                } else {
                                    CCRZ.pubSub.trigger('prodDetailRefresh', CCRZ.productDetailModel.attributes.product.prodBean);
                                }
                            } else {
                                let inputData = {
                                    'zipCode': zipCode,
                                    'itemID': CCRZ.productDetailModel.attributes.product.prodBean.SKU,
                                    'quantity': 1,
                                    'isHome': false
                                }
                                CCRZ.pubSub.trigger('fetchPromiseDate', inputData);
                            }
                        } else if (_this.model.get('isCart')) {
                            UTIL.showLoader();
                            _this.model.set('isCart', false);
                            let cartItemData = _this.model.get('cartItemData');
                            let reqData = {
                                "cartId": CCRZ.cartDetailView.model.attributes.sfid,
                                "cartItemId": cartItemData.sfid,
                                "shipType": 'store',
                                "storeName": selectedStore[0].name,
                                "address1": selectedStore[0].address1,
                                "city": selectedStore[0].city,
                                "stateCode": selectedStore[0].state_code,
                                "countryCode": selectedStore[0].country_code,
                                "postalCode": selectedStore[0].postal_code,
                                "phone": selectedStore[0].phone,
                                "storeId": selectedStore[0].id,
                                "storeHours": selectedStore[0].store_hours,
                                "storeTimezone": selectedStore[0].c_storeTimezone,
                                "isStoreQuantity": (selectedStore[0].Quantity >= cartItemData.quantity) ? true : false
                            }
                            if (!cartItemData.cartItemGroupR.isStorePickup ||
                                (cartItemData.cartItemGroupR.isStorePickup && selectedStore[0].name != cartItemData.cartItemGroupR.groupName)) {
                                CCRZ.cartDetailView.setCartItemGroup(reqData);
                            } else {
                                CCRZ.cartDetailView.render();
                                CCRZ.storeView.render();
                            }
                        } else {
                            _this.render();
                        }
                    }
                },
                handleQuantity: function () {
                    let _this = this;
                    if (_this.model.get('isPDP')) {
                        CCRZ.storeView.model.set('isPDP', false);
                        let newQty = $.trim($('#qty').val());

                        let selectedStoreList = _this.model.get('selectedStoreList');
                        if (!_.isEmpty(selectedStoreList)) {

                            selectedStoreList[0].pdpNewQty = newQty;
                            selectedStoreList[0].hasQuantityNetworkWide = true;
                            _this.model.set('selectedStoreList', selectedStoreList);
                            let shipType = CCRZ.productDetailModel.get('selectedShipType');
                            CCRZ.productDetailModel.set('selectedShipType', (selectedStoreList[0].hasQuantityNetworkWide ? (shipType == '' ? (CCRZ.productDetailModel.attributes.product.prodBean.LPMBBIsInStoreOnly ? 'store' : 'home') : shipType) : CCRZ.productDetailModel.attributes.product.prodBean.LPMBBIsInStoreOnly ? '' : 'home'));
                            CCRZ.productDetailModel.set('selectedStore', selectedStoreList[0]);
                            CCRZ.productDetailModel.set('quantity', newQty);
                        }
                        if (!_this.model.get('aggregateProductType')) {
                            CCRZ.prodDetailView.render();
                        } else {
                            var currentProductId = $("select.aggSelection option:selected").val();
                            if (currentProductId) {
                                CCRZ.aggregateView.renderSelectedProduct(currentProductId);
                            }
                        }
                    }
                    _this.render();
                },
                handleSubscription: function () {
                    let _this = this;

                    let subProdTerms = CCRZ.productDetailModel.get('subProdTerms');
                    for (let i = 0; i < subProdTerms.length; i++) {
                        if (subProdTerms[i].checked = "checked") {
                            subProdTerms[i].checked = "";
                        }
                    }
                    if ($(".subscriptionInputOption:checked").val() == 'nosuboption') {
                        CCRZ.productDetailModel.set('showPickupSubscription', true);
                        CCRZ.productDetailModel.set('subTermId', 'nosuboption');
                        for (let i = 0; i < subProdTerms.length; i++) {
                            if (subProdTerms[i].CC_NO_SUBSCRIPTION) {
                                subProdTerms[i].checked = "checked";
                            }
                        }
                    } else {
                        CCRZ.productDetailModel.set('selectedShipType', 'home');

                        CCRZ.productDetailModel.set('showPickupSubscription', false);
                        for (let i = 0; i < subProdTerms.length; i++) {
                            if (subProdTerms[i].sfid == $(".subscriptionInputOption:checked").val()) {
                                subProdTerms[i].checked = "checked";
                                CCRZ.productDetailModel.set('subTermId', subProdTerms[i].sfid);
                            }
                        }
                    }
                    CCRZ.productDetailModel.set('subProdTerms', subProdTerms);
                    CCRZ.prodDetailView.render();
                },
                setStoreInfo: function (_this, storename, zip, isRetrieve) {
                    if (_this.isSessionData('storeData') && isRetrieve) {
                        let storeData = JSON.parse(_this.getSessionData('storeData'));
                        _this.model.set('selectedStoreName', storeData.storename);
                        _this.model.set('selectedStoreZip', storeData.zip);
                    } else {
                        if (typeof storename !== 'undefined') {
                            _this.model.set('selectedStoreName', storename);
                        }
                        _this.model.set('selectedStoreZip', zip);
                        _this.model.set('defaultUserZip', zip);
                        _this.setSessionData(storename, zip);
                    }
                },
                handleMapToggle: function () {
                    let storeMap = $(event.target).closest('.lpm_header_SelStore').find('.sStoreMap');
                    if (storeMap.hasClass('hide')) {
                        $('.toggle-map-text').text('Hide Map');
                        storeMap.removeClass('hide');
                        storeList = this.model.get('storeList');
                        const myLatLng = {lat: storeList[0].latitude, lng: storeList[0].longitude};
                        const map = new google.maps.Map(storeMap[0], {
                            zoom: 10,
                            center: myLatLng,
                        });
                        if (!UTIL.isIE()) {
                            for (let i = 0; i < storeList.length; i++) {
                                let LatLng = {lat: storeList[i].latitude, lng: storeList[i].longitude};
                                let marker = new google.maps.Marker({
                                    position: LatLng,
                                    map: map,
                                    title: storeList[i].name,
                                    label: {
                                        color: '#000', /*fontSize: '12px', fontWeight: '600',*/
                                        text: String(i + 1)
                                    }
                                });
                                marker.addListener("click", function () {
                                    $('.highlighted-storebox').removeClass('highlighted-storebox');
                                    $("div[data-store-id='" + storeList[i].id + "']").addClass('highlighted-storebox');
                                });
                            }
                        }
                    } else {
                        storeMap.addClass('hide');
                        $('.toggle-map-text').text('Show Map');
                    }

                },
                handleStoreLocator: function () {
                    $(".storeLocatorInfo").empty();
                    $(".storeLocatorError").addClass('hide');
                    let storeLocatorZip = $.trim($('#store_locator_zipCode').val());
                    let storeLocatorRadius = $.trim($('#store_locator_radius_id').val());
                    let isIE = UTIL.isIE();

                    if (this.isValidZip(storeLocatorZip)) {
                        let _this = this;
                        _this.model.fetchStores(JSON.stringify({
                            zip: storeLocatorZip,
                            radius: storeLocatorRadius
                        }), function (res, evt) {
                            if (res && res.success && res.data) {
                                let responseData = JSON.parse(res.data.storesAPI), storeData = responseData['data']
                                    , storeList = [], selectedStoreList = [];
                                if (storeData && storeData.length > 0) {
                                    let storeList = storeData;
                                    let myLatLng = null;
                                    let map = null;
                                    if (!isIE) {
                                        myLatLng = {lat: storeList[0].latitude, lng: storeList[0].longitude};
                                        map = new google.maps.Map(document.getElementById("storeLocatorMap"), {
                                            zoom: 10,
                                            center: myLatLng,
                                        });
                                    } else {
                                        $('#storeLocatorMap').hide();
                                    }

                                    for (let i = 0; i < storeList.length; i++) {
                                        let openHoursString = _this.openHours(storeList[i].store_hours, storeList[i].c_storeTimezone);
                                        let HoursString = _this.getStoreHours(storeList[i].store_hours);
                                        let storeCard = "<div class='store-locator-container col-12 col-md-6 col-lg-4'><div class='card result-card'"
                                        storeCard += " data-store-id='" + storeList[i].id + "'";
                                        storeCard += "><div class='StName'><strong>";
                                        storeCard += Number(i + 1) + '. ' + storeList[i].name;
                                        storeCard += "</strong><br></div><div class='stPhone'><a href='tel:" + storeList[i].phone + "'><strong>";
                                        storeCard += storeList[i].phone;
                                        storeCard += "</br></strong></a></div><div class='distance_m'>";
                                        storeCard += storeList[i].distance + ' ' + storeList[i].distance_unit;
                                        storeCard += "</div><div class='addDiv' style='width:80%'>";
                                        storeCard += storeList[i].address1;
                                        storeCard += "<br><p>";
                                        storeCard += storeList[i].city + ', ' + storeList[i].state_code + '-' + storeList[i].postal_code;
                                        storeCard += "</p></div>" + openHoursString;
                                        storeCard += "<div class='show-more'><p class='show_hide' id='storeLocator";
                                        storeCard += storeList[i].id;
                                        storeCard += "'>Store Details</p></div><div class='contentHours' style='display:none' id='";
                                        storeCard += 'storeLocator' + storeList[i].id + 'Hidden';
                                        storeCard += "' style='display: block;'><div class='hoursDiv'>Hours</div><br><div class='StHoursshow'>";
                                        storeCard += HoursString;
                                        storeCard += "</div><div class='StAddressLoc'><span><i class='fa fa-map-marker' id='btn_storeLocator_LocIcon' aria-hidden='true' style='margin-right:5px' ></i><a href=\"https://maps.google.com/?daddr='";
                                        storeCard += storeList[i].address1;
                                        storeCard += "\" id='btn_GetLoc' target='_blank' rel='noopener'>Get Directions</a></span></div></div>";
                                        storeCard += "</div></div>";
                                        $(".storeLocatorInfo").append(storeCard);

                                        $('#storeLocator' + storeList[i].id).on("click", function (e) {
                                            let $link = $(e.target);
                                            let $details;
                                            if ($link.length) {
                                                $details = $link.parent().siblings('.contentHours');
                                                $details.toggle();
                                                if ($link.hasClass('open')) {
                                                    $link.removeClass('open').text('Store Details');
                                                } else {
                                                    $link.addClass('open').text('Close Details');
                                                }
                                            }
                                        });

                                        if (myLatLng && map) {
                                            let LatLng = {lat: storeList[i].latitude, lng: storeList[i].longitude};
                                            let marker = new google.maps.Marker({
                                                position: LatLng,
                                                map: map,
                                                title: storeList[i].name,
                                                label: {
                                                    color: '#000', /*fontSize: '12px', fontWeight: '600',*/
                                                    text: String(i + 1)
                                                }
                                            });
                                            marker.addListener("click", function () {
                                                $('.highlighted-storebox').removeClass('highlighted-storebox');
                                                $("div[data-store-id='" + storeList[i].id + "']").addClass('highlighted-storebox');
                                                $('html, body').animate({
                                                    scrollTop: $("div[data-store-id='" + storeList[i].id + "']").offset().top
                                                }, 500);

                                            });
                                        }
                                    }
                                }
                                if(_this.model.get('isCart') && res.data.selectedDeliveryZip != undefined) {
                                    _this.model.set('selectedDeliveryZip', res.data.selectedDeliveryZip);
                                }
                            } else {
                                let errorMessage = CCRZ.pagevars.pageLabels['LPM_BB_Store_Not_Available'];
                                $(".storeLocatorError").removeClass('hide');
                                $(".storeLocatorError").text(errorMessage);
                            }

                        });
                    } else {
                        let errorMessage = storeLocatorZip == '' ? 'Zipcode is a required field' : 'Enter a valid zip code';
                        $(".storeLocatorError").removeClass('hide');
                        $(".storeLocatorError").text(errorMessage);
                    }


                },
                openHours: function (storeHours, storeTimeZone) {
                    let returnedHtml = '';
                    if (storeHours != null) {
                        let dayMap = {
                            'Mon': 'Monday',
                            'Tue': 'Tuesday',
                            'Wed': 'Wednesday',
                            'Thu': 'Thursday',
                            'Fri': 'Friday',
                            'Sat': 'Saturday',
                            'Sun': 'Sunday',
                        }
                        //mapping of us timezones to iana timezone format
                        let tzMap = {
                            "AST": "America/Puerto_Rico",
                            "EST": "America/Jamaica",
                            "CST": "America/Costa_Rica",
                            "MST": "America/Phoenix",
                            "PST": "America/Los_Angeles",
                            "AKST": "America/Anchorage",
                            "HAST": "Pacific/Honolulu",
                            "SST": "Pacific/Pago_Pago",
                            "CHST": "Pacific/Guam"
                        };
                        let storeOpenHours = storeHours.split('*');
                        let d = new Date(Date.now());
                        let dayName = d.toString().split(' ')[0];
                        let todayDayName = dayMap[dayName];
                        var weekday = new Array(7);
                        weekday[0] = "Sunday";
                        weekday[1] = "Monday";
                        weekday[2] = "Tuesday";
                        weekday[3] = "Wednesday";
                        weekday[4] = "Thursday";
                        weekday[5] = "Friday";
                        weekday[6] = "Saturday";
                        var tomorrow = new Date(d.getTime() + 24 * 60 * 60 * 1000);
                        let tomorrowName = weekday[tomorrow.getDay()];
                        let tomOpenTime = "";
                        for (let i = 0; i < storeOpenHours.length; i++) {
                            let openClosesHoues = storeOpenHours[i].split(':');
                            let storeDayName = openClosesHoues[0];

                            if ($.trim(storeDayName) == tomorrowName) {
                                if ($.trim(openClosesHoues[1]) == 'Closed') {
                                    tomorrowName = 'Monday';
                                    for (let j = 0; j < storeOpenHours.length; j++) {
                                        let openClosesHoues1 = storeOpenHours[j].split(':');
                                        let storeDayName1 = openClosesHoues1[0];
                                        if ($.trim(storeDayName1) == tomorrowName) {
                                            tomOpenTime = openClosesHoues1[1].split('-')[0];

                                        }
                                    }
                                } else {
                                    let openCloseTime = openClosesHoues[1].split('-');
                                    tomOpenTime = openCloseTime[0];
                                }
                            }
                        }

                        for (let i = 0; i < storeOpenHours.length; i++) {
                            let openClosesHoues = storeOpenHours[i].split(':');
                            let storeDayName = openClosesHoues[0];
                            if ($.trim(storeDayName) == todayDayName) {
                                if ($.trim(openClosesHoues[1]) == 'Closed') {
                                    returnedHtml += '<div><span><strong style="color: red;">Closed </strong> Opens ' + tomorrowName + '  at  ' + tomOpenTime + '</span></div>';
                                } else {
                                    let openCloseTime = openClosesHoues[1].split('-');
                                    let openTime = openCloseTime[0];
                                    let closeTime1 = openCloseTime[1];

                                    // en-GB uses day-month-year order and 24-hour time without AM/PM  "20/12/2012 03:00:00"
                                    let localeString = new Date(Date.now()).toLocaleString('en-GB', {timeZone: tzMap[storeTimeZone] || "UTC"}).trim();
                                    //IE returns localestring with spaces instead of comma, so need to handle both scenarios
                                    let today = localeString.indexOf(",") > 0 ? localeString.split(",") : localeString.split(" ");
                                    let currentTime = today[1].toString();
                                    let h = Number(currentTime.split(':')[0]);

                                    //let h = d.getHours();
                                    let closeTimeHours;
                                    if (typeof closeTime1 != "undefined") {
                                        let cth = closeTime1.trim().split(' ');
                                        closeTimeHours = parseInt(cth[0]);
                                        closeTimeHours += 12;
                                    }

                                    if (h < openTime.trim().split(' ')[0]) {

                                        returnedHtml += '<div><span><strong style="color: red;">Closed </strong> Opens ' + todayDayName + ' at ' + openTime.trim() + '</span></div>';

                                    } else if (h >= closeTimeHours) {
                                        returnedHtml += '<div><span><strong style="color: red;">Closed </strong> Opens ' + tomorrowName + ' at ' + tomOpenTime + '</span></div>';
                                    } else {
                                        returnedHtml += '<div><span><strong style="color: #005A1C;">Open </strong> Closes ' + closeTime1 + '</span></div>';
                                    }
                                }


                            }

                        }
                    }
                    return returnedHtml;
                },
                getStoreHours: function (storeHours) {
                    if (storeHours != null) {
                        let returnedHtml = '';
                        let storeOpenHours = storeHours.split('*');

                        for (let i = 0; i < storeOpenHours.length; i++) {
                            let eachHoursSlot = storeOpenHours[i];
                            eachHoursSlot = eachHoursSlot.replace(':', ' ');
                            returnedHtml += storeOpenHours[i] + '<br>';
                        }
                        let text = returnedHtml.replace(/(\r\n|\n|\r)/gm, '<br>');
                        return new Handlebars.SafeString(text);
                    }
                },
                isSessionData: function (sessionName) {
                    return (window.localStorage.length > 0 && this.getSessionData(sessionName) != null);
                },
                getSessionData: function (sessionName) {
                    return window.localStorage.getItem(sessionName);
                },
                setSessionData: function (storename, zip) {
                    window.localStorage.setItem('storeData', JSON.stringify({'storename': storename, 'zip': zip}));
                },
                closeStore: function () {
                    this.closeModal();
                    this.render();
                },
                openModal: function () {
                    CCRZ.storeView.model.set('isOpen', true);
                    $('#sidebarBackdrop').removeClass('hide');
                },
                closeModal: function () {
                    CCRZ.storeView.model.set('isSave', false);
                    CCRZ.storeView.model.set('isOpen', false);
                    $('#sidebarBackdrop').addClass('hide');
                },
                isValidZip: function (zip) {
                    let regEx = /^\d{5}(?:[\s-]\d{4})?$/, isValid = regEx.test(zip);
                    return isValid;
                },
                parseZip: function (zipRange) {
                    let zipCode = '';
                    if (zipRange && zipRange != null && zipRange != '') {
                        let zipList = zipRange.split('-');
                        if (zipList != null && zipList.length > 0) {
                            zipCode = zipList[0];
                        }
                    }
                    return zipCode;
                },
                openZipEntry: function() {
                    $('.Header_mobileDropDown').addClass('hide');
                    this.openZipModal();
                    this.render();
                },
                openZipModal: function() {
                    CCRZ.storeView.model.set('isOpen', false);
                    CCRZ.storeView.model.set('isOpenZipModal', true);
                    $('#sidebarBackdrop').removeClass('hide');
                },
                closeZipEntry: function() {
                    this.closeZipModal();
                    this.render();
                },
                closeZipModal: function() {
                    CCRZ.storeView.model.set('isOpenZipModal', false);
                    $('#sidebarBackdrop').addClass('hide');
                },
                handleDeliveryZipKeyDown:function() {
                    let _this = this;
                    if (event.keyCode === 13) {
                        _this.handleSaveZip();
                    }
                },
                handleSaveZip: function() {
                    var newZip = $(event.currentTarget).find('#update_delivery_zipCode').val();
                    let isnum = /^\d+$/.test(newZip);
                    if(newZip.length == 5 && isnum) {
                        UTIL.showLoader();
                        var controller = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_HeaderController'});
                        controller.invokeCtx('updateDeliveryZip', newZip, function (resp) {
                            let tempModel = CCRZ.storeView.model;
                            let newZipData = resp.data;
                            if (resp.success) {
                                tempModel.set('isDeliveryZipError', false);
                                tempModel.set('selectedDeliveryZip', newZipData);
                                CCRZ.storeView.render();
                                if(tempModel.get('isPDP')) {
                                    let inputData = {
                                        'zipCode': newZipData,
                                        'itemID': CCRZ.productDetailModel.attributes.product.prodBean.SKU,
                                        'quantity': 1,
                                        'isHome': true
                                    }
                                    CCRZ.storeView.closeZipModal();
                                    CCRZ.pubSub.trigger('fetchPromiseDate', inputData);
                                }
                            } else {
                                console.log("error: " + resp.data);
                                tempModel.set('isDeliveryZipError', true);
                                UTIL.hideLoader();
                                CCRZ.storeView.render();
                            }
                        }, {
                            buffer: false,
                            escape: false,
                            nmsp: false
                        });
                    } else {
                        var errorMsg = 'Please add a valid zip code';
                        $(event.currentTarget).find('#deliveryErrorMsg').text(errorMsg);
                    }


                },
                checkDeliveryZip: function() {
                    let _this = this;
                    _this.model.set('isDeliveryZipError', false);

                    let selectedDeliveryZip = _this.model.get('selectedDeliveryZip');
                    let zipCode = _this.model.get('selectedStoreZip');
                    if(selectedDeliveryZip != zipCode && CCRZ.pagevars.currentPageName !== 'ccrz__Checkout') {
                        _this.model.set('isDeliveryZipError', true);
                        _this.model.set('isDeliveryZipErrorMsg', globalDeliveryMsg);
                        $('[data-toggle="tooltip"].deliveryZipBtn').tooltip('show');
                    } else {
                        _this.model.set('isDeliveryZipError', false);
                        $('[data-toggle="tooltip"].deliveryZipBtn').tooltip('hide');
                    }

                },
                closeToolTip:function() {
                    $('[data-toggle="tooltip"].deliveryZipBtn').tooltip('hide');
                },
                toggleMobileModal:function() {
                    $('#sidebarBackdrop').removeClass('hide');
                    $('.Header_mobileDropDown').removeClass('hide');
                },
                updateStoreInvStatus:function(store, storeList, selectedStoreList, _this) {
                    let storeHours = store.store_hours;
                    let storeHoursparsed = JSON.parse(store.c_storeHoursJSON).storeHours;
                    let storeTimeZone = store.c_storeTimezone;

                    let pickupOffset = parseInt(CCRZ.pagevars.pageConfig.get('c.pickupoffset'));

                    let dayMap = {};
                    if (storeHours != null) {
                        dayMap = {
                            'Mon': 'monday',
                            'Tue': 'tuesday',
                            'Wed': 'wednesday',
                            'Thu': 'thursday',
                            'Fri': 'friday',
                            'Sat': 'saturday',
                            'Sun': 'sunday'
                        };
                    }

                    let tzMap = {
                        "AST": "America/Puerto_Rico",
                        "EST": "America/Jamaica",
                        "CST": "America/Costa_Rica",
                        "MST": "America/Phoenix",
                        "PST": "America/Los_Angeles",
                        "AKST": "America/Anchorage",
                        "HAST": "Pacific/Honolulu",
                        "SST": "Pacific/Pago_Pago",
                        "CHST": "Pacific/Guam"
                    };
                    //get the current day's weekday name in shorten format
                    //let storeHourEachDay = storeHours.split('*'); //array of Monday : 10 AM - 6 PM
                    let d = new Date(Date.now()); //Wed Feb 10 2021 21:34:49 GMT-0500 (Eastern Standard Time)
                    let weekDayName = d.toString().split(' ')[0]; // Wed

                    // converting current time to store's timezone
                    // en-GB uses day-month-year order and 24-hour time without AM/PM  "20/12/2012 03:00:00"
                    let localeString = new Date(Date.now()).toLocaleString('en-GB', {timeZone: tzMap[storeTimeZone] || "UTC"}).trim();
                    //IE returns localestring with spaces instead of comma, so need to handle both scenarios
                    let today = localeString.indexOf(",") > 0 ? localeString.split(",") : localeString.split(" ");
                    let currentTime = today[1].toString();
                    //IE can return time strings with unexpected characters so have to sanatize
                    let currentHour = Number(currentTime.split(':')[0].replace(/\D/g, ''));

                    //added dst offset
                    const jan = new Date(0, 1);
                    const jul = new Date(6, 1);
                    const currentTimezoneOffset = Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
                    const currentDay = new Date();
                    if (currentDay.getTimezoneOffset() < currentTimezoneOffset) {
                        currentHour += 1;
                    }

                    let todayDayName = dayMap[weekDayName]; //convert Wed to wednesday

                    let currentWeekdayHours = storeHoursparsed[todayDayName]; //currentWeekdayHours.open = 10:00 currentWeekdayHours.close = '18:00
                    if (currentWeekdayHours.open == '0:00') {
                        store.pickupStatus = 'Tomorrow';
                    } else {
                        openingHour = Number(currentWeekdayHours.open.split(':')[0]); //10 from 10:00
                        closingHour = Number(currentWeekdayHours.close.split(':')[0]); //18 from 18:00
                        if (currentHour + pickupOffset < closingHour) {
                            store.pickupStatus = 'Today';
                        } else {
                            store.pickupStatus = 'Tomorrow';
                        }
                    }

                    let currentQty = 0;
                    if (_this.model.get('isCart')) {
                        currentQty = _this.model.get('currentProdQuantity', 0);
                    } else {
                        currentQty = $.trim($('#qty').val());
                    }

                    //let pdpQty = $.trim($('#qty').val());
                    if (store.Quantity < currentQty) {
                        store.Status = 'OUT_OF_STOCK';
                    } else {
                        store.Status = 'AVAILABLE';
                    }

                    store.hasQuantityNetworkWide = true;

                    if ((_this.model.get('pdpStoreName') == store.name && _this.model.get('isPDP'))
                        || (_this.model.get('isCart') && store.name == _this.model.get('cartStoreName'))
                        || (_this.model.get('selectedStoreName') == store.name && _this.model.get('isSelectedStore'))) {
                        if ((store.c_enableSts && store.c_enableBopis)) {
                            store['hideBtn'] = false;
                            store['hideSequence'] = true;
                            store['isSelectedStore'] = true;
                            selectedStoreList.push(store);
                        } else {
                            store['hideBtn'] = true;
                            storeList.push(store);
                        }
                    } else {
                        if ((!store.c_enableSts || !store.c_enableBopis)) {
                            store['hideBtn'] = true;
                        }
                        storeList.push(store);
                    }
                },
                defaultSessionStore:function() {
                    let _this = this;
                    let deliveryZip = _this.model.attributes.selectedDeliveryZip;
                    let inStoreAvailable = false;

                    if (CCRZ.productDetailModel && CCRZ.productDetailModel.attributes && CCRZ.productDetailModel.attributes.product) {
                        let prodBean = CCRZ.productDetailModel.attributes.product.prodBean;
                        inStoreAvailable = prodBean.LPMBBAvailableForInStorePickup;
                    }

                    if (CCRZ.pagevars.currentPageName == 'ccrz__ProductDetails' && inStoreAvailable) {
                        let reqData = {
                            'zip': deliveryZip,
                            'radius': '30',
                            'sku': _this.model.get('productSKU')
                        };
                        _this.model.fetchStoresBySku(JSON.stringify(reqData), function (res, evt) {
                            if (res && res.success && res.data.storeData != undefined) {

                                _this.model.set('isStoreAvailable', true);
                                var responseData = JSON.parse(res.data.storeData);
                                var storeData = responseData['stores'];
                                var storeList = [];
                                var selectedStoreList = [];
                                var nearestStore = [];

                                if (storeData.length > 0) {
                                    nearestStore = storeData[0];
                                    storeData.splice(0, 1);
                                    _this.model.set("storeList", storeData);
                                    _this.model.set("selectedStoreList", nearestStore);
                                    var newZipCode = nearestStore.postal_code.substring(0, 5);
                                    _this.updateStoreInvStatus(nearestStore, storeList, selectedStoreList, _this);
                                    _this.model.set("selectedStoreName", nearestStore.name);
                                    _this.setStoreInfo(_this, nearestStore.name, newZipCode, false);
                                    CCRZ.productDetailModel.set('selectedStore', nearestStore);

                                    _this.render();
                                    let inputData = {
                                        'zipCode': newZipCode,
                                        'itemID': CCRZ.productDetailModel.attributes.product.prodBean.SKU,
                                        'quantity': 1,
                                        'isHome': false
                                    }
                                    CCRZ.pubSub.trigger('fetchPromiseDate', inputData);
                                }
                            }
                        });
                    } else {
                        _this.model.fetchStores(JSON.stringify({
                            zip: deliveryZip,
                            radius: '30'
                        }), function (res, evt) {
                            _this.model.set('isError', false);
                            if (res && res.success && res.data != undefined && (res.data.storesAPI != 'null' && res.data.storesAPI != undefined)) {
                                let responseData = JSON.parse(res.data.storesAPI);
                                let storeData = responseData['data'];
                                let nearestStore = [];
                                if (responseData.data.length > 0) {
                                    nearestStore = storeData[0];
                                    _this.model.attributes.selectedStoreName = nearestStore.name;
                                    _this.setStoreInfo(_this, nearestStore.name, nearestStore.postal_code.substring(0, 5), false);
                                    _this.render();
                                }
                            }
                        });
                    }
                }
            });

            CCRZ.storeView = new CCRZ.views.storeView({
                model: new storeModel()
            });

        }
    }
});