d("storeModel", ['ccrz', 'log'], function (CCRZ, log) {
    CCRZ.models.storeModel = CCRZ.CloudCrazeModel.extend({
        className: 'LPM_BB_HeaderController',
        fetchStores: function (reqData, callback) {
            var model = this;
            this.invokePageLoadingCtx(
                "getSelectStoreAvailability",
                reqData,
                function (response, event) {
                    callback(response, event);
                },
                {
                    buffer: false,
                    nmsp: false,
                    escape: false
                })
        },
        fetchStoresBySku: function (reqData, callback) {
            var model = this;
            this.invokePageLoadingCtx(
                "getAvailabilityBySKU",
                reqData,
                function (response, event) {
                    callback(response, event);
                },
                {
                    buffer: false,
                    nmsp: false,
                    escape: false
                })
        },
        fetchInit: function (callback) {
            var model = this;
            this.invokePageLoadingCtx(
                "getContactStore",
                function (response, event) {
                    callback(response, event);
                },
                {
                    buffer: false,
                    nmsp: false,
                    escape: false
                })
        },
        fetchStoreByGeo: function (userId, lat, lng, callback) {
            var model = this;
            this.invokePageLoadingCtx(
                "getStoreByGeo",
                userId,
                lat,
                lng,
                function (response, event) {
                    callback(response, event);
                },
                {
                    buffer: false,
                    nmsp: false,
                    escape: false
                })
        },
        checkStoreInfo: function (userId, callback) {
            var model = this;
            this.invokePageLoadingCtx(
                "CheckStoreInfo",
                userId,
                function (response, event) {
                    callback(response, event);
                },
                {
                    buffer: false,
                    nmsp: false,
                    escape: false
                })
        },
        saveSelectedStore: function (reqData, callback) {
            var model = this;
            this.invokePageLoadingCtx(
                "SaveSelectedStore",
                reqData,
                function (response, event) {
                    callback(response, event);
                },
                {
                    buffer: false,
                    nmsp: false,
                    escape: false
                })
        },
    });
    return CCRZ.models.storeModel;
});