d("productListPageView",['util', 'plpModel'], function(UTIL, productListModel) {

    return {

        extendproductListPageView: function() {
            let plpModel = new productListModel();
            if(CCRZ.productListPageView){
                CCRZ.productListPageView.headerView.setElement(CCRZ.uiProperties.productListPageView.header.selector);
                CCRZ.productListPageView.productItemsView.setElement(CCRZ.uiProperties.productListPageView.productItems.selector);
                CCRZ.productListPageView.footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);
                if(CCRZ.productListFilterView){
                    CCRZ.productListFilterView.render();
                    if(CCRZ.productListFilterView.specGroupsView){
                        CCRZ.productListFilterView.specGroupsView.render(); /// Add it for  for Product Specs
                        if(CCRZ.CategoryTree){
                            CCRZ.CategoryTree.render();
                        }
                    }
                }
                setTimeout(function(){
                    CCRZ.productListPageView.headerView.render();
                },1000);
                CCRZ.productListPageView.productItemsView.render();
                CCRZ.productListPageView.footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);
                CCRZ.productListPageView.footerView.render();
                CCRZ.CategoryTree.render();
                if(CCRZ.productListPageModel.attributes && CCRZ.pagevars.pageLabels) {
                    var rendered = CCRZ.productListPageModel.attributes.renderedCount;
                    var count = CCRZ.productListPageModel.attributes.prodCount;
                    $('.cc_product_results_tagline_container').text(CCRZ.pagevars.pageLabels.ProductList_ResultsTagline.replace('{0}', rendered).replace('{1}', count));
                }
            } else {
                CCRZ.productListPageViewWasRendered = false;
                CCRZ.pubSub.once("view:productListPageView:refresh", function(view) {
                    CCRZ.productListPageViewWasRendered = true;
                    CCRZ.productListPageView.headerView.setElement(CCRZ.uiProperties.productListPageView.header.selector);
                    CCRZ.productListPageView.productItemsView.setElement(CCRZ.uiProperties.productListPageView.productItems.selector);
                    CCRZ.productListPageView.footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);
                });
                CCRZ.pubSub.on("action:productsPageRenderAllViews", function() {
                    CCRZ.productListPageView.render();
                    CCRZ.productListPageView.headerView.render();
                    CCRZ.productListFilterView.specGroupsView.render(); /// Add it for  for Product Specs
                    CCRZ.productListPageView.productItemsView.render();
                    CCRZ.productListPageView.footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);
                    CCRZ.productListPageView.footerView.render();
                    CCRZ.CategoryTree.render();
                    if(CCRZ.productListPageModel.attributes && CCRZ.pagevars.pageLabels) {
                        var rendered = CCRZ.productListPageModel.attributes.renderedCount;
                        var count = CCRZ.productListPageModel.attributes.prodCount;
                        $('.cc_product_results_tagline_container').text(CCRZ.pagevars.pageLabels.ProductList_ResultsTagline.replace('{0}', rendered).replace('{1}', count));
                    }
                });
            }
            CCRZ.pubSub.once("view:productListFooter:refresh", function(footerView){
                footerView.renderDesktop = function() {
                    if(_.isUndefined(this.el)){
                        footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);
                    }
                    if(CCRZ.productListPageModel.attributes && CCRZ.pagevars.pageLabels) {
                        var rendered = CCRZ.productListPageModel.attributes.renderedCount;
                        var count = CCRZ.productListPageModel.attributes.prodCount;
                        $('.cc_product_results_tagline_container').text(CCRZ.pagevars.pageLabels.ProductList_ResultsTagline.replace('{0}', rendered).replace('{1}', count));
                    }
                    this.$el.html(this.template(this.model.toJSON()));
                    return this;
                }
                footerView.delegateEvents();
            });
            CCRZ.pubSub.once("view:productListHeader:refresh", function(headerView){
                headerView.renderDesktop = function() {
                    if(_.isUndefined(this.el)){
                        headerView.setElement(CCRZ.uiProperties.productListPageView.header.selector);
                    }
                    this.$el.html(this.template(this.model.toJSON()));
                    return this;
                }
                headerView.delegateEvents();
            });
            CCRZ.pubSub.once("view:productItemsView:refresh",function(itemsView){
                itemsView.renderDesktop = function() {
                    var v = this;
                    v.$el.empty();
                    v.delegateEvents();
                    if(_.isUndefined(v.el)){
                        itemsView.setElement(CCRZ.uiProperties.productListPageView.productItems.selector);
                    }
                    v.$el.toggleClass('cc_grid_container', v.model.get('layout') == 'grid');

                    var container = document.createDocumentFragment();
                    _.each(v.itemViews, function(item) {
                        container.appendChild(item.render().el);
                        if (v.model.get('layout') == 'grid' && (item.model.get('index') + 1) % 3 == 0) {
                            var clear = document.createElement("div");
                            clear.className = 'clearfix'
                            container.appendChild(clear);
                        }
                    });
                    v.$el.append(container);

                    if (this.pickerView) {
                        this.pickerView.render();
                    }
                    return this;
                }
                itemsView.delegateEvents();
                if(_.isUndefined(itemsView.el)){
                    setTimeout(function(){
                        itemsView.render();
                    }, 2000);
                } else {
                    itemsView.render();
                }

            });
            CCRZ.pubSub.on("view:productItemView:refresh",function(itemView){
                itemView.events['click .cc_add_to_btn'] = 'handleAddToCart';
                itemView.handleAddToCart = function(event){
                    UTIL.showLoader();
                    let qtyInput = $("#" + this.model.get('sfid') + "_qtyEntry"), qty = qtyInput.val();
                    let _this = this, sku = _this.model.get('SKU'), subTermId = null, price = _this.model.get('price');
                    if(qty != '' && parseInt(qty) > 0){
                        qty = parseInt(qty);
                        let productData = {
                            "sku": sku,
                            "quantity": qty + '',
                            "subTermId" : subTermId,
                            "parentSFID" : null,
                            "isMain" : true,
                            "shipType" : 'home',
                            "storeName" : 'Home',
                            "address1" : '',
                            "city" : '',
                            "stateCode" : '',
                            "countryCode" : '',
                            "postalCode" : '',
                            "phone" : '',
                            "storeId" : '',
                            "price" : price + '',
                            "subTotal" : (price * qty) + '',
                            "storeHours" : '',
                            "storeTimezone" : '',
                            "isStoreQuantity" : true,
                            "isPickUpLater":false,
                            "isGetPrice" : false,
                            "isFromWebStore": true
                        }, reqData = {
                            'cartEncId' : CCRZ.pagevars.currentCartID,
                            'products' : [productData]
                        }
                        plpModel.addToCart(JSON.stringify(reqData), function(res, evt){
                            if(res && res.success && res.data){
                                if(res.data.cartEncId){
                                    try{
                                        CCRZ.pagevars.currentCartID = res.data.cartEncId;
                                        CCRZ.pagevars.queryParams['cartId'] = res.data.cartEncId;
                                        CCRZ.pubSub.trigger('cartChange', res.data.cartEncId);
                                        CCRZ.productListPageView.headerView.render();

                                    }catch(err){

                                    }
                                    UTIL.hideLoader();
                                }
                            } else {
                                // Error handling
                                CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'Error Adding Product to the cart!'));
                                UTIL.hideLoader();
                            }
                        });
                    } else {
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'Invalid_Qty'));
                        UTIL.hideLoader();
                    }
                };
                itemView.delegateEvents();
                if(CCRZ.productListPageModel.attributes && CCRZ.pagevars.pageLabels) {
                    var rendered = CCRZ.productListPageModel.attributes.renderedCount;
                    var count = CCRZ.productListPageModel.attributes.prodCount;
                    $('.cc_product_results_tagline_container').text(CCRZ.pagevars.pageLabels.ProductList_ResultsTagline.replace('{0}', rendered).replace('{1}', count));
                }
            });
            CCRZ.pubSub.on("view:productItemsView:shouldRefresh", function(){
                $('.footer_page_size_control').val( CCRZ.productListPageModel.attributes.pageSize );
            });
            $('.footer_page_size_control').on('change', function(event) {
                var selection = $(event.target).val();
                CCRZ.productListPageModel.set("pageSize", parseInt(selection));
                CCRZ.pubSub.trigger("view:productItemsView:shouldRefresh");
            })

            $('body').on('click', '.productListHeader #mobileFilter', function(){
                var $filters = $('.filterContainer');
                if($filters.length) {
                    if(!$filters.find('.close').length) {
                        $filters.prepend('<button class="close"><span class="fa fa-close"></span><span class="sr-only">Close</span></button>');
                    }
                    $filters.addClass('open');
                }
            });
            $('body').on('click', '.filterContainer .close', function(){
                var $filters = $('.filterContainer');
                if($filters.length) {
                    $filters.removeClass('open');
                }
            });

            let isFilterRefreshed = false;
            CCRZ.pubSub.on("view:productListFilterView:refresh", function(filterView) {
                if(!_.isUndefined(filterView.specGroupsView)){
                    filterView.specGroupsView.setElement(CCRZ.uiProperties.productListFilterView.ListView.selector);
                }
                filterView.renderDesktop = function() {
                    this.$el.html(this.template());
                    if(!_.isUndefined(filterView.specGroupsView)){
                        filterView.specGroupsView.refreshView();
                    }
                    setTimeout(function(){
                        if(!_.isUndefined(filterView.specGroupsView)){
                            filterView.specGroupsView.postRender();
                        }
                    }, 3000);
                    return this;
                };
                filterView.delegateEvents();
                if(!isFilterRefreshed){
                    isFilterRefreshed = true;
                    filterView.render();
                }
            });


        }

    }


});