d("cartDetailView", ['util', 'cartModel'], function (UTIL, cartModel) {

    return {
        extendCartDetailView: function () {
            let cartMod = new cartModel();
            CCRZ.pagevars.updatedCartStoreHeader = false;
            CCRZ.cartDetailView.delegateEvents(_.extend(CCRZ.cartDetailView.events,
                {
                    "click #sendEmailBtn": this.overridenSendEmailBtn,


                }
            ));

            CCRZ.subsc = _.extend(CCRZ.subsc || {});

            // Loop through the messages and remove any duplicates
            CCRZ.pubSub.on("view:PageMessagesView:refresh", function (view) {
                let alerts = $('.alert.alert-danger');
                let newAlerts = [];
                if (alerts.size() > 0) {
                    for (var i = 0; i < alerts.length; i++) {
                        if (newAlerts.indexOf($(alerts[i]).text()) === -1 && $(alerts[i]).text() !== '') {
                            newAlerts.push($(alerts[i]).text());
                        } else {
                            $(alerts[i]).remove();
                        }
                    }
                }
            });

            CCRZ.pubSub.once("view:CartDetailView:refresh", function (view) {
                view.events['click .checkNearByStores'] = 'handleCheckStores';
                view.events['change input[type=radio]'] = 'handleShipTypeChange';
                view.events['click .checkOutBtn'] = 'handleCheckout';
                view.events['click .updateQtyBtn'] = 'enableUpdate';
                view.events['change .enableUpdateInput'] = 'enableUpdate';
                view.handleCheckout = function (event) {
                    let _this = this;
                    UTIL.showLoader();
                    _this.goToCheckout(event);
                };
                view.validateCartItemLater = function (cartItems) {
                    let isValidation = true, errorMessage = '';
                    if (cartItems && cartItems.length > 0) {
                        cartItems.models.forEach(function (cartItem, index) {
                            let warningFaicon = '<i class="fa fa-exclamation-triangle" aria-hidden="true"></i>';
                            let tooltip = CCRZ.pagevars.pageLabels['LPM_BB_cartErrorTooltip'];
                            if (!cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.product.LPMBBIsInStoreOnly) {
                                // When ship to is Home and Store pick up option only for the product
                                let cartItemLink = "<a data-toggle='tooltip' title='" + tooltip + "' href='#cc_cart_item" + cartItem.attributes.sfid + "' style='color: #a94442;'>"
                                errorMessage += cartItemLink + warningFaicon;
                                errorMessage += CCRZ.processPageLabelMap('LPM_BB_Reorder_IsInStoreOnly', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                                errorMessage += '</a>';
                                isValidation = false;
                                if ((index + 1 < (cartItems.length))) {
                                    errorMessage += "<div class='cc_cart_error_newline'></div>";
                                }
                            } else if (cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.LPMIsPickupLater
                                && !cartItem.attributes.product.LPMBBAvailableForInStorePickup) {
                                // Store pickup and store pickup not available on the product
                                let cartItemLink = "<a data-toggle='tooltip' title='" + tooltip + "' href='#cc_cart_item" + cartItem.attributes.sfid + "' style='color: #a94442;'>"
                                errorMessage += cartItemLink + warningFaicon;
                                errorMessage += CCRZ.processPageLabelMap('LPM_BB_Reorder_NotAvailableForStorePickup', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                                errorMessage += '</a>';
                                isValidation = false;
                                if ((index + 1 < (cartItems.length))) {
                                    errorMessage += "<div class='cc_cart_error_newline'></div>";
                                }
                            } else if (cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.LPMIsPickupLater
                                && cartItem.attributes.product.LPMBBIsInStoreOnly && !cartItem.attributes.product.LPMSTSEnabled) {

                                let cartItemLink = "<a data-toggle='tooltip' title='" + tooltip + "' href='#cc_cart_item" + cartItem.attributes.sfid + "' style='color: #a94442;'>"
                                errorMessage += cartItemLink + warningFaicon;
                                errorMessage += CCRZ.processPageLabelMap('LPM_Cart_laterInstoreOnly', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                                errorMessage += '</a>';
                                isValidation = false;
                                if ((index + 1 < (cartItems.length))) {
                                    errorMessage += "<div class='cc_cart_error_newline'></div>";
                                }
                            } else if (cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.LPMIsPickupLater
                                && !cartItem.attributes.product.LPMBBIsInStoreOnly && !cartItem.attributes.product.LPMSTSEnabled) {
                                let cartItemLink = "<a data-toggle='tooltip' title='" + tooltip + "' href='#cc_cart_item" + cartItem.attributes.sfid + "' style='color: #a94442;'>"
                                errorMessage += cartItemLink + warningFaicon;
                                errorMessage += CCRZ.processPageLabelMap('LPM_Cart_laterNotInstoreOnly', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                                errorMessage += '</a>';
                                isValidation = false;
                                if ((index + 1 < (cartItems.length))) {
                                    errorMessage += "<div class='cc_cart_error_newline'></div>";
                                }
                            } else if(cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.productR.LPMBBBackOrderEligible
                                && !cartItem.attributes.isStoreQuantityAvailable){
                                let backorderTime = '';
                                if(cartItem.attributes.productR.LPMBBInStockDate != undefined){
                                    backorderTime = 'pickup by ';
                                    backorderTime += Handlebars.helpers.dateFormat(cartItem.attributes.productR.LPMBBInStockDate, 'mm/yyyy');
                                }
                                // isValidation = false;
                                errorMessage += CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_Cart_LineItemChanges', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName, backorderTime]);
                            } else if(cartItem.attributes.cartItemGroupR.isStorePickup && !cartItem.attributes.isStoreQuantityAvailable) {
                                let promiseTime = '';
                                if(cartItem.attributes.b2bPromiseDate != undefined) {
                                    promiseTime = 'pickup by ';
                                    promiseTime += cartItem.attributes.b2bPromiseDate;
                                } else {
                                    promiseTime = 'get it in 24-48 hours';
                                }
                                // isValidation = false;
                                errorMessage += CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_Cart_LineItemChanges', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName, promiseTime]);
                            }

                        });
                    }
                    return {
                        'isValidation': isValidation,
                        'errorMessage': errorMessage
                    }
                };
                view.determineCOFlow = function (event) {
                    var view = this;
                    //if use LLI is set to TRUE, enter LLI checkout flow
                    var co = LLIcheckout;
                    let cartItems = this.model.attributes.ECartItemsS,
                        validationObj = this.validateCartItemLater(cartItems);
                    //if use LLI is set to FALSE, enter default checkout flow
                    cartMod.updateCartItemGroups(JSON.stringify({}), function (res, evt) {
                        if (res && res.success && res.data.length == 0) {
                            if (!validationObj.isValidation) {
                                UTIL.hideLoader();
                                CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", validationObj.errorMessage));
                                window.scroll(0, 0);
                            } else {
                                if (CCRZ.ga) {
                                    CCRZ.ga.handleCartCheckout({'cartId': CCRZ.pagevars.currentCartID}, co);
                                } else {
                                    co();
                                }
                            }
                        } else {
                            view.model.priceFetch(view.params.skipAutoCalc, function (response) {
                                view.setCartItemsToGroup();
                                CCRZ.pubSub.trigger("action:" + view.viewName + ":cartItemsRefreshed", this);
                                CCRZ.pubSub.trigger('cartChange', CCRZ.pagevars.currentCartID);
                                UTIL.validateCartReservationError(res);
                                view.render();
                                CCRZ.storeView.render();
                            });
                        }
                    });
                };
                view.handleShipTypeChange = function (event) {
                    let cartItem = {}, sfid = event.target.dataset.sfid;
                    view.model.attributes.ECartItemsS.models.forEach(function (cItem) {
                        if (sfid == cItem.attributes.sfid) {
                            cartItem = cItem.attributes;
                        }
                    });
                    let selectedStore = {};
                    if (cartItem.b2bSelectedStore != undefined) {
                        selectedStore = JSON.parse(cartItem.b2bSelectedStore);
                    }
                    if(selectedStore.name == '' || selectedStore.name === undefined || 
                        selectedStore.address1  == '' || selectedStore.address1 === undefined) {
                        selectedStore = CCRZ.storeView.model.attributes.selectedStoreList[0];
                    }
                    let reqData = {
                        "cartId": CCRZ.cartDetailView.model.attributes.sfid,
                        "cartItemId": event.target.dataset.sfid,
                        "shipType": event.target.dataset.type,
                        "storeName": (event.target.dataset.type == 'store') ? selectedStore.name : 'Home',
                        "promiseDateStoreName": selectedStore.name,
                        "promisedStoreJSONData": selectedStore,
                        "address1": (event.target.dataset.type == 'store') ? selectedStore.address1 : '',
                        "city": (event.target.dataset.type == 'store') ? selectedStore.city : '',
                        "stateCode": (event.target.dataset.type == 'store') ? selectedStore.state_code : '',
                        "countryCode": (event.target.dataset.type == 'store') ? selectedStore.country_code : '',
                        "postalCode": (event.target.dataset.type == 'store') ? selectedStore.postal_code : '',
                        "phone": (event.target.dataset.type == 'store') ? selectedStore.phone : '',
                        "storeId": (event.target.dataset.type == 'store') ? selectedStore.id : '',
                        "storeHours": (event.target.dataset.type == 'store') ? selectedStore.store_hours : '',
                        "storeTimezone": (event.target.dataset.type == 'store') ? selectedStore.c_storeTimezone : '',
                        // "isStoreQuantity": (event.target.dataset.type == 'store') ? (cartItem.selectedStore.Quantity >= cartItem.quantity) ? true : false : true,
                        "isStoreQuantity": (event.target.dataset.type == 'store') ? false : false,
                        "headerStorePostal": CCRZ.storeView.model.attributes.selectedStoreZip
                    };
                    view.setCartItemGroup(reqData);
                };
                view.setCartItemGroup = function (reqData) {
                    UTIL.showLoader();
                    cartMod.changeGroup(JSON.stringify(reqData), function (res, event) {
                        if (res && res.success && res.data) {
                            cartMod.reserveCartInventory(JSON.stringify({'isDelete': false}), function (resp, evt) {
                                if (resp && resp.success) {
                                    view.model.priceFetch(view.params.skipAutoCalc, function (response) {
                                        view.setCartItemsToGroup();
                                        CCRZ.pubSub.trigger("action:" + view.viewName + ":cartItemsRefreshed", this);
                                        CCRZ.pubSub.trigger('cartChange', CCRZ.pagevars.currentCartID);
                                        UTIL.validateCartReservationError(resp);
                                        view.render();
                                        CCRZ.storeView.render();
                                    });
                                }
                            });
                        } else {
                            // Error Handling
                            UTIL.hideLoader();
                        }

                    });
                };
                view.handleCheckStores = function (event) {

                    let _this = this, type = event.target.dataset.type, sfid = event.target.dataset.sfid;
                    let inputData = {
                        'type': 'cart',
                        'viewType': type,
                        'cartItemId': sfid
                    }
                    _this.model.attributes.ECartItemsS.models.forEach(function (cartItem) {
                        if (sfid == cartItem.attributes.sfid) {
                            inputData['cartItemData'] = cartItem.attributes;
                            inputData['sku'] = cartItem.attributes.product.SKU;
                            if (cartItem.attributes.cartItemGroupR.isStorePickup) {
                                inputData['zipCode'] = CCRZ.storeView.parseZip(cartItem.attributes.cartItemGroupR.shipToR.postalCode);
                                inputData['cartStoreName'] = cartItem.attributes.cartItemGroupR.groupName;
                            } else {
                                inputData['zipCode'] = '';
                            }
                        }
                    });
                    CCRZ.storeView.model.set('isCart', true);
                    CCRZ.pubSub.trigger('fetchStoreByZip', inputData);
                    $('html, body').animate({scrollTop: '0px'}, 300);
                };

                view.removeItem = function (event) {
                    UTIL.showLoader();
                    var objLink = $(event.currentTarget);
                    var parentElement = objLink.parents(".cart_item");
                    var sfid = objLink.data("id");
                    var view = this;
                    var cartId = view.model.get('sfid');

                    view.invokeContainerLoadingCtx($('.deskLayout'), 'removeItem', cartId, sfid, function (response, event) {
                        if (response.success && event.status) {
                            cartMod.reserveCartInventory(JSON.stringify({'isDelete': true}), function (res, evt) {
                                parentElement.fadeOut(2500);
                                if (res && res.success) {
                                    view.model.priceFetch(view.params.skipAutoCalc, function (response, event) {
                                        view.setCartItemsToGroup();
                                        CCRZ.pubSub.trigger('cartChange', CCRZ.pagevars.currentCartID);
                                        CCRZ.pubSub.trigger("action:" + view.viewName + ":cartItemsRefreshed", view);
                                        UTIL.validateCartReservationError(res);
                                        view.render();
                                        UTIL.hideLoader();
                                    });
                                } else {
                                    UTIL.hideLoader();
                                    // Error Handling
                                }
                            });
                        }
                    }, {escape: false, timeout: 120000});

                };
                view.postRender = function () {
                    //Need this for Request for Quote Validation
                    this.initValidationDesktop();
                    if (this.pickerView) {
                        this.pickerView.render();
                    }
                    if (this.model.attributes && this.model.attributes.messages) {
                        CCRZ.pubSub.trigger("pageMessage", this.model.attributes);
                    }
                    if ($('.cc_invalid').length) {
                        $('.cc_invalid').addClass('alert alert-danger');
                    }
                    if (this.model.get('isError')) {
                        this.model.set('isError', false);
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", this.model.get('errorMessageLabel')));
                        window.scroll(0, 0);
                    }

                    let updatedCartStoreHeader = CCRZ.pagevars.updatedCartStoreHeader;
                    let cartModel = this.model.attributes;
                    let storeModel = CCRZ.storeView.model.attributes;
                    if(!updatedCartStoreHeader) {
                        let cartStoreZip = '';
                        let cartStoreId = '';
                        if(cartModel.b2bHeaderStoreData != undefined) {
                            //Saved information from cart
                            let cartStoreData = JSON.parse(cartModel.b2bHeaderStoreData);
                            cartStoreZip = cartStoreData.storeZip;
                            cartStoreId = cartStoreData.storeId;
                        }

                        //Header store information
                        let selectedHeaderStore = _.findWhere(storeModel.selectedStoreList, {name: storeModel.selectedStoreName});
                        if(_.isUndefined(selectedHeaderStore)) {
                            selectedHeaderStore = _.findWhere(storeModel.storeList, {name: storeModel.selectedStoreName});
                        }
                        if(selectedHeaderStore.id != cartStoreId && !_.isUndefined(selectedHeaderStore)) {
                            let newStoreDate = {
                                "storeId": selectedHeaderStore.id,
                                "storeZip": selectedHeaderStore.postal_code.split('-')[0],
                                "storeTimeZone": selectedHeaderStore.c_storeTimezone,
                                "storeHours": selectedHeaderStore.store_hours,
                                "storePhone": selectedHeaderStore.phone,
                                "storeCountry": selectedHeaderStore.country_code,
                                "storeState": selectedHeaderStore.state_code,
                                "storeCity": selectedHeaderStore.city,
                                "storeAddress1": selectedHeaderStore.address1,
                                "storeName": selectedHeaderStore.name
                            }
                            const remoteCreateNewAddress = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_cartCX'});
                            remoteCreateNewAddress.invokeCtx('updateCartHeaderStore', JSON.stringify(newStoreDate), function (resp) {
                                if (resp && resp.success) {
                                    console.log('updated cart successfully');
                                    CCRZ.pagevars.updatedCartStoreHeader = true;
                                    CCRZ.cartDetailView.params.hasChanged = true;
                                    CCRZ.cartDetailView.saveToModel();
                                } else {
                                    console.log('updating cart failed failed');
                                    CCRZ.pagevars.updatedCartStoreHeader = true;
                                }
                            }, {
                                buffer: false,
                                escape: false,
                                nmsp: false
                            });


                        }
                    }
                };
                view.saveToModel = function (event) {
                    var view = this;
                    if (view.params.hasChanged) {
                        UTIL.showLoader();
                        this.model.saveChanges(this.params.skipAutoCalc, function (response) {
                            if (response.success) {
                                this.attrQtyChanged = false;
                                cartMod.reserveCartInventory(JSON.stringify({'isDelete': false}), function (res, evt) {
                                    if (res && res.success) {
                                        view.model.priceFetch(view.params.skipAutoCalc, function (response, event) {
                                            view.setCartItemsToGroup();
                                            CCRZ.pubSub.trigger('cartChange', CCRZ.pagevars.currentCartID);
                                            view.params.hasChanged = false;
                                            CCRZ.pubSub.trigger("action:" + view.viewName + ":cartItemsRefreshed", view);
                                            UTIL.validateCartReservationError(res);
                                            view.render();
                                            UTIL.hideLoader();
                                        });
                                    } else {
                                        UTIL.hideLoader();
                                        // Error Handling for cart Inventory reservation
                                    }
                                });
                                let toastMsg = CCRZ.pagevars.pageLabels.Toast_Product_Added_Success;
                                CCRZ.pubSub.trigger("showToastMsg", 'SUCCESS', toastMsg);
                            } else {
                                let errorToastMsg = CCRZ.pagevars.pageLabels.Toast_Product_Added_Fail;
                                CCRZ.pubSub.trigger("showToastMsg", 'ERROR', errorToastMsg);
                            }
                            // CCRZ.pubSub.trigger("pageMessage", response);
                        });
                    }
                };
                view.checkForExpiredAllocation = function () {
                    let isExpired = false, hasStore = false, _this = this, currentDate = new Date();
                    if (_this.model.attributes.ECartItemsS.length > 0) {
                        _this.model.attributes.ECartItemsS.models.forEach(function (cartItem) {
                            if (!_.isUndefined(cartItem.attributes.cartItemGroup) && cartItem.attributes.cartItemGroupR.isStorePickup
                                && !cartItem.attributes.LPMIsPickupLater && !hasStore) {
                                //&& !_.isUndefined(cartItem.attributes.LPMBBReservationAllocatedOn) && !isExpired){
                                /*let cartItemDate = new Date(cartItem.attributes.LPMBBReservationAllocatedOn);
                                cartItemDate = cartItemDate.getTime() + (parseInt(CCRZ.pagevars.pageConfig.get('c.expirereserve'))*60000); // Adding 20 minutes to cartItem allocated date to compare to currentDate
                                if(cartItemDate < currentDate.getTime()){
                                    isExpired = true; 
                                }*/
                                hasStore = true
                            }
                            /*else if(_.isUndefined(cartItem.attributes.LPMBBReservationAllocatedOn) && !_.isUndefined(cartItem.attributes.cartItemGroup) 
                            && cartItem.attributes.cartItemGroupR.isStorePickup  && !isExpired) {
                                isExpired = true;
                            }*/
                        });
                    }
                    return hasStore;
                };
                view.setCartItemsToGroup = function () {
                    let cartItemGroupMap = new Map(), _this = this;
                    if (_this.model.attributes.ECartItemsS.length > 0) {
                        _this.model.attributes.ECartItemsS.models.forEach(function (cartItem) {
                            if (cartItemGroupMap.has(cartItem.attributes.cartItemGroup)) {
                                let cartItemList = cartItemGroupMap.get(cartItem.attributes.cartItemGroup);
                                cartItemList.push(cartItem);
                                cartItemGroupMap.set(cartItem.attributes.cartItemGroup, cartItemList);
                            } else {
                                cartItemGroupMap.set(cartItem.attributes.cartItemGroup, [cartItem]);
                            }
                        });
                        if (!_.isUndefined(_this.model.attributes.ECartItemGroupsS) && _this.model.attributes.ECartItemGroupsS.length > 0) {
                            _this.model.attributes.ECartItemGroupsS.forEach(function (cartItemGroup) {
                                if (cartItemGroupMap.has(cartItemGroup.sfid)) {
                                    cartItemGroup['cartItems'] = cartItemGroupMap.get(cartItemGroup.sfid);
                                }
                            });
                        }
                    }
                };
                view.enableUpdate = function (event) {
                    var objLink = $(event.currentTarget);
                    var sfid = objLink.parents(".quantity.cc_quantity").data("id");
                    $(document.querySelectorAll("[data-update-id=" + sfid + "]")).css('display', 'block');
                    $('.checkoutBtn ').css('display', 'none');
                };
                // check for expired allocation
                if (view.checkForExpiredAllocation()) {
                    cartMod.reserveCartInventory(JSON.stringify({'isDelete': false}), function (res, evt) {
                        if (res && res.success && res.data.length > 0) {
                            view.model.priceFetch(view.params.skipAutoCalc, function (response, event) {
                                view.setCartItemsToGroup();
                                CCRZ.pubSub.trigger('cartChange', CCRZ.pagevars.currentCartID);
                                view.params.hasChanged = false;
                                CCRZ.pubSub.trigger("action:" + view.viewName + ":cartItemsRefreshed", view);
                                UTIL.validateCartReservationError(res);
                                view.render();
                                UTIL.hideLoader();
                            });
                        } else {
                            // Error Handling for cart Inventory reservation
                            view.setCartItemsToGroup();
                            UTIL.validateCartReservationError({});
                            view.render();
                            UTIL.hideLoader();
                        }
                    });
                } else {
                    view.setCartItemsToGroup();
                    let cartItems = view.model.attributes.ECartItemsS,
                        validationObj = view.validateCartItemLater(cartItems);
                    if (!validationObj.isValidation || (validationObj.errorMessage != undefined && validationObj.errorMessage != '' )) {
                        // view.model.set('isError', !validationObj.isValidation);
                        view.model.set('isError', true);
                        view.model.set('errorMessageLabel', validationObj.errorMessage);
                    }
                    view.render();
                    UTIL.hideLoader();
                }
            });

        },
        overridenSendEmailBtn: function (event) {
            console.log('override cart to email template ');

            $(".error").remove();
            var isError = false;
            var email_to = $('#email_to').val();
            var email_cc = $('#email_cc').val();


            if (email_to.length < 1) {
                $('#email_to').after('<span class="error">This field is required</span>');
                isError = true;
            } else {
                var regEx = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;  // "^[a-zA-Z0-9+_.-]+@[a-zA-Z0-9.-]+$"                    // /^[A-Z0-9][A-Z0-9._%+-]{0,63}@(?:[A-Z0-9-]{1,63}\.){1,125}[A-Z]{2,63}$/;
                var validEmail = regEx.test(email_to);
                if (!validEmail) {
                    $('#email_to').after('<span class="error">Enter a valid email</span>');
                    isError = true;
                }
            }
            var regEx = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;  // "^[a-zA-Z0-9+_.-]+@[a-zA-Z0-9.-]+$"                    // /^[A-Z0-9][A-Z0-9._%+-]{0,63}@(?:[A-Z0-9-]{1,63}\.){1,125}[A-Z]{2,63}$/;
            var validEmail = regEx.test(email_cc);
            if (!validEmail) {
                $('#email_cc').after('<span class="error">Enter a valid email</span>');
                isError = true;
            }
            if (isError) {
                event.preventDefault();
            } else {
                CCRZ.cartDetailView.sendEmail(event);
            }
        },
    }

});