d("quickOrderView", ['util', 'headerModel'], function (UTIL, headerModel) {

    return {
        extendQuickOrderView: function () {
            let customHeaderModel = new headerModel();
            let custQuickOrderRenderCount = 0;
            CCRZ.views.customQuickOrderView = CCRZ.CloudCrazeView.extend({
                templateDesktop: CCRZ.util.template(CCRZ.uiProperties.customQuickOrderView.desktop.tmpl),
                templateEntry: CCRZ.util.template(CCRZ.uiProperties.customQuickOrderView.entry.tmpl),
                viewName: "QuickOrderView",
                events: {
                    "click .addToCart": "addToCart",
                    "click .addMore": "addMore",
                    "keypress .sku-input": "addToCartOnEnter",
                    "keypress .qty-input": "qtyEntryKey"
                },
                scrubQty: function (event) {
                    var objLink = $(event.target);
                    var qty = objLink.val();
                    CCRZ.console.log('qty before=' + qty);
                    qty = CCRZ.util.scrubQuantity(qty);
                    CCRZ.console.log('qty after=' + qty);
                    objLink.val(qty);
                },
                qtyEntryKey: function (event) {
                    var v = this;
                    if (window.event && window.event.keyCode == 13 || event.which == 13) {
                        v.addToCart(event);
                        return false;
                    } else {
                        return CCRZ.util.isValidNumericInput(event); // todo, check qty field, not SKU
                    }
                },
                addToCartOnEnter: function (event) {
                    var v = this;
                    if (window.event && window.event.keyCode == 13 || event.which == 13) {
                        v.addToCart(event);
                        return false;
                    } else {
                        return true;
                    }
                },
                addToCart: function (event) {
                    let skuInput = $(event.target).closest('.panel-collapse').find('.cc_sku_input');
                    let qtyInput = $(event.target).closest('.panel-collapse').find('.cc_qty_input')

                    let sku = skuInput.val();
                    let qty = qtyInput.val();
                    let _this = this, subTermId = null, price = null;
                    if (qty != '' && parseInt(qty) > 0) {
                        UTIL.showLoader();
                        qty = parseInt(qty);
                        let productData = {
                            "sku": sku,
                            "quantity": qty + '',
                            "subTermId": subTermId,
                            "parentSFID": null,
                            "isMain": true,
                            "shipType": 'home',
                            "storeName": 'Home',
                            "address1": '',
                            "city": '',
                            "stateCode": '',
                            "countryCode": '',
                            "postalCode": '',
                            "phone": '',
                            "storeId": '',
                            "price": null,
                            "subTotal": null,
                            "storeHours": '',
                            "storeTimezone": '',
                            "isStoreQuantity": true,
                            "isPickUpLater": false,
                            "isGetPrice": true,
                            "isFromWebStore":true
                        }, reqData = {
                            'cartEncId': CCRZ.pagevars.currentCartID,
                            'products': [productData],
                            "lookupMPN": true
                        }
                        customHeaderModel.addToCart(JSON.stringify(reqData), function (res, evt) {
                            if (res && res.success && res.data) {
                                if (res.data.cartEncId) {
                                    try {
                                        CCRZ.pagevars.currentCartID = res.data.cartEncId;
                                        CCRZ.pagevars.queryParams['cartId'] = res.data.cartEncId;
                                        CCRZ.pubSub.trigger('cartChange', res.data.cartEncId);
                                    } catch (err) {
                                    }
                                    CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('INFO', "messagingSection-quick-Info", 'Product Added Sucessfully!'));
                                    qtyInput.val(1);
                                    skuInput.val('');
                                }
                            } else {
                                // Error handling
                                CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-quick-Error", 'Item can not be added from Quick Order, visit Product details for more options!'));
                            }
                            UTIL.hideLoader();
                        });
                    } else {
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-quick-Error", 'Invalid_Qty'));
                    }
                },
                init: function () {
                    if(CCRZ.pagevars.currentPageName !== 'ccrz__CCSiteLogin') {
                        this.count = 0;
                        this.render();
                    }
                },
                render: function () {
                    var v = this;
                    this.setElement($(CCRZ.uiProperties.customQuickOrderView.desktop.selector));
                    this.$el.html(v.templateDesktop());
                    if (this.count == 0) {
                        this.addMore();
                    }
                    setTimeout(function () {
                        if($('.quickOrderDropdownMenu').find('.quickOrderField').length == 0 && custQuickOrderRenderCount <=5) {
                            console.log('quickOrder init called');
                            custQuickOrderRenderCount += 1;
                            CCRZ.quickOrderView.init();
                        }
                    }, 4000);
                },
                addMore: function () {
                    var content = "";
                    var rowSelector = CCRZ.uiProperties.customQuickOrderView.desktop.selector + " .quickOrderRow";
                    var ele = $(rowSelector);
                    var currSize = this.count;
                    for (var i = currSize; i < currSize + 1; i++) {
                        var templateEntry = this.templateEntry(i);
                        if (templateEntry.includes('cc_cust_MiniQuickOrderEntry-Desktop.handlebars')) {
                            this.count = 0;
                            this.render();
                        } else {
                            content += templateEntry;
                            this.count++;
                        }
                    }
                    $(rowSelector).append(content);
                },
            });
            CCRZ.quickOrderView = new CCRZ.views.customQuickOrderView();
            $('body').on('click', function (e) {
                if ($('.dropdown-menu.quickOrderDropdownMenu').hasClass('show') && $('.dropdown-menu.quickOrderDropdownMenu.show').has(e.target).length == 0) {
                    $('.dropdown-menu.quickOrderDropdownMenu').removeClass('show');
                } else if ($(e.target).hasClass('quickOrderButton') || $(e.target).hasClass('quickOrderChevron')) {
                    $('.dropdown-menu.quickOrderDropdownMenu').addClass('show');
                }
            });

        }
    }
});