/**
 *  Namespace defines additional handlebars helpers. That could be used in whole storefront
 *
 *  <ul>
 *  <li>
 *      ifPageDisplay - render block or not depend on current ccpage
 *      <pre>
 *              {{#ifPageDisplay 'ccrz__HomePage'}}
 *              <h1>Home page</h1>
 *              {{/ifPageDisplay}}
 *      </pre>
 *  </li>
 *  <li>
 *      ifConfigValue - helpers renders block or not depend on current storefront and sales organization
 *      <pre>
 *              {{#ifConfigValue 'Checkout_DeliveryDate__c'}}
 *                  <div class="col-md-5 col-xs-12  section">
 *                      <div><label>{{pageLabelMap 'CHECKOUT_DELIVERYDATE_LABEL'}} </label></div>
 *                       <div><input type="date" name="date" /></div>
 *                  </div>
 *              {{/ifConfigValue}}
 *      </pre>
 * </li>
 *  </ul>
 */
d('helpers', ['hbs', 'util'], function (Handlebars, util) {
    var initialized = false;
    return {
        registerHelpers: function () {
            if (!initialized) {
                Handlebars.registerHelper('ifDisplayQuickOrder', function (options) {
                    restrictedPageNames = ['ccrz__Checkout'];
                    for (var i = 0; i < restrictedPageNames.length; i++) {
                        if (CCRZ.pagevars.currentPageName.toLowerCase() == restrictedPageNames[i].toLowerCase()) {
                            return options.inverse(this);
                        }
                    }
                    return options.fn(this);
                });
                // show elements on pageName
                Handlebars.registerHelper('ifPageDisplay', function (pageName, options) {
                    if (CCRZ.pagevars.currentPageName.toLowerCase() == pageName.toLowerCase()) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                // show elements on pageName Not
                Handlebars.registerHelper('ifPageDisplayNot', function (pageName, options) {
                    if (CCRZ.pagevars.currentPageName.toLowerCase() != pageName.toLowerCase()) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                // show elements on pageName
                Handlebars.registerHelper('ifNotPageDisplay', function (pageName, options) {
                    return (CCRZ.pagevars.currentPageName.toLowerCase() != pageName.toLowerCase()) ? true : false;
                });
                //get value from config
                Handlebars.registerHelper('getConfig', function (str) {
                    return CCRZ.pagevars.pageConfig[str];
                });
                //check if obejct is empty
                Handlebars.registerHelper('ifObjectExistButIsEmpty', function (obj) {
                    if (obj.length == 1) {
                        var isEmpty = _.isEmpty(obj[0]);
                        if (isEmpty) {
                            return true;
                        }
                    } else if (obj.length == 0) {
                        return true;
                    } else {
                        return false;
                    }
                });
                //return object size
                Handlebars.registerHelper("objectSize", function (object) {
                    if (object) {
                        return Object.keys(object).length;
                    }
                    return null;
                });
                Handlebars.registerHelper('ifOneItemWithOneQty', function (productArray, groupModel, modelOrder) {
                    var size = productArray.length;
                    var flag = false;
                    if (modelOrder) {
                        var itemList = groupModel[0].attributes.EOrderItemsS[0];
                    } else {
                        var itemList = groupModel[0].attributes.ECartItemsS[0];
                    }
                    if (size == 1 && itemList) {
                        var qty = itemList.quantity;
                        if (qty == 1) {
                            flag = true;
                        }
                    }
                    return flag;
                });
                Handlebars.registerHelper('or', function (val1, val2) {
                    if (val1 || val2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('and', function (val1, val2, options) {
                    if (val1 && val2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('isGreaterOrEqual', function (val1, val2) {
                    if (val1 >= val2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('ifShowStore', function (val1, val2, options) {
                    if (val1 && _.isUndefined(val2)) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('ifStorePickUpPDP', function (isShowStore, isNotSubsc, selectedStore, options) {
                    if (isShowStore && isNotSubsc) {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('isStoreCheck', function (selectedStore, options) {
                    if (!_.isUndefined(selectedStore) && selectedStore.c_enableBopis && selectedStore.c_enableSts) {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('logicalAnd', function (val1, val2, options) {
                    if (val1 && val2) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                Handlebars.registerHelper('logicalOr', function (val1, val2, options) {
                    if (val1 || val2) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                Handlebars.registerHelper('isNearByStore', function (quantity, options) {
                    let isAvailable = false;
                    if (CCRZ.storeView && CCRZ.storeView.model && CCRZ.storeView.model.attributes.storeList
                        && CCRZ.storeView.model.attributes.storeList.length > 0) {
                        quantity = parseInt(quantity);
                        CCRZ.storeView.model.attributes.storeList.forEach(function (store) {
                            if (store.Quantity >= quantity && !isAvailable) {
                                isAvailable = true;
                            }
                        });
                    }
                    if (isAvailable) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                Handlebars.registerHelper('getNearByStoreWithQty', function (quantity) {
                    let str = '', isAvailable = false, nearbyStore = {};
                    if (CCRZ.storeView && CCRZ.storeView.model && CCRZ.storeView.model.attributes.storeList
                        && CCRZ.storeView.model.attributes.storeList.length > 0) {
                        quantity = parseInt(quantity);
                        CCRZ.storeView.model.attributes.storeList.forEach(function (store) {
                            if (store.Quantity >= quantity && !isAvailable) {
                                isAvailable = true;
                                nearbyStore = store;
                            }
                        });
                    }
                    if (isAvailable) {
                        str = nearbyStore.Quantity + ' units available within ' + nearbyStore.distance + (nearbyStore.distance_unit == 'mi' ? ' miles' : ' kilometers') + '.';
                    }
                    return str;
                });

                Handlebars.registerHelper('subcategoryIsCurrentCategory', function (subcategories, currentCategoryId) {
                    var isCurrent = false;
                    _.each(subcategories, function (subcategory) {
                        var subId = subcategory.categoryID;
                        if (subId === currentCategoryId) {
                            isCurrent = true;
                        }
                    });
                    return isCurrent;
                });
                Handlebars.registerHelper('getCurrentPLPCategoryId', function () {
                    if (CCRZ.productListPageModel && CCRZ.productListPageModel.attributes.isCategory) {
                        var categoryId = CCRZ.productListPageModel.attributes.category.categoryID;
                        return categoryId;
                    } else if (CCRZ.productListPageModel && CCRZ.productListPageModel.attributes.isSearch) {
                        return '';
                    }
                });
                Handlebars.registerHelper('myAccountByViewState', function (viewState) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__MyAccount?' + 'viewState=' + viewState + '&cartID=' + CCRZ.pagevars.currentCartID + getCSRQueryString());
                });
                Handlebars.registerHelper('getStoreHeaderMessage', function (models, isReview) {
                    let messageName = '', isStoreAvailable = false, isHomeAvailable = false;
                    if (!_.isUndefined(models) && models.length > 0) {
                        models.forEach(function (model) {
                            if (model.attributes.isStorePickup) {
                                isStoreAvailable = true;
                            } else {
                                isHomeAvailable = true;
                            }
                        });
                        if (isStoreAvailable && isHomeAvailable) {
                            messageName = isReview ? 'LPM_BB_Header_OrderReview_ShipToHomeAndStorePickup' : 'LPM_BB_Header_OrderDetails_ShipToHomeAndStorePickup';
                        } else if (isStoreAvailable && !isHomeAvailable) {
                            messageName = isReview ? 'LPM_BB_Header_OrderReview_StorePickup' : 'LPM_BB_Header_OrderDetails_StorePickup';
                        } else if (!isStoreAvailable && isHomeAvailable) {
                            messageName = isReview ? 'LPM_BB_Header_OrderReview_ShipToHome' : 'LPM_BB_Header_OrderDetails_ShipToHome';
                        }
                    }
                    return messageName;
                });
                Handlebars.registerHelper('getTabIndex', function (index, num) {
                    return (index * 4) + num;
                });
                Handlebars.registerHelper('getCurrentIterationEan', function (productId, productList) {
                    var item = productList[productId];
                    return item.cccustEAN;
                });
                Handlebars.registerHelper('findPaginationIdTarget', function () {
                    var target = $("[id$='pagin-target']");
                    var targetId = target.attr("id");
                    return targetId;
                });
                Handlebars.registerHelper('getNumberOfAlerts', function () {
                    if (CCRZ.AlertView && CCRZ.AlertView.model) {
                        return CCRZ.AlertView.model.length;
                    } else {
                        return 0;
                    }
                });
                Handlebars.registerHelper('returnListOfAttributes', function (productList, nameOfAttribute) {
                    var attributeArray = [];
                    _.each(productList, function (product) {
                        attributeArray.push(product[nameOfAttribute]);
                    });
                    return attributeArray.join(', ');
                });
                Handlebars.registerHelper('getAlertsTotal', function () {
                    if (CCRZ.AlertView && CCRZ.AlertView.model) {
                        var cookie = CCRZ.getCookie('seenAlerts');
                        if (!cookie) {
                            cookie = [];
                            var jsonidList = JSON.stringify(cookie);
                            CCRZ.setCookieWithPath('seenAlerts', jsonidList, 30, '/');
                            var cookie = CCRZ.getCookie('seenAlerts');
                            var seen = JSON.parse(cookie);
                        } else {
                            var seen = JSON.parse(cookie);
                        }

                        var seenAmount = seen.length,
                            alerts = CCRZ.AlertView.model.length;

                        if (seen && seenAmount > 0) {
                            return alerts - seenAmount;
                        } else {
                            return alerts;
                        }
                    } else {
                        return 0;
                    }
                });
                Handlebars.registerHelper('equals', function (value1, value2) {
                    if (value1 === value2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('switch', function (value, options) {
                    this.switch_value = value;
                    return options.fn(this);
                });

                Handlebars.registerHelper('case', function (value, options) {
                    if (value == this.switch_value) {
                        return options.fn(this);
                    }
                });
                Handlebars.registerHelper('removePlus', function (name) {
                    return name.replace('+', ' ');
                });
                Handlebars.registerHelper('CreditApproved', function () {
                    if (CCRZ.myaccountModel) {
                        if (CCRZ.myaccountModel.attributes.accountBean.LPMBBCreditApproval) {
                            return true;
                        }
                    }
                    return false;
                });
                Handlebars.registerHelper('isCreditApproved', function (key, options) {
                    if (CCRZ.cartCheckoutModel) {
                        if (key == 'po') {
                            if (CCRZ.cartCheckoutModel.attributes.accountR.LPMBBCreditApproval) {
                                return options.fn(this);
                            } else {
                                return options.inverse(this);
                            }
                        }
                    } else if (CCRZ.LLIPaymentModel) {
                        if (key == 'po') {
                            if (CCRZ.LLIPaymentModel.attributes.cartData.accountR.LPMBBCreditApproval) {
                                return options.fn(this);
                            } else {
                                return options.inverse(this);
                            }
                        }
                    }
                    return options.fn(this);
                });
                Handlebars.registerHelper('isBillingPopulated', function (options) {
                    if (CCRZ.LLIPaymentModel) {
                        if (CCRZ.LLIPaymentModel.attributes.cartData.billTo) {
                            return options.fn(this);
                        } else {
                            return options.inverse(this);
                        }
                    }
                    return options.fn(this);
                });
                Handlebars.registerHelper('ifGreaterOrEqual', function (v1, v2, options) {
                    if (v1 >= v2) {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('reverse', function (arr) {
                    arr.reverse();
                });
                Handlebars.registerHelper('debug2', function (data, desc) {
                    console.log(data);
                    return '';
                });
                Handlebars.registerHelper('getProductType', function () {
                    return CCRZ.detailData.jsonProductData.product.prodBean.ProductType;
                });
                Handlebars.registerHelper('getResourceUrl', function (str) {
                    return CCRZ.pagevars.themeBaseURL + str;
                });
                Handlebars.registerHelper('ifPageKey', function (pageKey) {
                    return (pageKey == CCRZ.getQueryParam('pageKey')) ? true : false;
                });
                Handlebars.registerHelper('getShippingProvider', function (index) {
                    if (index >= 0 && CCRZ.LLIShippingDetailModel) {
                        var model = CCRZ.LLIShippingDetailModel.attributes.cartData.ECartItemGroupsS.models[index];
                        var shippingProvider = model.attributes.shipProvider;
                        return shippingProvider;
                    } else {
                        return Handlebars.helpers.pageLabelMap('ShippingRate_Provider_Unknown');
                    }
                });
                Handlebars.registerHelper('getShippingProviderByMethod', function (shipGroup) {
                    if (shipGroup && CCRZ.LLIShippingDetailModel) {
                        var shippingOptions = shipGroup.shippingOptions;
                        var provider = Handlebars.helpers.pageLabelMap('ShippingRate_Provider_Unknown');
                        _.each(shippingOptions, function (option) {
                            if (option.serviceName == shipGroup.shipMethod) {
                                provider = option.provider;
                            }
                        }, shipGroup);
                        return provider;
                    } else {
                        return Handlebars.helpers.pageLabelMap('ShippingRate_Provider_Unknown');
                    }
                });
                Handlebars.registerHelper('checkIfInCartIsCoupon', function (cartItems) {
                    var checkResult = false;

                    $.each(cartItems.models, function (index, element) {
                        if (element.attributes.cartItemType == 'Coupon') {
                            checkResult = true;
                        }
                    });

                    return checkResult;
                });

                Handlebars.registerHelper('allDiscount', function (cartItems) {
                    var discount = 0;

                    if (Handlebars.helpers.checkIfInCartIsCoupon(cartItems)) {
                        $.each(cartItems.models, function (index, element) {
                            if (element.attributes.cartItemType == 'Coupon') {
                                discount += -(element.attributes.SubAmount);
                            }
                        });
                    } else {
                        $.each(cartItems.models, function (index, element) {
                            if (element.attributes.absoluteDiscount) {
                                discount += element.attributes.absoluteDiscount;
                            }
                        });
                    }

                    return discount;
                });
                Handlebars.registerHelper('checkIfShowSaveLabels', function (cartItems) {
                    var checkResult = false;
                    var checkVariable = Handlebars.helpers.allDiscount(cartItems);
                    if (checkVariable != 0) {
                        checkResult = true;
                    }

                    return checkResult;
                });
                //check is mobile or width less than breakpoint
                Handlebars.registerHelper('checkMobile', function (breakpoint) {
                    var screensize = $(window).width(),
                        breakpoint = Number(breakpoint);

                    return (screensize < breakpoint) ? true : false;
                });
                Handlebars.registerHelper('convertDate', function (dataToConvert) {
                    var format = CCRZ.pagevars.pageLabels['Date_Format'];
                    return util.formatDate(new Date(dataToConvert), format);
                });
                Handlebars.registerHelper('compareDate', function (dateToCompare) {
                    if (dateToCompare != undefined && dateToCompare != '') {
                        var todayDate = new Date(),
                            convertDate = new Date(dateToCompare);
                        return (todayDate.toLocaleDateString() < convertDate.toLocaleDateString()) ? true : false;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('dateFormat', function (dataToConvert, format) {
                    return util.formatDate(new Date(dataToConvert), format);
                });
                Handlebars.registerHelper('ifNotPastDate', function (dateToCompare) {
                    if (dateToCompare != undefined && dateToCompare != '') {
                        var todayDate = new Date(),
                            convertDate = new Date(dateToCompare);
                        return (Date.parse(convertDate.toLocaleDateString()) >= Date.parse(todayDate.toLocaleDateString())) ? true : false;
                    } else {
                        return true;
                    }
                });
                Handlebars.registerHelper('isGuest', function (options) {
                    if (!CCRZ.pagevars.isGuest) {
                        return options.inverse(this);
                    } else {
                        return options.fn(this);
                    }
                });
                Handlebars.registerHelper('isNotGuest', function (options) {
                    if (!CCRZ.pagevars.isGuest) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isLoggedUser', function (options) {
                    if (CCRZ.pagevars.isGuest) {
                        return options.inverse(this);
                    } else {
                        return options.fn(this);
                    }
                });
                Handlebars.registerHelper('ifEven', function (conditional, options) {
                    if ((conditional % 2) == 0) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('strong', function (value) {
                    value = value.replace(new RegExp('<em>', 'g'), '<strong>');
                    value = value.replace(new RegExp('</em>', 'g'), '</strong>');
                    return value;
                });
                Handlebars.registerHelper('productLinkSearch', function (product, styleClass, options) {
                    var SKU = '';
                    if (!_.isUndefined(product)) {
                        if (product.linkURL) {
                            SKU = product.linkURL;
                        } else if (product.sku) {
                            SKU = product.sku;
                        } else if (product.SKU) {
                            SKU = product.SKU;
                        } else if (product.productSKU) {
                            SKU = product.productSKU;
                        }
                        var productName = product.highlightName || product.name
                        productName = Handlebars.helpers.strong(productName);
                        var linkObj = {
                            'name': productName,
                            'SKU': SKU,
                            'friendlyUrl': product.friendlyUrl,
                            'openInNewWindow': product.openInNewWindow
                        };
                        var productJSON = _.escape(JSON.stringify(linkObj));
                    }
                    var content = '';
                    if (productName) {
                        content = _.unescape(productName);
                    }
                    if (options && options.hash['image'])
                        content = options.hash['image'];
                    if (options && options.hash['text']) {
                        content = _.escape(_.unescape(options.hash['text']));
                    }
                    return new Handlebars.SafeString("<a href=\"javascript:void(0);\" onClick=\"CCRZ.openPDP(this)\" class='" + styleClass + " gp_prod' data-product= '" + productJSON + "' data-id= '" + SKU + "'>" + content + "</a>")
                });
                Handlebars.registerHelper('missSpaces', function (string) {
                    if (string)
                        return string.replace(' ', '');
                });
                Handlebars.registerHelper('sortCategories', function (categories, field) {
                    var result = _.sortBy(categories, function (e) {
                        if (e.children) {
                            e.children = _.sortBy(e.children, function (f) {
                                return f[field];
                            });
                        }
                        return e[field];
                    });
                    return result;
                });
                //index offset helper
                Handlebars.registerHelper('offset', function (number, options) {
                    if (typeof (number) === 'undefined' || number === null)
                        return null;
                    return number + (options.hash.offset || 0);
                });
                //set image from static resources
                Handlebars.registerHelper('setImgSrc', function (str) {
                    var currSiteURL = CCRZ.pagevars.currSiteURL,
                        themeBaseURL = "",
                        themeBaseURLArray = CCRZ.pagevars.themeBaseURL.split("/");
                    for (var i = 0; i < themeBaseURLArray.length; i++) {
                        if (themeBaseURLArray[i] && themeBaseURLArray[i].toLowerCase() != CCRZ.pagevars.storefrontName.toLowerCase()) {
                            themeBaseURL += themeBaseURLArray[i] + "/";
                        }
                    }
                    if (CCRZ && CCRZ.pagevars && CCRZ.pagevars.portalUserId != '') {
                        currSiteURL = currSiteURL + '/';
                    }
                    return currSiteURL + themeBaseURL + str;
                });
                //overriden 'displayImage' helper
                Handlebars.registerHelper('displayImage', function (obj, styleClass, options) {
                    var blankImage = Handlebars.helpers.getReplacementImage();
                    var onerrorSrc = Handlebars.helpers.onerrorSrc();
                    if (options && options.hash['src']) {
                        var imgSrc = _.escape(options.hash['src']);
                    } else {
                        var imgSrc = CCRZ.processImageURL(obj, styleClass, options);
                    }
                    if (imgSrc === '') {
                        imgSrc = blankImage;
                    }
                    var alt = '';
                    if (options && options.hash['alt']) {
                        alt = _.escape(options.hash['alt']);
                    }
                    var dataId = "";
                    if (options && options.hash['dataId']) {
                        dataId = _.escape(options.hash['dataId']);
                    }
                    if (imgSrc.length > 0) {
                        return new Handlebars.SafeString("<img class='" + styleClass + "' src='" + imgSrc + "' alt='" + alt + "' data-id='" + dataId + "' onerror='" + onerrorSrc + "'/>");
                    } else {
                        return new Handlebars.SafeString("<img class='" + styleClass + " " + CCRZ.pagevars.userLocale + " noImg' alt='" + alt + "' data-id='" + dataId + "' onerror='" + onerrorSrc + "'/>");
                    }
                });
                //return default product image src link
                Handlebars.registerHelper('getReplacementImage', function () {
                    var replacementImg = Handlebars.helpers.setImgSrc('images/img-not-available.svg');
                    return replacementImg;
                });
                //return onerror attr with replacement image
                Handlebars.registerHelper('onerrorSrc', function () {
                    return 'this.onerror=null;this.src="' + Handlebars.helpers.getReplacementImage() + '"';
                });
                //return link to Product Detail Page from SKU
                Handlebars.registerHelper('PDPLink', function (sku) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__ProductDetails?' + 'sku=' + sku + getCSRQueryString());
                });
                //return link to custom site form given pageKey
                Handlebars.registerHelper('goToCCPage_PageKey', function (pageKey) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__CCPage?pageKey=' + pageKey + getCSRQueryString());
                });
                Handlebars.registerHelper('goToCategory', function (categoryId) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__ProductList?viewState=ListView&cartId=' + CCRZ.pagevars.currentCartID + '&categoryId=' + categoryId + getCSRQueryString());
                });
                Handlebars.registerHelper('gridCalc', function (numOfSections) {
                    return 12 / Math.floor(numOfSections);
                });
                Handlebars.registerHelper('groupProductsCarouselItems', function (num1, num2, place) {
                    if (num2 == 1) {
                        return 'true';
                    } else {
                        if (place == "begin" && (num1 == 0 || (num1 != 1 && (num1 + 1) % (num2) == 1))) return 'true';
                        else if (place == "end" && ((num1 + 1) % num2 == 0)) return 'true';
                    }
                });
                Handlebars.registerHelper('divideAndRoundUp', function (num1, num2) {
                    return Math.ceil(num1 / num2);
                });
                Handlebars.registerHelper('mathAdd', function (num1, num2, num3) {
                    return Math.abs(num1 + num2 + num3);
                });
                Handlebars.registerHelper('loop', function (n, block) {
                    var accum = '';
                    for (var i = 0; i < n; ++i)
                        accum += block.fn(i);
                    return accum;
                });
                Handlebars.registerHelper('pageLabelMap', function (labelName) {
                    var params = Array.prototype.slice.call(arguments, 1);
                    var labelSymbol = "EL#";

                    var retLabel;
                    if (labelName) {
                        if (sessionStorage.getItem("editModeOn") != 'true' && CCRZ.pagevars.pageLabels && !_.isUndefined(CCRZ.pagevars.pageLabels[labelName])) {
                            retLabel = CCRZ.pagevars.pageLabels[labelName];
                            if (_.isNull(retLabel)) {
                                retLabel = '';
                            } else if (!_.isUndefined(params) && params.length > 0) {
                                retLabel = new Handlebars.SafeString(substitute(retLabel, params));
                            } else {
                                retLabel = new Handlebars.SafeString(retLabel);
                            }
                        } else {
                            if (sessionStorage.getItem("editModeOn") == 'true') {
                                retLabel = CCRZ.pagevars.pageLabels[labelName];
                                if (_.isNull(retLabel)) {
                                    retLabel = '';
                                } else if (!_.isUndefined(params) && params.length > 0) {
                                    var editableLabel = labelSymbol + ' [' + labelName + '] ' + retLabel;
                                    retLabel = new Handlebars.SafeString(substitute(editableLabel, params));
                                } else {
                                    var editableLabel = labelSymbol + ' [' + labelName + '] ' + retLabel;
                                    retLabel = new Handlebars.SafeString(editableLabel);
                                }
                            } else {
                                retLabel = labelName;
                            }
                        }
                    }
                    if (!retLabel) {
                        retLabel = '';
                    }
                    return retLabel;
                });
                Handlebars.registerHelper('pageLabelPrefixMap', function (prefix, labelName) {
                    return Handlebars.helpers.pageLabelMap(prefix + labelName);
                });
                Handlebars.registerHelper('ifCurrentTheme', function (themeValue) {
                    var theme = (CCRZ.pagevars.themeBaseURL).split('/');
                    return theme[theme.length - 2] == themeValue;
                });
                Handlebars.registerHelper('textToHTML', function (str) {
                    return str.replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
                });
                Handlebars.registerHelper('isCSRMode', function (options) {
                    if (CCRZ && CCRZ.pagevars && CCRZ.pagevars.portalUserId != '') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                // Removing helper userName
                /*Handlebars.registerHelper('userName', function(options){
                    return r('user').get('user') ? r('user').get('user').FirstName : '';
                });*/
                Handlebars.registerHelper('getTaxesAmountFromJSON', function (cartData) {
                    var taxesAmount = 0;
                    if (cartData) {
                        var taxesJSON = cartData.cccustTaxesList;
                        if (taxesJSON) {
                            var taxesList = JSON.parse($.parseHTML(taxesJSON)[0].data);
                            if (taxesList) {
                                _.each(taxesList, function (tax) {
                                    taxesAmount += tax['Amount'];
                                })
                            }
                        }
                    }
                    return taxesAmount;
                });
                Handlebars.registerHelper('getTaxesAmountFromJSONByDescription', function (cartData, desc) {
                    var taxesAmount = 0;
                    if (cartData) {
                        var taxesJSON = cartData.cccustTaxesList;
                        if (taxesJSON) {
                            var taxesList = JSON.parse($.parseHTML(taxesJSON)[0].data);
                            if (taxesList) {
                                _.each(taxesList, function (tax) {
                                    if (desc == tax['TaxDescr']) taxesAmount += tax['Amount'];
                                })
                            }
                        }
                    }
                    return taxesAmount;
                });
                Handlebars.registerHelper('containsTaxesByDescription', function (cartData, desc) {
                    if (cartData) {
                        var taxesJSON = cartData.cccustTaxesList;
                        if (taxesJSON) {
                            var taxesList = JSON.parse($.parseHTML(taxesJSON)[0].data);
                            if (taxesList) {
                                return _.some(taxesList, function (tax) {
                                    return desc == tax['TaxDescr']
                                })
                            }
                        }
                    }
                    return false;
                });
                Handlebars.registerHelper('removeAfterSign', function (text, sign) {
                    return text ? text.substr(0, text.indexOf(sign) + 1) : '';
                });
                Handlebars.registerHelper('checkoutStepNumber', function (index) {
                    return index + 1;
                });
                Handlebars.registerHelper('equalsOrLower', function (index, parentIndex, options) {
                    if (index <= parentIndex) return options.fn(this);
                    return options.inverse(this);
                });
                Handlebars.registerHelper('getViewState', function () {
                    return CCRZ.getQueryParam('viewState');
                });
                Handlebars.registerHelper('normalizeShippingMethod', function (shipMethod) {
                    return shipMethod.replace('null - ', '');
                });
                Handlebars.registerHelper('cartDiscountTotal', function (cartItems) {
                    var totalDiscount = 0;
                    if (cartItems) {
                        _.each(cartItems, function (item) {
                            if (item.attributes && item.attributes.absoluteDiscount) {
                                totalDiscount += item.attributes.absoluteDiscount;
                            } else if (item.absoluteDiscount) {
                                totalDiscount += item.absoluteDiscount;
                            }
                        });
                    }
                    return totalDiscount;
                });
                Handlebars.registerHelper('getFooterLink', function (url) {
                    var sign = '?',
                        cartParam = '',
                        CSRQueryString = getCSRQueryString(),
                        containsQuestionMark = false,
                        storefront = CCRZ.pagevars.remoteContext.storefront;

                    if (url.indexOf('www') === 0 || url.indexOf('http') === 0 || url.indexOf('https') === 0) {
                        return url;
                    }
                    if (url.indexOf("?") >= 0) {
                        sign = '&';
                        containsQuestionMark = true;
                    }
                    if (CCRZ.pagevars.currentCartID != null) {
                        cartParam = sign + 'cartId=' + CCRZ.pagevars.currentCartID;
                        containsQuestionMark = true;
                    }
                    if (containsQuestionMark == false && CSRQueryString.indexOf('&') == 0) {
                        CSRQueryString = CSRQueryString.replace('&', '?');
                    }
                    return url + cartParam + CSRQueryString;
                });
                Handlebars.registerHelper('getAbsoluteValue', function (number) {
                    return Math.abs(number);
                });
                Handlebars.registerHelper('checkCouponInCartItems', function (cartItemList) {
                    var isCouponInCart = null;
                    var coupon = 'Coupon';

                    isCouponInCart = _.find(cartItemList, function (element) {
                        return element.cartItemType == coupon || element.productType == coupon;
                    });

                    return isCouponInCart ? true : false;
                });
                Handlebars.registerHelper('customCategoryCheck', function (options) {
                    if (CCRZ.data.categories.length > 0) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('customCategoryFetch', function () {
                    return CCRZ.data.categories;

                });
                Handlebars.registerHelper('shippingUSOnly', function () {
                    return [
                        {label: "United States", value: "US"}
                    ];

                });
                Handlebars.registerHelper('returnHrefUrl', function (product) {
                    return CCRZ.goToPDP(null, product);

                });
                Handlebars.registerHelper('returnPDPHrefUrl', function (sku) {
                    return CCRZ.goToPDP(null, {productSKU: sku});
                });
                Handlebars.registerHelper('isCSRMode', function (options) {
                    if (CCRZ && CCRZ.pagevars && CCRZ.pagevars.portalUserId != '') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isNotCSRMode', function (options) {
                    if (CCRZ && CCRZ.pagevars && CCRZ.pagevars.portalUserId != '') {
                        return options.inverse(this);
                    } else {
                        return options.fn(this);
                    }
                });
                Handlebars.registerHelper('appendQueryparams', function () {
                    let urlParam = '';
                    if (CCRZ.pagevars.queryParams.portalUser != undefined) {
                        urlParam += '&portalUser=' + CCRZ.pagevars.queryParams.portalUser;
                    }
                    if (CCRZ.pagevars.queryParams.portalUser != undefined) {
                        urlParam += '&store=' + CCRZ.pagevars.queryParams.store;
                    }
                    return urlParam;
                });
                Handlebars.registerHelper('multiplePricing', function (price, quantity) {
                    return CCRZ.util.formatPrice(price * quantity);
                });

                Handlebars.registerHelper('replace', function (find, replace, options) {
                    var string = options.fn(this);
                    return string.replace(find, replace);
                });

                Handlebars.registerHelper('concat', function (string1, string2) {
                    return string1 + string2;
                });

                Handlebars.registerHelper('getTotalQuantity', function (items) {
                    let total = 0;
                    if (items && items.length > 0) {
                        items.forEach(function (item) {
                            if (!(item.cartItemType == 'Minor' || item.orderLineType == 'Minor')) {
                                total += item.quantity;
                            }
                        });
                    }
                    return total;
                });

                Handlebars.registerHelper("inc", function (value, options) {
                    return parseInt(value) + 1;
                });
                Handlebars.registerHelper('getStoreAvailability', function (storeHours, storeTimeZone, isQuantityAvailable) {
                    let status = '';
                    //mapping of us timezones to iana timezone format
                    let tzMap = {
                        "AST": "America/Puerto_Rico",
                        "EST": "America/Jamaica",
                        "CST": "America/Costa_Rica",
                        "MST": "America/Phoenix",
                        "PST": "America/Los_Angeles",
                        "AKST": "America/Anchorage",
                        "HAST": "Pacific/Honolulu",
                        "SST": "Pacific/Pago_Pago",
                        "CHST": "Pacific/Guam"
                    };
                    if (isQuantityAvailable) {
                        if(_.isUndefined(storeHours) && _.isUndefined(storeTimeZone)) {
                            if(this.b2bSelectedStore) {
                                let selectedStore = JSON.parse(this.b2bSelectedStore);
                                storeHours = selectedStore.store_hours;
                                storeTimeZone = selectedStore.c_storeTimezone;
                            }
                        }
                        if (!_.isUndefined(storeHours) && storeHours != '') {
                            let dayNames = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
                            let storeOpenHours = storeHours.split('*'), todayDate = new Date(),
                                todayDayName = dayNames[todayDate.getDay()];
                            let tomorrow = new Date(todayDate.getTime() + 24 * 60 * 60 * 1000),
                                tomorrowName = dayNames[tomorrow.getDay()], tomOpenTime = "";
                            storeOpenHours.forEach(function (storeHour, index) {
                                let openClosesHours = storeHour.split(':'), storeDayName = openClosesHours[0];
                                if ($.trim(storeDayName) == todayDayName) {
                                    if ($.trim(openClosesHours[1]) == 'Closed') {
                                        status = 'Tomorrow';
                                    }
                                    if ($.trim(openClosesHours[1]).indexOf('Hours not scheduled') > -1) {
                                        status = 'Later';
                                    } else {
                                        let openCloseTime = openClosesHours[1].split('-'), openTime = openCloseTime[0],
                                            closeTime1 = openCloseTime[1];
                                        // converting current time to store's timezone
                                        // en-GB uses day-month-year order and 24-hour time without AM/PM  "20/12/2012 03:00:00"
                                        let localeString = new Date(Date.now()).toLocaleString('en-GB', {timeZone: tzMap[storeTimeZone] || "UTC"}).trim();
                                        //IE returns localestring with spaces instead of comma, so need to handle both scenarios
                                        let today = localeString.indexOf(",") > 0 ? localeString.split(",") : localeString.split(" ");
                                        let currentTime = today[1].toString();
                                        //IE can return time strings with unexpected characters so have to sanatize
                                        let h = Number(currentTime.split(':')[0].replace(/\D/g, ''));

                                        //added dst offset
                                        const jan = new Date(0, 1);
                                        const jul = new Date(6, 1);
                                        const currentTimezoneOffset = Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
                                        const currentDay = new Date();
                                        if (currentDay.getTimezoneOffset() < currentTimezoneOffset) {
                                            h += 1;
                                        }

                                        let closeTimeHours, closeTimeInSecs, currentTimeInSecs, openTimeInSecs;
                                        if (typeof closeTime1 != "undefined") {
                                            let cth = closeTime1.trim().split(' ');
                                            closeTimeHours = parseInt(cth[0]);
                                            closeTimeHours += 12;
                                            openTimeInSecs = parseInt(openTime.trim().split(' ')[0]) * 60 * 60;

                                            pickupOffset = parseInt(CCRZ.pagevars.pageConfig.get('c.pickupoffset'));

                                            closeTimeInSecs = closeTimeHours * 60 * 60, currentTimeInSecs = h * 60 * 60, offSetTimeInSecs = pickupOffset * 60 * 60;
                                            // need to change 3 to CCC Admin Config rather than a metadata
                                            if (currentTimeInSecs >= openTimeInSecs && currentTimeInSecs + offSetTimeInSecs < closeTimeInSecs) {
                                                status = 'Today';
                                            } else {
                                                if (h > 0 && currentTimeInSecs < openTimeInSecs) {
                                                    status = 'Today';
                                                } else {
                                                    status = 'Tomorrow';
                                                }
                                            }
                                        } else {
                                            status = 'Later';
                                        }
                                    }
                                }
                            });
                        } else {
                            status = 'Later';
                        }
                    } else {
                        status = 'Later';
                    }
                    return status;
                });

                Handlebars.registerHelper('getStoreHours', function (storeHours) {
                    if (storeHours != null) {
                        let returnedHtml = '';
                        let storeOpenHours = storeHours.split('*');

                        for (let i = 0; i < storeOpenHours.length; i++) {
                            let eachHoursSlot = storeOpenHours[i];
                            eachHoursSlot = eachHoursSlot.replace(':', ' ');
                            returnedHtml += storeOpenHours[i] + '<br>';
                        }
                        let text = returnedHtml.replace(/(\r\n|\n|\r)/gm, '<br>');
                        return new Handlebars.SafeString(text);
                    }
                });

                Handlebars.registerHelper('openHours', function (storeHours, storeTimeZone) {
                    let returnedHtml = '';
                    if (storeHours != null) {
                        let dayMap = {
                            'Mon': 'Monday',
                            'Tue': 'Tuesday',
                            'Wed': 'Wednesday',
                            'Thu': 'Thursday',
                            'Fri': 'Friday',
                            'Sat': 'Saturday',
                            'Sun': 'Sunday',
                        }

                        let storeOpenHours = storeHours.split('*');
                        let d = new Date(Date.now());
                        let dayName = d.toString().split(' ')[0];
                        let todayDayName = dayMap[dayName];
                        var weekday = new Array(7);
                        weekday[0] = "Sunday";
                        weekday[1] = "Monday";
                        weekday[2] = "Tuesday";
                        weekday[3] = "Wednesday";
                        weekday[4] = "Thursday";
                        weekday[5] = "Friday";
                        weekday[6] = "Saturday";
                        //mapping of us timezones to iana timezone format
                        let tzMap = {
                            "AST": "America/Puerto_Rico",
                            "EST": "America/Jamaica",
                            "CST": "America/Costa_Rica",
                            "MST": "America/Phoenix",
                            "PST": "America/Los_Angeles",
                            "AKST": "America/Anchorage",
                            "HAST": "Pacific/Honolulu",
                            "SST": "Pacific/Pago_Pago",
                            "CHST": "Pacific/Guam"
                        };
                        var tomorrow = new Date(d.getTime() + 24 * 60 * 60 * 1000);
                        let tomorrowName = weekday[tomorrow.getDay()];
                        let tomOpenTime = "";
                        for (let i = 0; i < storeOpenHours.length; i++) {
                            let openClosesHoues = storeOpenHours[i].split(':');
                            let storeDayName = openClosesHoues[0];

                            if ($.trim(storeDayName) == tomorrowName) {
                                if ($.trim(openClosesHoues[1]) == 'Closed') {
                                    tomorrowName = 'Monday';
                                    for (let j = 0; j < storeOpenHours.length; j++) {
                                        let openClosesHoues1 = storeOpenHours[j].split(':');
                                        let storeDayName1 = openClosesHoues1[0];
                                        if ($.trim(storeDayName1) == tomorrowName) {
                                            tomOpenTime = openClosesHoues1[1].split('-')[0];

                                        }
                                    }
                                } else {
                                    let openCloseTime = openClosesHoues[1].split('-');
                                    tomOpenTime = openCloseTime[0];
                                }
                            }
                        }

                        for (let i = 0; i < storeOpenHours.length; i++) {
                            let openClosesHoues = storeOpenHours[i].split(':');
                            let storeDayName = openClosesHoues[0];
                            if ($.trim(storeDayName) == todayDayName) {
                                if ($.trim(openClosesHoues[1]) == 'Closed') {
                                    returnedHtml += '<div><span><strong style="color: red;">Closed </strong> Opens ' + tomorrowName + '  at  ' + tomOpenTime + '</span></div>';
                                } else {
                                    let openCloseTime = openClosesHoues[1].split('-');
                                    let openTime = openCloseTime[0];
                                    let closeTime1 = openCloseTime[1];
                                    // converting current time to store's timezone
                                    // en-GB uses day-month-year order and 24-hour time without AM/PM  "20/12/2012 03:00:00"
                                    var localeString = new Date(Date.now()).toLocaleString('en-GB', {timeZone: tzMap[storeTimeZone] || "UTC"}).trim();
                                    //IE returns localestring with spaces instead of comma, so need to handle both scenarios
                                    let today = localeString.indexOf(",") > 0 ? localeString.split(",") : localeString.split(" ");
                                    let currentTime = today[1].toString();
                                    //IE can return time strings with unexpected characters so have to sanatize
                                    let h = Number(currentTime.split(':')[0].replace(/\D/g, ''));

                                    let closeTimeHours;
                                    if (typeof closeTime1 != "undefined") {
                                        let cth = closeTime1.trim().split(' ');
                                        closeTimeHours = parseInt(cth[0]);
                                        closeTimeHours += 12;
                                    }

                                    if (h < openTime.trim().split(' ')[0]) {
                                        returnedHtml += '<div><span><strong style="color: red;">Closed </strong> Opens ' + todayDayName + ' at ' + openTime.trim() + '</span></div>';
                                    } else if (h >= closeTimeHours) {
                                        returnedHtml += '<div><span><strong style="color: red;">Closed </strong> Opens ' + tomorrowName + ' at ' + tomOpenTime + '</span></div>';
                                    } else {
                                        returnedHtml += '<div><span><strong style="color: #005A1C;">Open </strong> Closes ' + closeTime1 + '</span></div>';
                                    }
                                }


                            }

                        }
                    }
                    return returnedHtml;
                });


                Handlebars.registerHelper('isdefined', function (value) {
                    return value !== undefined;
                });

                Handlebars.registerHelper("inc", function (value, options) {
                    return parseInt(value) + 1;
                });

                Handlebars.registerHelper('filterOpenHours', function (isFiltered, ifSelected, status, pickupStatus, hasQuantityNetworkWide, c_enableBopis, c_enableSts, isSelectedStore) {
                    if(isSelectedStore) {
                        return true;
                    }
                    if (isFiltered && !c_enableBopis && !c_enableSts) {
                        return false;
                    }
                    if (isFiltered && !ifSelected) {
                        if (status == 'OUT_OF_STOCK' || !hasQuantityNetworkWide) {
                            return false;
                        }
                    }
                    return true;
                });
                //Make sure to use {{{ }}} to escape the bad characters that the page label sends
                Handlebars.registerHelper('returnTrackingUrl', function (trackingNo, carrier) {
                    let upsTracking = CCRZ.processPageLabelMap('TrackingURL_UPS', [trackingNo]);
                    let fedexTracking = CCRZ.processPageLabelMap('TrackingURL_FedEx', [trackingNo]);
                    if (carrier == 'UPS') {
                        if(upsTracking == undefined || upsTracking == '') {
                            upsTracking = 'http://wwwapps.ups.com/WebTracking/track?track=yes&trackNums=' + trackingNo;
                        }
                        return upsTracking;
                    } else if (carrier == 'FDX' || carrier == 'FDXG' || carrier == 'Fedex') {
                        if(fedexTracking == undefined || fedexTracking == '') {
                            fedexTracking = 'https://www.fedex.com/fedextrack/?action=track&trackingnumber=' + trackingNo + '&cntry_code=us&locale=en_US';
                        }
                        return fedexTracking;
                    }
                    return trackingNo;
                });
                Handlebars.registerHelper('displayTracking', function (orderItemGroup, orderShipments, options) {
                    if (!orderItemGroup.isStorePickup) {
                        if (orderShipments) {
                            return options.fn(this);
                        }
                        return options.inverse(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('returnShipmentTrackingInfo', function (orderItemGroup, orderShipments, options) {

                    let orderItemListWithTracking = [];
                    let mapOrderItemIdtoOrderShipment = {};//map of order item id to list of order shipment record including quantity
                    let orderItemList = orderItemGroup.EOrderItemsS;
                    for (let i = 0; i < orderItemList.length; i++) {
                        if (orderItemList[i].CCOrderShipmentItemsS) {
                            for (let j = 0; j < orderItemList[i].CCOrderShipmentItemsS.length; j++) {
                                if (orderItemList[i].CCOrderShipmentItemsS[j].lpmbbOrderItem in mapOrderItemIdtoOrderShipment) {
                                    //JSON parse and stringify is because I need a deep copy and not a reference
                                    let tempOrderShipmentItem = JSON.parse(JSON.stringify(orderItemList[i].CCOrderShipmentItemsS[j]));
                                    mapOrderItemIdtoOrderShipment[orderItemList[i].sfid].push(tempOrderShipmentItem);
                                } else {
                                    let tempOrderShipmentItem = JSON.parse(JSON.stringify(orderItemList[i].CCOrderShipmentItemsS[j]));
                                    mapOrderItemIdtoOrderShipment[orderItemList[i].sfid] = [tempOrderShipmentItem];
                                }


                            }
                        }
                    }

                    let mapOrderShipmentIdtoOrderShipment = {};
                    for (let i = 0; i < orderShipments.length; i++) {
                        mapOrderShipmentIdtoOrderShipment[orderShipments[i].sfid] = orderShipments[i];
                    }

                    for (let i = 0; i < orderItemList.length; i++) {
                        if (orderItemList[i].productR.productType == "Bundle") {
                            var tempOrderItemList = JSON.parse(JSON.stringify(orderItemList[i]));
                            tempOrderItemList.status = orderItemList[i].orderItemStatus;
                            tempOrderItemList.trackingQty = orderItemList[i].quantity;
                            orderItemListWithTracking.push(tempOrderItemList);
                        } else if (orderItemList[i].sfid in mapOrderItemIdtoOrderShipment) {
                            for (let j = 0; j < mapOrderItemIdtoOrderShipment[orderItemList[i].sfid].length; j++) {
                                let orderShipmentId = mapOrderItemIdtoOrderShipment[orderItemList[i].sfid][j].orderShipment;

                                var tempOrderItemList = JSON.parse(JSON.stringify(orderItemList[i]));
                                tempOrderItemList.status = orderItemList[i].orderItemStatus;
                                tempOrderItemList.trackingQty = mapOrderItemIdtoOrderShipment[orderItemList[i].sfid][j].quantity;
                                tempOrderItemList.shipmentDate = mapOrderShipmentIdtoOrderShipment[orderShipmentId].shipmentDate;
                                tempOrderItemList.trackingNo = mapOrderShipmentIdtoOrderShipment[orderShipmentId].trackingNo;
                                tempOrderItemList.carrier = mapOrderShipmentIdtoOrderShipment[orderShipmentId].carrier;
                                orderItemListWithTracking.push(tempOrderItemList);
                            }
                        } else {
                            var tempOrderItemList = JSON.parse(JSON.stringify(orderItemList[i]));
                            tempOrderItemList.status = orderItemList[i].orderItemStatus;
                            ;
                            orderItemListWithTracking.push(tempOrderItemList);
                        }
                    }

                    return orderItemListWithTracking;
                });
                Handlebars.registerHelper('ifExists', function (obj, options) {
                    debugger;
                    if (obj) {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('filterShowMap', function (storeModel, options) {
                    if (storeModel.isError || util.isIE()) {
                        return options.inverse(this);
                    } else {
                        if (_.isEmpty(storeModel.storeList)) {
                            return options.inverse(this);
                        }
                    }
                    return options.fn(this);
                });
                Handlebars.registerHelper('showOrderItemStatus', function (isStorePickup, options) {
                    if (isStorePickup && CCRZ.pagevars.currentPageName == 'ccrz__OrderView') {
                        return options.fn(this);

                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('hidePickupSTS', function (isShowStore, isNotSubsc, selectedStore, LPMSTSEnabled, isQuantityAvailable, hideForAllSelectedType, options) {
                    if (isShowStore && isNotSubsc && !_.isUndefined(selectedStore) && selectedStore.c_enableBopis && selectedStore.c_enableSts && !LPMSTSEnabled && !isQuantityAvailable) {
                        if (hideForAllSelectedType) {
                            return options.fn(this);
                        } else if (CCRZ.productDetailModel.attributes.selectedShipType == 'store') {
                            return options.fn(this);
                        }
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('hidePickupSTSSaS', function (c_enableBopis, c_enableSts, isPDP, isCart, hasQuantityNetworkWide, isQuantityAvailable, options) {
                    if (CCRZ.pagevars.currentPageName == "ccrz__ProductDetails") {
                        LPMSTSEnabled = CCRZ.productDetailModel.attributes.product.prodBean.LPMSTSEnabled;
                    } else if (CCRZ.pagevars.currentPageName == 'ccrz__Cart') {
                        productSKU = CCRZ.storeView.model.attributes.productSKU;
                        if (productSKU) {
                            LPMSTSEnabled = false;
                            CCRZ.cartDetailModel.attributes.ECartItemsS.models.forEach(function (cItem) {
                                if (productSKU == cItem.attributes.product.SKU) {
                                    LPMSTSEnabled = cItem.attributes.product.LPMSTSEnabled;
                                }
                            });
                        } else {
                            LPMSTSEnabled = false;
                        }
                    }
                    if (c_enableBopis && c_enableSts && (isPDP || isCart) && hasQuantityNetworkWide && !isQuantityAvailable && !LPMSTSEnabled && !isQuantityAvailable) {
                        return options.fn(this);

                    }
                    return options.inverse(this);
                });

                Handlebars.registerHelper('hideNoBOPISSTFilterSSaS', function (isFiltered, isPDP, isCart, options) {
                    if (isFiltered && (isPDP || isCart)) {
                        let LPMBBAvailableForInStorePickup = true;
                        let LPMBBIsInStoreOnly = true;
                        if (CCRZ.pagevars.currentPageName == "ccrz__ProductDetails") {
                            LPMBBAvailableForInStorePickup = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBAvailableForInStorePickup;
                            LPMBBIsInStoreOnly = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBIsInStoreOnly;
                        } else if (CCRZ.pagevars.currentPageName == 'ccrz__Cart') {
                            productSKU = CCRZ.storeView.model.attributes.productSKU;
                            if (productSKU) {
                                LPMSTSEnabled = false;
                                CCRZ.cartDetailModel.attributes.ECartItemsS.models.forEach(function (cItem) {
                                    if (productSKU == cItem.attributes.product.SKU) {
                                        LPMBBAvailableForInStorePickup = cItem.attributes.product.LPMBBAvailableForInStorePickup;
                                        LPMBBIsInStoreOnly = cItem.attributes.product.LPMBBIsInStoreOnly;
                                    }
                                });
                            } else {
                                LPMBBAvailableForInStorePickup = false;
                                LPMBBIsInStoreOnly = false;
                            }
                        }
                        if (!LPMBBIsInStoreOnly && !LPMBBAvailableForInStorePickup) {
                            return options.fn(this);
                        }

                    }
                    return options.inverse(this);

                });
                Handlebars.registerHelper('hideNoBOPISSTSSaS', function (isPDP, isCart, options) {
                    let LPMBBAvailableForInStorePickup = true;
                    let LPMBBIsInStoreOnly = true;
                    if (CCRZ.pagevars.currentPageName == "ccrz__ProductDetails") {
                        LPMBBAvailableForInStorePickup = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBAvailableForInStorePickup;
                        LPMBBIsInStoreOnly = CCRZ.productDetailModel.attributes.product.prodBean.LPMBBIsInStoreOnly;
                    } else if (CCRZ.pagevars.currentPageName == 'ccrz__Cart') {
                        productSKU = CCRZ.storeView.model.attributes.productSKU;
                        if (productSKU) {
                            LPMSTSEnabled = false;
                            CCRZ.cartDetailModel.attributes.ECartItemsS.models.forEach(function (cItem) {
                                if (productSKU == cItem.attributes.product.SKU) {
                                    LPMBBAvailableForInStorePickup = cItem.attributes.product.LPMBBAvailableForInStorePickup;
                                    LPMBBIsInStoreOnly = cItem.attributes.product.LPMBBIsInStoreOnly;
                                }
                            });
                        } else {
                            LPMBBAvailableForInStorePickup = false;
                            LPMBBIsInStoreOnly = false;
                        }
                    }
                    if (!LPMBBIsInStoreOnly && !LPMBBAvailableForInStorePickup && (isPDP || isCart)) {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('checkSTS', function (options) {
                    if (CCRZ.pagevars.currentPageName == "ccrz__ProductDetails") {
                        LPMSTSEnabled = CCRZ.productDetailModel.attributes.product.prodBean.LPMSTSEnabled;
                    } else if (CCRZ.pagevars.currentPageName == 'ccrz__Cart') {
                        productSKU = CCRZ.storeView.model.attributes.productSKU;
                        if (productSKU) {
                            LPMSTSEnabled = false;
                            CCRZ.cartDetailModel.attributes.ECartItemsS.models.forEach(function (cItem) {
                                if (productSKU == cItem.attributes.product.SKU) {
                                    LPMSTSEnabled = cItem.attributes.product.LPMSTSEnabled;
                                }
                            });
                        } else {
                            return options.inverse(this);
                        }
                    } else {
                        return options.fn(this);
                    }
                    return LPMSTSEnabled ? options.fn(this) : options.inverse(this);
                });
                Handlebars.registerHelper('turnToClass', function (inputString) {
                    if (inputString)
                        return inputString.toLowerCase().replace(/\s+/g, '-');
                    else
                        return inputString;
                });
                Handlebars.registerHelper('altProdRelationship', function (sfid) {
                    let relatedProds = CCRZ.prodDetailView.model.attributes.product.prodBean.ERelatedProductsS;
                    let relationship = '';
                    for (i = 0; i < relatedProds.length; ++i) {
                        let prod = relatedProds[i];
                        if (prod.relatedProduct == sfid) {
                            relationship = prod.alternateRelationship;
                            break;
                        }
                    }
                    return relationship;
                });
                //create a variable. Reference variable in handlebars template as follows: @root.varName
                Handlebars.registerHelper('assign', function (varName, varValue, options) {
                    if (!options.data.root) {
                        options.data.root = {};
                    }
                    options.data.root[varName] = varValue;
                });

                Handlebars.registerHelper('getInStoreLaterMessaging', function (isBackOrderElgible, isQuantityAvailable, LPMBBInStockDate) {
                    let retHTML = '';
                    if(isBackOrderElgible && !isQuantityAvailable) {
                        let formatedDate = util.formatDate(new Date(LPMBBInStockDate), 'mm/yyyy');
                        retHTML = '<span class="backorder-label">Back Order</span><br>';
                        retHTML += '<span class="backorder-text-pdp">Expected Shipment '+formatedDate+'</span>';
                    } else if (!isQuantityAvailable) {
                        retHTML += '<span class="backorder-text-pdp">Available at store in 1-2 weeks</span>';
                    } else {
                        retHTML = '<span class="pickup-text-red">Later</span>';
                    }
                    return retHTML;
                });

                //Backorder messaging helper for ship to products/orders
                Handlebars.registerHelper('showBackOrder', function (isBackOrderElgible, productInvQty, options) {
                    if (isBackOrderElgible && (productInvQty == 0 || productInvQty == undefined)) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                //Backorder messaging helper for in stor pickup products/orders
                Handlebars.registerHelper('showBackOrderInStore', function (isBackOrderElgible, selectedStoreQty, quantity, shippableInventory, options) {
                    if (isBackOrderElgible && quantity > selectedStoreQty && ((quantity > shippableInventory) || shippableInventory == undefined || shippableInventory == null)) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                //Used if you are many levels deep and need to find a product specifically its inventory item data
                //fieldName: name of field from product inventory item that you want
                //productId: sfid of the product that you are looking for
                //productList: list of products that are loaded on the data model. EX: ../this.productList
                Handlebars.registerHelper("firstInventoryItemField", function (fieldName, productId, productList) {
                    if (productId) {
                        var product = _.findWhere(productList, {sfid: productId});
                        if (product && product["productInventoryItemsS"]) {
                            return product["productInventoryItemsS"][0][fieldName];
                        }
                    }
                    return '';
                });

                Handlebars.registerHelper("getUserFullName", function () {
                    let currUser = CCRZ.currentUser;
                    let firstLastStr = '';
                    if (currUser) {
                        firstLastStr = currUser.FirstName + ' ' + currUser.LastName;
                    }
                    return firstLastStr;
                });

                /*
                    This handlebar will check a given list to see if there is a record that matches a give object property
                    and given value, if a record exists then return showing whatever inside the handle bar
                    EX: exampleList = [{id: 1, color: "green", isPrimary:false}, {id: 2, color: "blue", isPrimary: true}]
                    {{#ifExistsInList exampleList "color" "blue"}}
                    Since there is a record with the property color="blue" the HTML
                    objectArry - Needs to be an array of objects
                    fieldName - Is a property that is in the objectArray, needs to be in quotes ""
                    fieldValue - Is the value you are looking for. If string use quotes, boolean without quotes
                */
                Handlebars.registerHelper("ifExistsInList", function(objectArry, fieldName, fieldValue, options) {
                    var search_obj = {};
                    search_obj[fieldName] = fieldValue;
                    var matchObject = _.findWhere(objectArry, search_obj);

                    if(matchObject !== undefined) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                Handlebars.registerHelper("downloadOrderURL", function(orderId) {
                    var orderPDFURL = CCRZ.pagevars.currSiteURL;
                    orderPDFURL += 'b2b_OrderConfirmationPDF?id=' + orderId;
                    return orderPDFURL;
                });

                Handlebars.registerHelper("downloadInstoreOrderURL", function() {
                    var orderPDFURL = CCRZ.pagevars.currSiteURL;
                    orderPDFURL += 'b2b_InStoreOrderConfirmPDF';
                    return orderPDFURL;
                });

                Handlebars.registerHelper("productMckObj", function (recentOrderItem){
                    var linkObj = {
                        'name': recentOrderItem.name,
                        'SKU': recentOrderItem.sku,
                    };
                    return linkObj;
                });

                Handlebars.registerHelper("mediaImageMckObj", function (recentOrderItem){
                    var linkObj = {
                        'URI': recentOrderItem.imageURL,
                        'uri': recentOrderItem.imageURL,
                        'mediaName': recentOrderItem.imageURL,
                        'mediaType': "Product Search Image",
                        'productMediaSource': "URI"
                    };
                    return linkObj;
                });

                Handlebars.registerHelper("startNewRow", function (numCols, options){
                    if(options.data.index && (options.data.index + 1) % numCols == 0) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                Handlebars.registerHelper("cartItemSelectedStore", function (jsonStoreString, fieldName){
                    let selectedStoreObj = JSON.parse(jsonStoreString);
                    let fieldValue = selectedStoreObj[fieldName];
                    return fieldValue;
                });

                Handlebars.registerHelper("isStoreSelected", function (v1, options){
                    if(v1 !== undefined && v1 != '' && v1 != 'Select A Store') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });

                Handlebars.registerHelper("convertToUTCStr", function(dateStr) {
                    if(dateStr !== undefined && dateStr != '') {
                        var date = new Date(dateStr);
                        var currentUTC = Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(),
                            date.getUTCHours(),  date.getUTCMinutes(), date.getUTCSeconds());
                        var newDateUTC = new Date(currentUTC).toISOString().split('T')[0];
                        var month = newDateUTC.split('-')[1];
                        if(month.charAt(0) == '0') {
                            month = month.split('0')[1];
                        }
                        var day = newDateUTC.split('-')[2];
                        if(day.charAt(0) == '0') {
                            day = day.split('0')[1];
                        }
                        var year = newDateUTC.split('-')[0];
                        return month + '/' + day + '/'+year;
                    } else {
                        return '';
                    }
                });

                /*
                    This helper is used to help display a default value based on ticket DEV-7711
                */
                Handlebars.registerHelper("recentOrderItemStatusDisplay", function (statusValue){
                    if (statusValue == '' || statusValue ===undefined) {
                        return 'Processing';
                    }
                    let acceptedStatuses = ['Shipped',
                        'Partial Shipped/Partial Cancelled',
                        'Partial Shipped',
                        'Shipped/Cancelled',
                        'Partial Picked up/Partial Cancelled',
                        'Partial Picked up',
                        'Picked up/Cancelled',
                        'Partial Ready for Pickup',
                        'Cancelled',
                        'Partial Cancelled',
                        'Ready for Pickup',
                        'Picked Up'];
                    if(acceptedStatuses.includes(statusValue)) {
                        return statusValue;
                    } else{
                        return 'Processing';
                    }
                });

                /*
                    This helper is used to determine the total products to display when using an each_upto where
                    the requirements can vary by the page. This is bare bones, as the requirements for DEV-8126
                    is to show 6 products on the PLP and 8 on the Home, if in the future you want to have different values
                    on the same page then add in a variable to help as this was built with only Buy Again and Featured Products in mind
                */
                Handlebars.registerHelper("totalProductsDisplay", function (){
                    if (CCRZ.pagevars.currentPageName == 'ccrz__ProductList') {
                        return 6;
                    } else {
                        return 8;
                    }
                });

                initialized = true;
            }
        }
    }
});