/**
 *  Namespace for functions that can can be used in several views/namespaces
 *  @module util
 */
d('util', function () {
    return {
        /** IMPLEMENTATION OF VALIDATION WITH ERROR LABELS
         1.Input/textarea must be inside <div data-error="Error label"></div> section.
         2.Inputs/textareas must contain classes: req_field, 'inputClass' (own unique name), col-md-12.
         3.Email and phone are optional parameters. Their fields require <div class="col-md-12 incorrectEmail"></div> (or 'incorrectPhone') section below input.
         4.Add attribute disabled="disabled" to save button.
         5.Use functions for:
         ON EVENT (e.g. keyup) => validateFields
         OTHER (e.g. view refresh) => validateAndDisable
         */
        /**
         * Function that check if fields are proper or not empty and disable button until inputs are correct
         Email and phone fields are optional.
         */
        validateFields: function (e, view, inputClass, button, email, phone) {
            validateEmptyFields(e, validateAndDisable(view, inputClass, button, email, phone));
        },
        /**
         * Function that check if fields are proper and disable button until inputs are correct
         Email and phone fields are optional.
         */
        validateAndDisable: function (view, inputClass, button, email, phone) {
            validateAndDisable(view, inputClass, button, email, phone);
        },
        /**
         * Function that check if inputs are empty
         */
        validateEmptyFields: function (e, callback) {
            validateEmptyFields(e, callback);
        },
        /**
         * Function that check if phone is valid
         */
        validatePhone: function (value) {
            return validatePhone(value);
        },
        /**
         * Function that check if email is valid
         */
        validateEmail: function (email) {
            return validateEmail(email);
        },
        /**
         * Function that check if name is off valid format
         */
        validateName: function (name) {
        },
        /**
         * Function that check if phone number from object is valid and show error label
         */
        validatePhoneFromObject: function (value, callback) {
            validatePhoneFromObject(value, callback);
        },
        /**
         * Function that check if email address from object is valid and show error label
         */
        validateEmailFromObject: function (email, callback) {
            return validateEmailFromObject(email, callback);
        },
        /**
         * Function that check if email address from object is valid and show error label
         */
        validateDatepicker: function (date) {
            return validateDatepicker(date);
        },
        /**
         * Function that remove readonly attribute for HTML tag
         */
        removeReadonly: function (date) {
            return removeReadonly(date);
        },
        /**
         * Functions that shows and hides loading cover
         */
        loadingOn: function () {

        },
        loadingOff: function () {

        },
        /**
         * Function that finds dynamic view by its name
         */
        findDynamicView: function (viewName) {
            var dynamicView = _.findWhere(CCRZ.dynamicCustomView, {viewName: viewName});
            return dynamicView;
        },
        findCheckoutView: function (viewName) {
            var viewsArray = CCRZ.cartCheckoutView.subViewArray;

            var subView = _.filter(viewsArray, function (item) {
                var view = item.view;
                if (view.viewName === viewName) {
                    return view;
                }
            }, viewName);

            return subView[0].view;
        },
        /**
         * Function that finds LLI Checkout subView by name
         */
        findLLIView: function (viewName) {
            var viewsArray = CCRZ.LLIcartCheckoutView.subViewArray;

            var subView = _.filter(viewsArray, function (item) {
                var view = item.view;
                if (view.viewName === viewName) {
                    return view;
                }
            }, viewName);

            return subView[0].view;
        },
        rotateArrow: function (event) {
            var icon = $(event.currentTarget).find(".icon-toggle i");
            var toggleableElement = $(event.currentTarget).data("target");

            $(toggleableElement).on("hidden.bs.collapse", function () {
                icon.addClass('fa-caret-down').removeClass('fa-caret-up');
            });
            $(toggleableElement).on("shown.bs.collapse", function () {
                icon.removeClass('fa-caret-down').addClass('fa-caret-up');
            });
        },
        /**
         * Function that checks if value is integer or decimal number
         */
        validateDecimalAndIntegerField: function (event) {
            var value = $(event.target).val();
            if (event.which < 45 || event.which > 58 || event.which == 47) {
                return false;
            } // prevent if not number/dot
            if (event.which == 46 && value.indexOf('.') != -1) {
                return false;
            } // prevent if already dot
            if (event.which == 45 && value.indexOf('-') != -1) {
                return false;
            } // prevent if already dot
            if (event.which == 45 && value.length > 0) {
                event.preventDefault();
            } // prevent if already -
            return true;
        },
        checkIfFieldIsNotEmpty: function (input) {
            var value = input.val().trim();
            return (value != "") ? true : false;
        },
        hideLoader: function () {
            hideLoader();
        },
        showLoader: function () {
            showLoader();
        },
        scrollToTop: function () {
            $('html, body').animate({
                scrollTop: 0
            }, 500);
        },
        validateAllFields: function (inputClass, emailId, phoneId) {
            var inputs = $("." + inputClass + "");
            var validate = true;
            _.each(inputs, function (e) {
                var target = e.target === undefined ? $(e) : $(e.target);
                validateEmptyFields(e, function (result) {
                    if (!result) {
                        validate = false;
                    }
                });
                if (emailId) {
                    if (target.attr('id') == emailId) {
                        validateEmailFromObject(target, function (result) {
                            if (!result) {
                                validate = false;
                            }
                        });
                    }
                }
                if (phoneId) {
                    if (target.attr('id') == phoneId) {
                        validatePhoneFromObject(target, function (result) {
                            if (!result) {
                                validate = false;
                            }
                        });
                    }
                }
            });
            return validate;
        },
        keepIfCollapsed: function (e, cookieName) {
            var isCollapsed = $(e.currentTarget).find('.icon-toggle .fa').hasClass('fa-caret-up'),
                daysToExpire = 180;
            setCookie(cookieName, String(isCollapsed), daysToExpire);
        },
        collapseOnRender: function (view, cookieName) {
            var isCollapsed = getCookie(cookieName),
                panelCollapse = view.$el.find('.panel-collapse'),
                iconCollapse = view.$el.find('.icon-toggle .fa');
            if (isCollapsed == "true") {
                panelCollapse.removeClass('in');
                iconCollapse.removeClass('fa-caret-up').addClass('fa-caret-down').attr('aria-expanded', 'false');
            }
        },
        convertStringToDate: function (dateToConvert) {
            return convertStringToDate(dateToConvert);
        },
        formatDate: function (date, dateFormat) {
            var year = date.getUTCFullYear();
            var month = date.getUTCMonth() + 1;

            if (month < 10) {
                month = '0' + month;
            }
            var day = date.getUTCDate();
            if (day < 10) {
                day = '0' + day;
            }
            switch (dateFormat) {
                case 'yyyy/mm/dd':
                    return year + '/' + month + '/' + day;
                case 'dd/mm/yyyy':
                    return day + '/' + month + '/' + year;
                case 'mm/yyyy':
                    return month + '/' + year;
                default:
                    return month + '/' + day + '/' + year;
            }
        },
        isMobile: function () {
            var screensize = $(window).width();
            var maxDeviceWidth = 768; //max device width in px

            return (screensize < maxDeviceWidth) ? true : false;
            ;
        },
        currViewState: function () {
            return CCRZ.getQueryParam('viewState');
        },
        clearInput: function (e) {
            e.target.value = '';
        },
        setDefaultQty: function (e) {
            if (e.target.value == '') e.target.value = 1;
        },
        loadOverlay: function (container) {
            $(container).prepend(createOverlay());
            if (!CCRZ.disableAdaptive) {
                $("#overlay").css({
                    width: $(window).width() / 2,
                    height: $(window).height() / 2,
                    top: $(window).height() / 4,
                    left: $(window).width() / 4
                });
                $(".circleContainer").css({
                    top: $(window).height() / 5,
                    left: $(window).width() / 5
                });
            }
            $("#overlay").show();
        },
        unloadOverlay: function () {
            $("#overlay").remove();
        },
        removeWhitespaceFromInput: function (e, fieldId) {
            if (e.target.value.indexOf(' ') > -1) {
                var fieldValue = document.querySelector(fieldId).value;
                document.querySelector(fieldId).value = fieldValue.replace(/ /g, '');
            }
        },
        isValidField: function (elementId) {
            if ($.trim($("#" + elementId).val()) === '') {
                return false;
            } else {
                return true;
            }
        },
        validateCartReservationError: function (res) {
            let errorLabelAPI = '', isValidation = true;
            CCRZ.cartDetailView.model.set('isError', true);
            let warningFaicon = '<i class="fa fa-exclamation-triangle" aria-hidden="true"></i>';
            let cartItems = CCRZ.cartDetailView.model.attributes.ECartItemsS;
            cartItems.models.forEach(function (cartItem, index) {
                let errorList = [], errorMessage = '';
                if (res.data && res.data.length > 0) {
                    errorList = res.data.filter(function (item) {
                        return cartItem.attributes.sfid == item.cartItemId;
                    });
                }
                if (!cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.product.LPMBBIsInStoreOnly) {
                    // When ship to is Home and Store pick up option only for the product
                    errorMessage += CCRZ.processPageLabelMap('LPM_BB_Reorder_IsInStoreOnly', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                } else {
                    if (cartItem.attributes.cartItemGroupR.isStorePickup && !cartItem.attributes.product.LPMBBAvailableForInStorePickup) {
                        // Store pickup and store pickup not available on the product
                        errorMessage += CCRZ.processPageLabelMap('LPM_BB_Reorder_NotAvailableForStorePickup', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                    } else if (cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.LPMIsPickupLater && cartItem.attributes.product.LPMBBIsInStoreOnly && !cartItem.attributes.product.LPMSTSEnabled) {
                        errorMessage += CCRZ.processPageLabelMap('LPM_Cart_laterInstoreOnly', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                    } else if (cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.LPMIsPickupLater && !cartItem.attributes.product.LPMBBIsInStoreOnly && !cartItem.attributes.product.LPMSTSEnabled) {
                        errorMessage += CCRZ.processPageLabelMap('LPM_Cart_laterNotInstoreOnly', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                    }else if(cartItem.attributes.cartItemGroupR.isStorePickup && cartItem.attributes.productR.LPMBBBackOrderEligible && !cartItem.attributes.isStoreQuantityAvailable && cartItem.attributes.cartItemGroupR.displayName.toLowerCase().includes('store')){
                        let backorderTime = '';
                        if(cartItem.attributes.productR.LPMBBInStockDate != undefined){
                            backorderTime = 'pickup by ';
                            backorderTime += Handlebars.helpers.dateFormat(cartItem.attributes.productR.LPMBBInStockDate, 'mm/yyyy');
                        }
                        errorMessage += CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_Cart_LineItemChanges', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName, backorderTime]);
                    } else if(cartItem.attributes.cartItemGroupR.isStorePickup && !cartItem.attributes.isStoreQuantityAvailable) {
                        let promiseTime = '';
                        if(cartItem.attributes.b2bPromiseDate != undefined) {
                            promiseTime = 'pickup by ';
                            promiseTime += cartItem.attributes.b2bPromiseDate;
                        } else {
                            promiseTime = 'get it in 24-48 hours';
                        }
                        errorMessage += CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_Cart_LineItemChanges', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName, promiseTime]);
                    } else if (errorList.length > 0) {
                        let promiseTime = '';
                        if(cartItem.attributes.b2bPromiseDate != undefined) {
                            promiseTime = 'pickup by ';
                            promiseTime += cartItem.attributes.b2bPromiseDate;
                        } else {
                            promiseTime = 'get it in 24-48 hours';
                        }
                        errorMessage += CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_Cart_LineItemChanges', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName, promiseTime]);
                    }
                }
                if (errorMessage != '') {
                    let tooltip = CCRZ.pagevars.pageLabels['LPM_BB_cartErrorTooltip'];
                    let cartItemLink = "<a data-toggle='tooltip' title='" + tooltip + "' href='#cc_cart_item" + cartItem.attributes.sfid + "' style='color: #a94442;'>"
                    errorLabelAPI += cartItemLink + warningFaicon + errorMessage;
                    errorLabelAPI += '</a>';
                    if ((index + 1 < (cartItems.length))) {
                        errorLabelAPI += "<div class='cc_cart_error_newline'></div>";
                    }
                    isValidation = false;
                }
            });
            // Removing this as there is no differnece in error message for change in status done on the cart page
            /*else if(res.data.length > 1){
                let cartItems = CCRZ.cartDetailView.model.attributes.ECartItemsS;
                res.data.forEach(function(item, index){
                    let currentCartItem = cartItems.models.filter(function(cItem){
                        return cItem.attributes.sfid == item.cartItemId;
                    });
                    if(currentCartItem.length > 0){
                        let cartItem = currentCartItem[0];
                        let cartItemLink = "<a href='#cc_cart_item"+cartItem.attributes.sfid+"' style='color: #a94442;'>"
                        errorLabelAPI += cartItemLink+warningFaicon;
                        if(currentCartItem[0].attributes.product.LPMBBIsInStoreOnly && !currentCartItem[0].attributes.product.LPMSTSEnabled){
                            errorLabelAPI += CCRZ.processPageLabelMap('LPM_Cart_laterInstoreOnly', [currentCartItem[0].attributes.product.sfdcName, currentCartItem[0].attributes.cartItemGroupR.groupName]);
                        } else if(!currentCartItem[0].attributes.product.LPMBBIsInStoreOnly && !currentCartItem[0].attributes.product.LPMSTSEnabled){
                            errorLabelAPI += CCRZ.processPageLabelMap('LPM_Cart_laterNotInstoreOnly', [currentCartItem[0].attributes.product.sfdcName, currentCartItem[0].attributes.cartItemGroupR.groupName]);
                        } else {
                            errorLabelAPI += CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_Cart_LineItemChanges', [cartItem.attributes.product.sfdcName, cartItem.attributes.cartItemGroupR.groupName]);
                        }
                        errorLabelAPI += '</a>';
                        if((index+1 < (res.data.length))){
                            errorLabelAPI += "<div class='cc_cart_error_newline'></div>";
                        }
                    }
                });
            }*/
            CCRZ.cartDetailView.model.set('errorMessageLabel', errorLabelAPI);
            CCRZ.cartDetailView.model.set('isError', !isValidation);
        },
        validateAllFieldTypesById: function (inputClass) {
            let check = true;
            var input = $(inputClass + ' input'), select = $(inputClass + ' select');
            for (var i = 0; i < input.length; i++) {
                if (this.validate(input[i]) == false) {
                    this.showValidate(input[i], inputClass);
                    check = false;
                }
            }
            for (var i = 0; i < select.length; i++) {
                if (this.validateSelect(select[i]) == false) {
                    this.showValidate(select[i], inputClass);
                    check = false;
                }
            }
            return check;
        },
        validateAllFieldTypes: function () {
            let check = true;
            var input = $('.inputVal input'), select = $('.inputVal select');
            for (var i = 0; i < input.length; i++) {
                if (this.validate(input[i]) == false) {
                    this.showValidate(input[i], '.inputVal');
                    check = false;
                }
            }
            for (var i = 0; i < select.length; i++) {
                if (this.validateSelect(select[i]) == false) {
                    this.showValidate(select[i], '.inputVal');
                    check = false;
                }
            }
            return check;
        },
        validate: function (input) {
            if ($(input).attr('type') == 'password' && $(input).attr('name') == 'NewPassword') {
                let password = $(input).val(), parent = $(input).parent()[0], validate = parent.dataset.default;
                if ($(input).val().trim() == '') {
                    $(parent).attr('data-validate', validate);
                    return false;
                } else if (this.validatePassword(password) == false) {
                    $(parent).attr('data-validate', CCRZ.pagevars.pageLabels['ALTB2B_register_passwordRequireError']);
                    return false;
                }
                return true;
            } else if ($(input).attr('type') == 'password' && $(input).attr('name') == 'ConfirmPassword') {
                let confirmPassVal = $(input).val(), newPassVal = $('#' + $(input).attr('data-pass')).val(),
                    parent = $(input).parent()[0], validate = parent.dataset.default;
                if ($(input).val().trim() == '') {
                    $(parent).attr('data-validate', validate);
                    return false;
                } else if (confirmPassVal !== newPassVal) {
                    $(parent).attr('data-validate', CCRZ.pagevars.pageLabels['ALTB2B_register_passwordMatchError']);
                    return false;
                }
                return true;
            } else if ($(input).attr('type') == 'email' || $(input).attr('name') == 'email') {
                let parent = $(input).parent()[0], validate = parent.dataset.default;
                if ($(input).val().trim() == '') {
                    $(parent).attr('data-validate', validate);
                    return false;
                } else if ($(input).val().trim().match(/^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{1,5}|[0-9]{1,3})(\]?)$/) == null) {
                    $(parent).attr('data-validate', 'Enter a valid Email');
                    return false;
                }
                return true;
            } else if ($(input).attr('name') == 'phone') {
                let parent = $(input).parent()[0], validate = parent.dataset.default;
                if ($(input).val().trim() == '') {
                    $(parent).attr('data-validate', validate);
                    return false;
                } else if ($(input).val().trim().match(/^(\+\d{1,2}\s?)?1?\-?\.?\s?\(?\d{3}\)?[\s.-]?\d{3}[\s.-]?\d{4}$/) == null) {
                    $(parent).attr('data-validate', 'Enter a valid phone');
                    return false;
                }
                return true;
            } else if ($(input).attr('name') == 'fname' || $(input).attr('name') == 'lname') {
                let parent = $(input).parent()[0], validate = parent.dataset.default;
                if ($(input).val().trim() == '') {
                    $(parent).attr('data-validate', validate);
                    return false;
                } else if ($(input).val().trim().match(/^[A-Za-z][A-Za-z\'\-]+([\ A-Za-z][A-Za-z\'\-]+)*/) == null) {
                    $(parent).attr('data-validate', ($(input).attr('name') == 'fname' ? 'Enter a valid first name' : ($(input).attr('name') == 'lname' ? 'Enter a valid last name' : 'Enter a valid name')));
                    return false;
                }
                return true;
            } else {
                if ($(input).val().trim() == '') {
                    return false;
                }
                return true;
            }
        },
        validateSelect: function (select) {
            if ($(select).val().trim() == '') {
                return false;
            }
        },
        validatePassword: function (value) {
            let capital = $(".passwordReqire .upperCase"), letter = $(".passwordReqire .lowerCase"),
                number = $(".passwordReqire .digit")
                , special = $(".passwordReqire .specialCase"), length = $(".passwordReqire .minChar"),
                isValidate = true;
            // Validate lowercase letters
            let lowerCaseLetters = /[a-z]/g;
            if (value.match(lowerCaseLetters)) {
                letter.removeClass("text-danger");
                letter.addClass("text-success");
            } else {
                letter.removeClass("text-success");
                letter.addClass("text-danger");
                isValidate = false;
            }

            // Validate capital letters
            let upperCaseLetters = /[A-Z]/g;
            if (value.match(upperCaseLetters)) {
                capital.removeClass("text-danger");
                capital.addClass("text-success");
            } else {
                capital.removeClass("text-success");
                capital.addClass("text-danger");
                isValidate = false;
            }

            // Validate numbers
            let numbers = /[0-9]/g;
            if (value.match(numbers)) {
                number.removeClass("text-danger");
                number.addClass("text-success");
            } else {
                number.removeClass("text-success");
                number.addClass("text-danger");
                isValidate = false;
            }

            // Validate Special Characters
            let specialRegex = /[#?!@$%^&*-]/g;
            if (value.match(specialRegex)) {
                special.removeClass("text-danger");
                special.addClass("text-success");
            } else {
                special.removeClass("text-success");
                special.addClass("text-danger");
                isValidate = false;
            }

            // Validate length
            if (value.length >= 8) {
                length.removeClass("text-danger");
                length.addClass("text-success");
            } else {
                length.removeClass("text-success");
                length.addClass("text-danger");
                isValidate = false;
            }
            return isValidate;
        },
        showValidate: function (input, inputSelector) {
            var thisAlert = $(input).parents(inputSelector);

            $(thisAlert).addClass('alert-validate');
        },
        hideValidate: function (input, inputSelector) {
            var thisAlert = $(input).parents(inputSelector);
            $(thisAlert).removeClass('alert-validate');
        },
        /**
         * Port of the hidePickupSTS Handlebars helper
         */
        hidePickupSTS: function (isShowStore, isNotSubsc, selectedStore, LPMSTSEnabled, isQuantityAvailable, LPMBBIsInStoreOnly, hideForAllSelectedType) {
            if (isShowStore && isNotSubsc && selectedStore && selectedStore.c_enableBopis && selectedStore.c_enableSts && !LPMSTSEnabled && !isQuantityAvailable) {
                if (hideForAllSelectedType) {
                    return true;
                } else if (CCRZ.productDetailModel.attributes.selectedShipType == 'store') {
                    return true;
                }
            } else if (!selectedStore && LPMBBIsInStoreOnly) {
                return true;
            }
            return false;
        },

        /**
         * User Agent detection of IE based browsers
         *
         * @returns {boolean} true if IE, false otherwise
         */
        isIE: function () {
            return navigator.userAgent.indexOf('MSIE') !== -1 || navigator.appVersion.indexOf('Trident/') > -1;
        }

    }

    function createOverlay() {
        if (!CCRZ.disableAdaptive) {
            if (Modernizr.mq('only all')) {
                return "<div id='overlay'><div class='circleContainer'><div class='circle'></div><div class='circle1'></div></div></div>";
            } else {
                return "<div id='overlay'><div class='circleContainer'><img src='" + CCRZ.pagevars.themeBaseURL + "images/loading.gif' alt='loading...' /></div></div>";
            }
        } else {
            return "<div id='overlay' class='modal-backdrop fade in'></div>";
        }
    }

    function validateEmptyFields(e, callback) {
        var target = e.target === undefined ? $(e) : $(e.target),
            idTarget = target.attr("id"),
            value = target.val().trim() || "",
            keyCode = e.keyCode || e.which,
            tabKeyCode = 9,
            spaceKeyCode = 32,
            result = false;
        if (value == "" && keyCode == spaceKeyCode) {
            target.val("");
        }
        if (value == "" & keyCode != tabKeyCode) {
            if (target.parent().find('button').length != 1) {
                target.attr("placeholder", "");
                target.addClass("empty_input");
                target.closest('.form-group').find("label").addClass('empty_input_label');
                target.parent().addClass("errorContainer");
            }
            result = false;
        } else {
            target.removeClass("empty_input");
            target.closest('.form-group').find("label").removeClass('empty_input_label');
            target.parent().removeClass("errorContainer");
            result = true;
        }
        if (callback) {
            callback(result);
        }
        return result;
    }

    function checkRequiredFields(view, inputClass) {
        var v = view,
            reqFields = v.$el.find('.req_field').filter(inputClass),
            result = true;
        _.each(reqFields, function (e) {
            if (e.value.trim() == "") {
                result = false;
            }
        });
        return result;
    }

    function validateAndDisable(view, inputClass, buttonClass, emailClass, phoneClass) {
        var v = view;
        if (emailClass) {
            var email = v.$el.find(emailClass);
        }
        if (phoneClass) {
            var phone = v.$el.find(phoneClass);
        }
        if (buttonClass) {
            if (checkRequiredFields(v, inputClass) && validateEmailFromObject(email) && validatePhoneFromObject(phone)) {
                $(buttonClass).attr("disabled", false);
            } else {
                $(buttonClass).attr("disabled", true);
            }
        }
    }

    function validateEmail(email) {
        var result = false,
            email_regex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}$/i;
        if (email_regex.test(email)) {
            result = true;
        }
        return result;
    }

    function validatePhone(phone) {
        var isValidPhone = false,
            regex = /^[+]*[(]{0,1}[0-9]{1,4}[)]{0,1}[-\s\./0-9]*$/;
        var isValidPhone = phone.match(regex);
        return isValidPhone ? true : false;
    }

    function validateEmailFromObject(email, callback) {
        var result = false;
        if (email) {
            if (!_.isEmpty(email.val())) {
                var emailAddress = email.val().trim();
                result = validateEmail(emailAddress);
            } else {
                result = false;
            }
        } else result = true;

        if (result == true) {
            $(email).siblings('.incorrectEmail').hide();
            $(email).removeClass('error_input');
        } else {
            $(email).siblings('.incorrectEmail').show();
            $(email).addClass('error_input');
        }
        if (callback) {
            callback(result);
        }
        return result;
    }

    function validatePhoneFromObject(phone, callback) {
        var result = false;
        if (phone) {
            if (!_.isEmpty(phone.val())) {
                var phoneNumber = phone.val().trim();
                result = validatePhone(phoneNumber);
            } else {
                result = false;
            }
        } else result = true;

        if (result == true) {
            $(phone).siblings('.incorrectPhone').hide();
            $(phone).removeClass('error_input');
        } else {
            $(phone).siblings('.incorrectPhone').show();
            $(phone).addClass('error_input');
        }
        if (callback) {
            callback(result);
        }
        return result;
    }

    function convertStringToDate(dateToConvert) {
        var dateFormat = CCRZ.pagevars.pageLabels['Date_Format'],
            dateSplit = dateToConvert.split('/');
        switch (dateFormat) {
            case 'dd/mm/yyyy':
                var convertedDate = dateSplit[1] + '/' + dateSplit[0] + '/' + dateSplit[2];
                return new Date(convertedDate);
            case 'yyyy/mm/dd':
                var convertedDate = dateSplit[1] + '/' + dateSplit[2] + '/' + dateSplit[0];
                return new Date(convertedDate);
            default:
                return new Date(dateToConvert);
        }
    }

    function validateDatepicker(date) {
        var isValidDate = false,
            dateFormat = CCRZ.pagevars.pageLabels['Date_Format'],
            regex = getRegexForFormatDate(dateFormat),
            isValidDate = date.match(regex);
        if (isValidDate) {
            var today = new Date(),
                requestedDate = convertStringToDate(date);
            return today < requestedDate;
        }
        return false;
    }

    function getRegexForFormatDate(dateFormat) {
        switch (dateFormat) {
            //date format: yyyy/mm/dd
            case 'yyyy/mm/dd':
                return /^(?:\d{4}\/(?:(?:(?:(?:0[13578]|1[02])\/(?:0[1-9]|[1-2][0-9]|3[01]))|(?:(?:0[469]|11)\/(?:0[1-9]|[1-2][0-9]|30))|(?:02\/(?:0[1-9]|1[0-9]|2[0-8]))))|(?:(?:\d{2}(?:0[48]|[2468][048]|[13579][26]))|(?:(?:[02468][048])|[13579][26])00)\/02\/29)$/;
            //date format: dd/mm/yyyy
            case 'dd/mm/yyyy':
                return /^(?:(?:(?:0[1-9]|1\d|2[0-8])\/(?:0[1-9]|1[0-2])|(?:29|30)\/(?:0[13-9]|1[0-2])|31\/(?:0[13578]|1[02]))\/[1-9]\d{3}|29\/02\/(?:[1-9]\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00))$/;
            //date format: mm/dd/yyyy
            default:
                return /^(((0?[1-9]|1[012])\/(0?[1-9]|1\d|2[0-8])|(0?[13456789]|1[012])\/(29|30)|(0?[13578]|1[02])\/31)\/(19|[2-9]\d)\d{2}|0?2\/29\/((19|[2-9]\d)(0[48]|[2468][048]|[13579][26])|(([2468][048]|[3579][26])00)))$/;
        }
    }

    function removeReadonly(e) {
        $(e.target).removeAttr('readonly');
    }

    function setCookie(name, value, days) {
        var d = new Date;
        d.setTime(d.getTime() + 24 * 60 * 60 * 1000 * days);
        document.cookie = name + "=" + value + ";path=/;expires=" + d.toGMTString();
    }

    function getCookie(name) {
        var v = document.cookie.match('(^|;) ?' + name + '=([^;]*)(;|$)');
        return v ? v[2] : null;
    }

    function addMethods(obj, methods) {
        return function (methodName) {
            obj[methodName] = function (reqData, callback) {
                this.invokeCtx(methods ? methods[methodName] : methodName,
                    reqData,
                    function (resp, evt) {
                        if (callback) {
                            callback(resp, evt);
                        }
                    },
                    {
                        buffer: false, //this call will be executed by itself
                        nmsp: false //defines that this is a call to a subscriber class
                    }
                );//end invokeCtx call
            }
        }
    }

    function initializeVisualforceRemoting(jsLibrary, apexClassName, jsLibraryMethods) {
        CCRZ.subsc = _.extend(CCRZ.subsc || {});
        var obj = {};
        obj.className = apexClassName;
        if (Array.isArray(jsLibraryMethods)) {
            jsLibraryMethods.forEach(addMethods(obj));
        } else {
            Object.keys(jsLibraryMethods).forEach(addMethods(obj, jsLibraryMethods))
        }
        CCRZ.subsc[jsLibrary] = _.extend(CCRZ.RemoteInvocation, obj);
    }

    function showLoader() {
        var loadingParent = $(".main-loader");
        if (loadingParent) {
            var loaderClassName = loadingParent.attr("class");
            if (loaderClassName && loaderClassName.indexOf("loading") < 0) {
                loadingParent.addClass("loading");
            }
        }
    };

    function hideLoader() {
        var loadingParent = $(".main-loader");
        if (loadingParent) {
            var loaderClassName = loadingParent.attr("class");
            if (loaderClassName && loaderClassName.indexOf("loading") >= 0) {
                loadingParent.removeClass("loading");
            }
        }
    };
});