
d("aggregateView",['util','ccrz', 'pdpModel'], function(util,productDetail, productDetailModel) {
    return {

        extend: function() {
            CCRZ.pubSub.once("view:aggregateView:refresh", function(aggregateView){
                aggregateView.storeTemplate = CCRZ.util.template('cc_cust_agg_store');
                aggregateView.switchProduct = function(event) {
                    util.showLoader();
                    var $selectedOption = $("select.aggSelection option:selected");
                    if($selectedOption.length) {
                        var id = $selectedOption.val();
                        var sku = $selectedOption.data('sku');
                        var self = this;
                        CCRZ.storeView.model.set('productSKU', sku.toString());
                        CCRZ.storeView.fetchStoresBySku(false, false, false, function(){
                            self.renderSelectedProduct(id);
                        });
                    }
                };
                aggregateView.renderSelectedProduct = function(selId) {
                    var selAgg = this.dataSet.get(selId);
                    selAgg.attributes.showPickupSubscription = CCRZ.productDetailModel.get('showPickupSubscription');
                    selAgg.attributes.selectedShipType = CCRZ.productDetailModel.get('selectedShipType') || 'home';
                    if(CCRZ.storeView.model.get('selectedStoreList').length) {
                        selAgg.attributes.selectedStore =  CCRZ.storeView.model.get('selectedStoreList')[0];
                    }
                    selAgg.attributes.quantity = CCRZ.productDetailModel.get('quantity');

                    // update selected ship type based on available options
                    if (selAgg.attributes.product.prodBean.LPMBBIsInStoreOnly) {
                        CCRZ.productDetailModel.set('selectedShipType', 'store');
                        selAgg.attributes.selectedShipType = 'store';
                    }
                    if(!selAgg.attributes.product.prodBean.LPMBBAvailableForInStorePickup) {
                        CCRZ.productDetailModel.set('selectedShipType', 'home');
                        selAgg.attributes.selectedShipType = 'home';
                    }

                    if(selAgg.attributes.product.prodBean.SKU){
                        $(".wishFinder").attr("data-sku", selAgg.attributes.product.prodBean.SKU);
                    }

                    if(selAgg.attributes.product.prodBean.shortDesc){
                        $(".shortDesc").html("<br/>"+selAgg.attributes.product.prodBean.shortDesc);
                    }else{
                        $(".shortDesc").html("<br/>");
                    }
                    if (CCRZ.display.isPhone()) {
                        $(".phone_center_column .pd_content").html(this.aggTemplatePhone(selAgg.toJSON()));
                        if (selAgg.attributes.product.canAddtoCart) {
                        $(".phone_center_column .btn.btn-primary.addItem").attr("data-sku", selAgg.attributes.product.prodBean.sku);
                        $(".phone_center_column .addSection").show();
                        }
                        else
                        $(".phone_center_column .addSection").hide();
                    }
                    else {
                        $(".prodDetailContainer .pd_content").html(this.aggTemplateDesktop(selAgg.toJSON()));
                        $(".prodDetailContainer .prt_content").html(this.aggTPTemplate(selAgg.toJSON()));
                        $(".prodDetailContainer .dynamite-container").html(this.storeTemplate(selAgg.toJSON()));
                        if (CCRZ.disableAdaptive) {
                            $(".prodDetailContainer .cc_product_detail_photo_container").html(this.mainImageContentDesktop(selAgg.toJSON()));
                            if($('.carousel-multi:not(.slick-initialized)').length) {
                                setTimeout(function(){
                                    $('.carousel-multi:not(.slick-initialized)').slick({
                                        slidesToShow: 3,
                                        slidesToScroll: 3,
                                        infinite: false,
                                        touchMove: false,
                                        swipe: false,
                                        swipeToSlide: false,
                                        draggable: false,
                                        prevArrow: '<button type="button" class="slick-prev">Previous <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span></button>',
                                        nextArrow: '<button type="button" class="slick-next">Next<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span></button>'
                                      });
                                }, 3000);
                            }
                        }

                        if (selAgg.attributes.product.canAddtoCart) {
                            if (CCRZ.disableAdaptive) {
                                $(".prodDetailContainer .btn.btn-default.addItem").attr("data-sku", selAgg.attributes.product.prodBean.sku);
                                // .hide is deprecated in b3 and show() has no effect because of !important on .hidden. they suggest using add/remove
                                $(".prodDetailContainer .addSection").removeClass('hidden')
                                util.hidePickupSTS(selAgg.attributes.product.prodBean.LPMBBAvailableForInStorePickup,
                                    selAgg.attributes.showPickupSubscription,
                                    selAgg.attributes.selectedStore,
                                    selAgg.attributes.product.prodBean.LPMSTSEnabled,
                                    selAgg.attributes.selectedStore && (selAgg.attributes.selectedStore.Quantity >= selAgg.attributes.quantity),
                                    selAgg.attributes.product.prodBean.LPMBBIsInStoreOnly,
                                    false)
                                    ? $(".prodDetailContainer .product_detail_actions").hide()
                                    : $(".prodDetailContainer .product_detail_actions").show();
                            } else {
                                $(".prodDetailContainer .btn.btn-primary.addItem").attr("data-sku", selAgg.attributes.product.prodBean.sku);
                                $(".prodDetailContainer .addSection").show();
                            }
                        }
                        else {
                            if (CCRZ.disableAdaptive) {
                                // .hide is deprecated in b3 and show() has no effect because of !important on .hidden. they suggest using add/remove
                                $(".prodDetailContainer .addSection").addClass('hidden');
                            } else {
                                $(".prodDetailContainer .addSection").hide();
                            }
                        }

                    }
                    CCRZ.productDetailModel.set(selAgg.toJSON());
                    this.updateTiersSelection(selId);
                    CCRZ.views.wishlistPickerModal.prototype.init();
                };
            });
        },
    }
});