d("productDetailView", ['util', 'ccrz', 'pdpModel'], function (util, productDetail, productDetailModel) {
    return {

        extendProductDetailView: function (productDetailView) {
            // method to extend call at end
            $.fn.focusTextToEnd = function () {
                this.focus();
                var $thisVal = this.val();
                this.val('').val($thisVal);
                return this;
            }
            // Start
            let pdpModel = new productDetailModel();
            CCRZ.prodDetailView.delegateEvents(
                _.extend(CCRZ.prodDetailView.events, {
                    // "blur .entry": this.updateTiers,
                    "click #btn_findInstore": this.findInStoreAddress,
                    "click .checkNearByStores": this.openNearByStores,
                    "input #qty": this.handleQuantity,
                    "change .subscriptionInputOption": this.handleSubscription
                })
            );
            CCRZ.pubSub.on("view:productDetailView:refresh", function (prodView) {
                if ($('.carousel-multi:not(.slick-initialized)').length) {
                    setTimeout(function () {
                        $('.carousel-multi:not(.slick-initialized)').slick({
                            slidesToShow: 3,
                            slidesToScroll: 3,
                            infinite: false,
                            touchMove: false,
                            swipe: false,
                            swipeToSlide: false,
                            draggable: false,
                            prevArrow: '<button type="button" class="slick-prev">Previous <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span></button>',
                            nextArrow: '<button type="button" class="slick-next">Next<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span></button>'
                        });
                    }, 3000);
                }
            });
            CCRZ.pubSub.once("view:productDetailView:refresh", function (prodView) {
                CCRZ.productDetailModel.set('selectedShipType', prodView.model.attributes.product.prodBean.LPMBBIsInStoreOnly ? 'store' : 'home');
                //Default the checked to no subscription
                //CCRZ.productDetailModel.set('showPickupSubscription', CCRZ.productDetailModel.get('showNewSubscriptionSelection')?false:true);
                if (prodView.model.get('showNewSubscriptionSelection')) {
                    if (prodView.model.attributes.subProdTerms && prodView.model.attributes.subProdTerms.length > 0) {
                        prodView.model.attributes.subProdTerms.forEach(function (spt) {
                            if (!_.isUndefined(spt.CC_NO_SUBSCRIPTION)) {
                                spt['checked'] = 'checked';
                            } else {
                                spt['checked'] = '';
                            }
                        });
                    }
                }
                prodView.events['change input[type=radio][name=pickupSelect]'] = 'handlePickupSelection';
                prodView.events['click .addItem'] = 'handleAddItem';
                prodView.events['keypress .entryCustom'] = 'handleQtyKeyPress';

                prodView.events['click .pdpUpdateDeliveryZip'] = "toggleUpdateZip";
                prodView.events['click .pdpCancelDeliveryZip'] = "toggleUpdateZip";
                prodView.events['keydown .pdpUpdateZip'] = "handlePDPDeliveryZipKeyDown";
                prodView.events['click .btn_PDPUpdateDeliveryZip'] = "handlePDPUpdateZip";


                prodView.handlePickupSelection = function (event) {
                    event.preventDefault();
                    let value = event.target.value;
                    CCRZ.productDetailModel.set('selectedShipType', value);
                    if ($('.aggregate-product-type').length) {
                        var currentProductId = $("select.aggSelection option:selected").val();
                        if (currentProductId) {
                            CCRZ.aggregateView.renderSelectedProduct(currentProductId);
                        }
                    } else {
                        prodView.render();
                    }
                };
                prodView.postRender = function () {
                    this.renderSections();
                    if (this.pickerView) {
                        if (this.pickerView.coll.length !== 0) {
                            this.pickerView.render();
                        }
                    }
                    if (this.model.attributes.product) {
                        CCRZ.pubSub.trigger('prodDetailRefresh', this.model.attributes.product.prodBean);
                    } else {
                        CCRZ.pubSub.trigger('prodDetailRefresh', false);
                    }
                    $('#qty').focusTextToEnd();
                    $('.cc_breadcrumb_item').last().hide();
                    if (this.model.get('isError')) {
                        this.model.set('isError', false);
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", this.model.get('errorMessageLabel')));
                    }
                },
                    prodView.validateBackOrder = function (qty, prodData) {
                        let isValid = true;
                        if (prodData.LPMBBBackOrderEligible && qty > prodData.LPMBBBackOrderAllocation) {
                            isValid = false;
                        } else {
                            isValid = true;
                        }
                        return isValid;
                    },
                    prodView.handleAddItem = function (event) {
                        let btnClick = $(event.currentTarget);
                        let qtyValue;
                        if (btnClick.hasClass('subAddItemBtn')) {
                            qtyValue = $('.cc_product_detail').find('.cc_quantity_block input').val();
                        } else {
                            qtyValue = btnClick.closest('.product_detail_item').find('.cc_quantity_block input').val();
                        }
                        let _this = this, data = _this.model.attributes, sku = event.target.dataset.sku,
                            subTermId = _this.model.get('subTermId')
                            , quantity = qtyValue, price = 0, isCart = true;
                        quantity = Number(CCRZ.util.scrubQuantity(quantity));

                        //if backorder and ship to address or store pick and quantity <= store quantity
                        if (prodView.validateBackOrder(quantity, data.product.prodBean) || ((data.selectedShipType == 'store') && quantity <= data.selectedStore.Quantity)) {

                            if (!data.product.prodBean.LPMSTSEnabled && data.selectedShipType == 'store' && data.selectedStore.Quantity < quantity) {
                                let errorLabelAPI = '';
                                CCRZ.prodDetailView.model.set('isError', true);
                                if (data.product.prodBean.LPMBBIsInStoreOnly) {
                                    if (data.selectedStore.Quantity == 0) {
                                        errorLabelAPI = CCRZ.processPageLabelMap('LPM_PDP_laterInstoreOnlyNoQuantity');
                                    } else {
                                        errorLabelAPI = CCRZ.processPageLabelMap('LPM_PDP_laterInstoreOnly', [data.selectedStore.Quantity]);
                                    }

                                } else {
                                    if (data.selectedStore.Quantity == 0) {
                                        errorLabelAPI = CCRZ.processPageLabelMap('LPM_PDP_laterNotInstoreOnlyNoQuantity');
                                    } else {
                                        errorLabelAPI = CCRZ.processPageLabelMap('LPM_PDP_laterNotInstoreOnly', [data.selectedStore.Quantity]);
                                    }
                                }
                                CCRZ.prodDetailView.model.set('errorMessageLabel', errorLabelAPI);
                                if ($('.aggregate-product-type').length) {
                                    var currentProductId = $("select.aggSelection option:selected").val();
                                    if (currentProductId) {
                                        CCRZ.aggregateView.renderSelectedProduct(currentProductId);
                                    }
                                } else {
                                    _this.render();
                                }
                            } else {
                                util.showLoader();
                                if (_this.model.get('showNewSubscriptionSelection')) {
                                    if (_this.model.attributes.subProdTerms && _this.model.attributes.subProdTerms.length > 0) {
                                        _this.model.attributes.subProdTerms.forEach(function (spt) {
                                            if (subTermId == 'nosuboption' && !_.isUndefined(spt.CC_NO_SUBSCRIPTION)) {
                                                subTermId = '';
                                                price = spt.productPrice;
                                            } else if (subTermId == spt.sfid) {
                                                price = spt.productPrice;
                                            }
                                        });
                                    } else {
                                        isCart = false
                                    }
                                } else {
                                    price = _this.model.attributes.product.price;
                                }
                                if (quantity != '' && quantity > 0 && isCart) {
                                    let promiseDateStore = '';
                                    let promiseDateHome = '';
                                    let promiseDateDataStore = CCRZ.productDetailModel.get('promiseDateStoreData');
                                    if(promiseDateDataStore != undefined) {
                                        promiseDateStore = promiseDateDataStore.promiseDate;
                                    }
                                    let promiseDateDataHome = CCRZ.productDetailModel.get('promiseDateHomeData');
                                    if(promiseDateDataHome != undefined) {
                                        promiseDateHome = promiseDateDataHome.promiseDate;
                                    }

                                    let productData = {
                                        "sku": sku,
                                        "quantity": quantity + '',
                                        "subTermId": subTermId,
                                        "parentSFID": null,
                                        "isMain": true,
                                        "headerStoreName": data.selectedStore.name,
                                        "headerStoreZip": data.selectedStore.postal_code.split('-')[0],
                                        "shipType": data.selectedShipType,
                                        "storeName": (data.selectedShipType == 'store') ? data.selectedStore.name : 'Home',
                                        "address1": (data.selectedShipType == 'store') ? data.selectedStore.address1 : '',
                                        "city": (data.selectedShipType == 'store') ? data.selectedStore.city : '',
                                        "stateCode": (data.selectedShipType == 'store') ? data.selectedStore.state_code : '',
                                        "countryCode": (data.selectedShipType == 'store') ? data.selectedStore.country_code : '',
                                        "postalCode": (data.selectedShipType == 'store') ? data.selectedStore.postal_code : '',
                                        "phone": (data.selectedShipType == 'store') ? data.selectedStore.phone : '',
                                        "storeId": (data.selectedShipType == 'store') ? data.selectedStore.id : '',
                                        "storeHours": (data.selectedStore != undefined) ? data.selectedStore.store_hours: '',
                                        "storeTimezone": (data.selectedStore != undefined) ? data.selectedStore.c_storeTimezone: '',
                                        "isStoreQuantity": (data.selectedStore != undefined && data.selectedStore.Quantity >= quantity) ? true : false,
                                        "isPickUpLater": (data.selectedStore != undefined && data.selectedStore.Quantity < quantity) ? true : false,
                                        "price": price + '',
                                        "subTotal": (price * quantity) + '',
                                        "isGetPrice": false,
                                        "promiseDateDataStore": promiseDateDataStore,
                                        "promiseDateStore": promiseDateStore,
                                        "promiseDateDataHome": promiseDateDataHome,
                                        "promiseDateHome":promiseDateHome,
                                        "selectedStore":JSON.stringify(data.selectedStore),
                                        "isFromWebStore":true
                                    }, reqData = {
                                        'cartEncId': CCRZ.pagevars.currentCartID,
                                        'products': [productData]
                                    }
                                    pdpModel.addToCart(JSON.stringify(reqData), function (res, event) {
                                        if (res && res.success && res.data && res.data.cartEncId) {
                                            if (data.selectedShipType == 'store' && data.selectedStore.Quantity != 0) {
                                                pdpModel.reserveCartInventory(JSON.stringify({'cartEncId': res.data.cartEncId}), function (response, evt) {
                                                    if (response && response.success) {
                                                        if (res.data.cartEncId) {
                                                            try {
                                                                CCRZ.pagevars.currentCartID = res.data.cartEncId;
                                                                CCRZ.pagevars.queryParams['cartId'] = res.data.cartEncId;
                                                                CCRZ.pubSub.trigger('cartChange', res.data.cartEncId);
                                                            } catch (err) {
                                                            }
                                                        }
                                                        let inputData = {
                                                            'type': 'pdp',
                                                            'viewType': 'new',
                                                            'zipCode': CCRZ.storeView.parseZip(_this.model.attributes.selectedStore.postal_code),
                                                            'pdpStoreName': _this.model.attributes.selectedStore.name,
                                                            'sku': _this.model.attributes.product.prodBean.SKU,
                                                            'openModal': false,
                                                            'quantity': _this.model.attributes.quantity
                                                        }
                                                        CCRZ.prodDetailView.model.set('quantity', 1);
                                                        let errorLabelAPI = '';
                                                        if (response.data && response.data.length > 0) {
                                                            CCRZ.prodDetailView.model.set('isError', true);
                                                            if (response.data.length == 1) {
                                                                CCRZ.prodDetailView.model.set('reserveQuantity', response.data[0].reservedQuantity);
                                                                if (response.data[0].isPartial) {
                                                                    errorLabelAPI = CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_PartialReservation_PDP', [response.data[0].reservedQuantity, response.data[0].reservedQuantity]);
                                                                } else if (response.data[0].isNoQuantity) {
                                                                    errorLabelAPI = CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_InventoryNoLongerAvailable_PDP', []);
                                                                }
                                                            }
                                                        } else {
                                                            if (data.selectedStore.Quantity == quantity) {
                                                                CCRZ.prodDetailView.model.set('isError', true);
                                                                errorLabelAPI = CCRZ.processPageLabelMap('LPM_BB_ErrorMessage_LastProductAddedToCart_PDP', []);
                                                            }
                                                        }
                                                        CCRZ.prodDetailView.model.set('errorMessageLabel', errorLabelAPI);
                                                        $('#qty').val('1');
                                                        CCRZ.storeView.model.set('isSelectedStore', false);
                                                        CCRZ.storeView.model.set('currentProdQuantity', 1);
                                                        CCRZ.pubSub.trigger('fetchStoreByZip', inputData);
                                                    } else {
                                                        // Error Handling
                                                    }
                                                });
                                            } else {
                                                if (res.data.cartEncId) {
                                                    try {
                                                        CCRZ.pagevars.currentCartID = res.data.cartEncId;
                                                        CCRZ.pagevars.queryParams['cartId'] = res.data.cartEncId;
                                                        CCRZ.pubSub.trigger('cartChange', res.data.cartEncId);
                                                    } catch (err) {
                                                    }
                                                }
                                                if (CCRZ.pagevars.currentCartID && CCRZ.pagevars.currentCartID.trim().length > 0) {
                                                    setTimeout(function () {
                                                        if ($('.aggregate-product-type').length) {
                                                            var currentProductId = $("select.aggSelection option:selected").val();
                                                            if (currentProductId) {
                                                                CCRZ.aggregateView.renderSelectedProduct(currentProductId);
                                                            }
                                                        } else {
                                                            _this.render();
                                                        }
                                                        util.hideLoader();
                                                    }, 2000);
                                                }
                                            }
                                            let toastMsg = CCRZ.pagevars.pageLabels.Toast_Product_Added_Success;
                                            CCRZ.pubSub.trigger("showToastMsg", 'SUCCESS', toastMsg);
                                        } else {
                                            // Error handling
                                            // CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'Error Adding Product to the cart!'));
                                            let errorToastMsg = CCRZ.pagevars.pageLabels.Toast_Product_Added_Fail;
                                            CCRZ.pubSub.trigger("showToastMsg", 'ERROR', errorToastMsg);
                                            util.hideLoader();
                                        }
                                    });
                                } else {
                                    // CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'Invalid_Qty'));
                                    let errorMsg = CCRZ.pagevars.pageLabels.Invalid_Qty;
                                    CCRZ.pubSub.trigger("showToastMsg", 'ERROR', errorMsg);
                                    util.hideLoader();
                                }
                            }
                        } else {
                            let allocationAmount = data.product.prodBean.LPMBBBackOrderAllocation;
                            let backOrderMsg = 'Only ' + allocationAmount + ' available for Back Order at this time.';
                            //CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", backOrderMsg));
                            CCRZ.pubSub.trigger("showToastMsg", 'ERROR', backOrderMsg);
                            util.hideLoader();
                        }
                    },
                    prodView.handleQtyKeyPress = function (event) {
                        var v = this;
                        if (window.event && window.event.keyCode == 13 || event.which == 13) {
                            var addItemButton = $(event.currentTarget).closest('.product_detail_item').find('button.addItem');

                            if (addItemButton) {
                                addItemButton.click();
                            }
                            return false;
                        } else {
                            return CCRZ.util.isValidNumericInput(event);
                        }
                    },
                    prodView.toggleUpdateZip = function() {
                        $('.pdpUpdateDeliveryZip').toggleClass('hide');
                        $('.pdpCancelDeliveryZip').toggleClass('hide');
                        $('.updateZipBody').toggleClass('hide');
                    },
                    prodView.handlePDPDeliveryZipKeyDown = function(){
                        let _this = this;
                        if (event.keyCode === 13) {
                            _this.handlePDPUpdateZip();
                        }
                    },
                    prodView.handlePDPUpdateZip = function() {
                        var newZip = $('#pdpUpdateDeliveryZip').val();
                        let isnum = /^\d+$/.test(newZip);
                        if(newZip.length == 5 && isnum) {
                            util.showLoader();
                            var controller = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_HeaderController'});
                            controller.invokeCtx('updateDeliveryZip', newZip, function (resp) {
                                let tempModel = CCRZ.storeView.model;
                                if (resp.success) {
                                    let newZipData = resp.data;
                                    tempModel.set('isDeliveryZipError', false);
                                    tempModel.set('selectedDeliveryZip', newZipData);
                                    CCRZ.storeView.render();

                                    let inputData = {
                                        'zipCode': newZipData,
                                        'itemID': CCRZ.productDetailModel.attributes.product.prodBean.SKU,
                                        'quantity': 1,
                                        'isHome': true
                                    }
                                    CCRZ.pubSub.trigger('fetchPromiseDate', inputData);
                                } else {
                                    console.log("error: " + resp.data);
                                    tempModel.set('isDeliveryZipError', true);
                                    CCRZ.storeView.render();
                                    util.hideLoader();
                                }
                            }, {
                                buffer: false,
                                escape: false,
                                nmsp: false
                            });
                        } else {
                            var errorMsg = 'Please add a valid zip code';
                            $(event.currentTarget).find('#pdpZipErrorMsg').text(errorMsg);
                            util.hideLoader();
                        }
                    },

                    prodView.listenTo(CCRZ.pubSub, 'fetchPromiseDate', function (_inputData) {
                        var controller = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_HeaderController'});
                        let jsonString = JSON.stringify(_inputData);
                        controller.invokeCtx('getPromiseDate', jsonString, function (resp) {
                            if (resp && resp.success && resp.data) {
                                let respData = resp.data;
                                if(respData.isHome) {
                                    // CCRZ.productDetailModel.set('promiseDateHome', respData.promiseDate);
                                    CCRZ.productDetailModel.set('selectedDeliveryZip', respData.promiseZipcode);
                                    CCRZ.productDetailModel.set('promiseDateHomeData', respData);
                                } else {
                                    CCRZ.productDetailModel.set('promiseDateStore', respData.promiseDate);
                                    CCRZ.productDetailModel.set('promiseDateStoreData', respData);
                                }
                                CCRZ.prodDetailView.render();
                            } else {
                                console.log("error occured while retrieving promise date");
                                if(resp.data) {
                                    let respData = resp.data;
                                    if(respData.isHome) {
                                        CCRZ.productDetailModel.set('selectedDeliveryZip', respData.newZip);
                                    }
                                }

                                CCRZ.prodDetailView.render();
                            }
                            util.hideLoader();
                        }, {
                            buffer: false,
                            escape: false,
                            nmsp: false
                        });
                    });

                prodView.delegateEvents();

                let inputDataHome = {
                    'zipCode': null,
                    'itemID': CCRZ.productDetailModel.attributes.product.prodBean.SKU,
                    'quantity': 1,
                    'isHome': true
                }
                CCRZ.pubSub.trigger('fetchPromiseDate', inputDataHome);
                prodView.render();
            });
        },
        handleSubscription: function (event) {
            event.preventDefault();
            CCRZ.storeView.handleSubscription();
        },
        handleQuantity: function (event) {
            event.preventDefault();
            CCRZ.storeView.model.set('isPDP', true);
            if ($('.aggregate-product-type').length) {
                CCRZ.storeView.model.set('aggregateProductType', true);
            }
            if (event.target.value !== '') {
                let quantity = Number(CCRZ.util.scrubQuantity(event.target.value));
                this.model.set('quantity', quantity);
                $('#qty').val(quantity);
                CCRZ.storeView.handleQuantity();
            }
        },
        openNearByStores: function (event) {
            event.preventDefault();

            let _this = this;
            let zipCodeVal = '';
            let storeNameVal = '';
            if (_this.model.attributes.selectedStore != undefined) {
                zipCodeVal = CCRZ.storeView.parseZip(_this.model.attributes.selectedStore.postal_code);
                storeNameVal = _this.model.attributes.selectedStore.name;
            } else {
                zipCodeVal = _this.model.attributes.selectedDeliveryZip;
            }
            let inputData = {
                'type': 'pdp',
                'viewType': event.target.dataset.type,
                'zipCode': (event.target.dataset.type == 'new') ? '' : zipCodeVal,
                'pdpStoreName': storeNameVal,
                'sku': _this.model.attributes.product.prodBean.SKU,
                'quantity': _this.model.attributes.quantity,
                'backOrderElgible': _this.model.attributes.product.prodBean.LPMBBBackOrderEligible,
                'backOrderinStockDate': _this.model.attributes.product.prodBean.LPMBBInStockDate,
                'openModal': true,
                'isAggregatePDP': !!$('.aggregate-product-type').length
            }
            CCRZ.storeView.model.set('isSelectedStore', true);
            CCRZ.storeView.model.set('currentProdQuantity', _this.model.get('quantity'));
            CCRZ.pubSub.trigger('fetchStoreByZip', inputData);
            $('html, body').animate({scrollTop: '0px'}, 300);
        },
        findInStoreAddress: function () {
            document.getElementsByClassName('showAdd')[0].innerHTML = '';
            $(".error").remove();
            var find_store_zipCode = $.trim($('#find_store_zipCode').val());
            var radius_id = $.trim($('#radius_id').val());
            var findInStore_SKU = CCRZ.productDetailModel.attributes.product.prodBean.sku;
            let data = {zip: find_store_zipCode, radius: radius_id, sku: findInStore_SKU};
            var isError = false;
            if (find_store_zipCode.length < 1) {
                $('#find_store_zipCode').after('<span class="error" id="find_store_zipCode_zip_error">This field is required</span>');
                isError = true;
            } else {
                $(".error").remove();
                var remoteCall = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_PDPController'});
                remoteCall.invokeCtx(
                    'getAvailability', JSON.stringify(data),
                    function (response, event) {
                        if (event.status) {
                            let responseData = JSON.parse(response);
                            if (responseData == null) {
                                $('#find_store_zipCode').after('<span class="error" id="showAdd_error">Store not available for this zip/Postal Code</span>');
                            } else {
                                var addList = responseData['stores'];
                                if (addList != null && addList.length > 0) {
                                    var handleBarTemplate = CCRZ.util.template('cc_cust_findInStore-template');
                                    var stores = {stores: responseData['stores']};
                                    var storeHtml = handleBarTemplate(stores);
                                    $('.showAdd').html(storeHtml);
                                }
                            }
                        }
                    }, {buffer: false, escape: false, nmsp: false}
                );
            }
        },

    }
});