d("LLIPaymentProcessorView", ['util'], function (UTIL, LLIPaymentProcessorView) {

    return {
        extendLLIPaymentProcessorView: function () {

            CCRZ.pubSub.once('view:LLIPaymentProcessorView:refresh', function (LLIPaymentProcessorView) {
                UTIL.hideLoader();
                console.log('override view LLIPaymentProcessorView');
                // LLIPaymentProcessorView.events['click .cc_nav-tabs_anchor.po'] = 'checkCreditLimitLoaded';

                LLIPaymentProcessorView.useStoredPayment = function (event) {
                    if (!$("#storePaymentBtn").is(":disabled")) {
                        if (this.model.get("storedSelected")) {
                            $("#storePaymentBtn").attr("disabled", true);
                            var storedPayment = this.model.get("storedSelected");
                            _.each(this.model.get('storedPayments'), function (sp) {
                                if (sp.sfid == storedPayment) {
                                    storedPayment = sp;
                                }
                            });

                            UTIL.showLoader();

                            var cartData = CCRZ.LLIPaymentModel.get('cartData');
                            if (_.isUndefined(cartData.billTo) || _.isUndefined(cartData.billTo.addressFirstline)) {
                                $("#storePaymentBtn").attr("disabled", false);
                                UTIL.hideLoader();
                                CCRZ.pubSub.trigger('pageMessage', CCRZ.createPageMessage('ERROR', 'messagingSection-Error', 'LLICheckOut_MissingBillAddr'));
                            } else {
                                CCRZ.pubSub.trigger("action:processPayment", {
                                    "storedPaymentId": storedPayment.sfid,
                                    "accountNumber": storedPayment.accountNumber,
                                    "accountType": storedPayment.accountType
                                });
                                setTimeout(
                                    function () {
                                        UTIL.hideLoader();
                                    },
                                    2000
                                );
                            }
                            if (CCRZ.ga) {
                                CCRZ.ga.handleSubmitOrder({'cartId': CCRZ.pagevars.currentCartID});
                            }
                        } else {
                            UTIL.hideLoader();
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "storedpayment-messagingSection-Error", 'PaymentProcessor_InvalidPaymentId'));
                        }
                    }
                }

                // LLIPaymentProcessorView.checkCreditLimitLoaded = function(event) {
                //     let creditLabelText = $('#credit_limit').text();
                //     if(creditLabelText != '') {
                //         $('.makePOPayment').attr('disabled',false);
                //         UTIL.hideLoader();
                //     } else {
                //         $('.makePOPayment').attr('disabled',true);
                //         UTIL.hideLoader();
                //     }
                // }

                LLIPaymentProcessorView.delegateEvents();
                LLIPaymentProcessorView.render();
            });

            CCRZ.pubSub.on('view:LLIPaymentProcessorView:refresh', function (LLIPaymentProcessorView) {
                UTIL.hideLoader();
            });
        },


    }
});



