d("LLIPaymentView", ['util'], function (UTIL, LLIPaymentView) {

    return {
        extendLLIPaymentView: function () {

            CCRZ.pubSub.once('view:LLIPaymentView:refresh', function (LLIPaymentView) {
                UTIL.hideLoader();
                console.log('override view LLIPaymentView');
                LLIPaymentView.events['click .saveBillAddr'] = 'handleSaveAddr';
                LLIPaymentView.events['click #copyContactName'] = 'handleCopyContactName';

                LLIPaymentView.initValidation = function () {
                    $.validator.addMethod( "regex", function(value, element, regexp) {
                        return this.optional(element) || regexp.test(value);
                    },
                    "Please check your input."
                    );
                    $('#billAddrEdit').validate({
                        invalidHandler: function (event1, validator1) {
                            CCRZ.handleValidationErrors(event1, validator1, 'billModal-messagingSection-Error', false);
                        },
                        rules: {
                            "billTo.firstName":{
                                minlength: 3,
                                regex: /^-?[a-zA-Z]{3,}[a-zA-Z0-9\s]*$/,
                                required: true
                            },
                            "billTo.lastName":{
                                minlength: 3,
                                regex: /^-?[a-zA-Z]{3,}[a-zA-Z0-9\s]*$/,
                                required: true
                            },
                            "billTo.addressFirstline": {
                                minlength: 3,
                                regex: /^-?[a-zA-Z0-9]{1,}[a-zA-Z0-9\s]*$/,
                                required: true
                            },
                            "billTo.city": {
                                minlength: 3,
                                regex: /^-?[a-zA-Z]{3,}[a-zA-Z\s]*$/,
                                required: true
                            },
                            "billTo.postalCode": {
                                minlength: 5,
                                maxlength: 10,
                                regex: /^(\d{5}|\d{5}-\d{4})$/,
                                required: true
                            },
                            "billTo.Email": {
                                regex: /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,})+$/,
                                required: true
                            },
                            "billTo.daytimePhone": {
                                minlength: 10,
                                maxlength: 10,
                                regex: /^([1-9]\d{9})$/,
                                required: true
                            },
                             "billTo.stateCode": {
                            required: true,
                        }
                        },
                        messages: {
                            "billTo.firstName":{
                                regex: 'LPM_BB_First_Name_Regex',
                                required: 'LPM_BB_First_Name'
                            },
                            "billTo.lastName":{
                                regex: 'LPM_BB_Last_Name_Regex',
                                required: 'LPM_BB_Last_Name'
                            },
                            "billTo.addressFirstline": {
                                regex: "LPM_BB_Address_Line_Regex",
                                required: "LPM_BB_Address_Line"
                            },
                            "billTo.city": {
                                regex: "LPM_BB_City_Name_Regex",
                                required: "LPM_BB_City_Name"
                            },
                            "billTo.postalCode": {
                                regex: 'LPM_BB_Postal_Code_Regex',
                                required: 'LPM_BB_Postal_Code',
                                maxlength: 'POSTAL_CODE_LENGTH_ERROR'
                            },
                            "billTo.Email": {
                                regex: 'LPM_BB_Email_Address_Regex',
                                required: 'LPM_BB_Email_Address'
                            },
                            "billTo.daytimePhone": {
                                regex: 'LPM_BB_Phone_Number_Regex',
                                required: 'LPM_BB_Phone_Number'
                            },
                            "billTo.stateCode": {
                            required: "State is required"
                            }
                        },
                        errorPlacement: function (error, element) {
                        }
                    });
                },
                    LLIPaymentView.handleSaveAddr = function (event) {
                        let _this = this;

                        var objLink = $(event.target);
                        var id = objLink.data("id");
                        var v = this;
                        $('select.billingField').prop('disabled', false);
                        var formData = form2js('billAddrEdit', '.', false, function (node) {
                        }, false, true);
                        var cartData = CCRZ.LLIPaymentModel.get('cartData');
                        formData.cartId = cartData.sfid;
                        formData.billTo.country = 'United States';
                        formData.billTo.countryISOCode = 'US';
                        if (!_.isUndefined(formData.billTo.stateCode)) {
                            formData.billTo.stateISOCode = formData.billTo.stateCode;
                            formData.billTo.state = "";
                        } else {
                            formData.billTo.stateISOCode = "";
                        }
                        formData.billTo.homePhone = formData.billTo.daytimePhone; //DEV-10487 - To sync dayTimePhone with homePhone
                        var isValid = false;
                        isValid = $("#billAddrEdit").valid();
                        if (isValid) {
                            $("#editBillAddressMod").modal("hide");
                            var jsonData = JSON.stringify(formData);
                            const remoteController = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                            remoteController.invokeCtx('saveAddress', jsonData, function (response) {
                                    if (response && response.success && response.data.addressList) {
                                        v.model.attributes.cartData.billTo = response.data.addressList[0];
                                        var contactAdrrSFID = response.data.addressList[0].sfid;
                                        var addToBookBilling = $('#addToBillingBook').prop('checked');
                                        var addToBookShipping = $('#addToShippingBook').prop('checked');
                                        let addressTypes = [];
                                        if (!_.isUndefined(addToBookBilling) && addToBookBilling) {
                                            addressTypes.push('Billing');
                                        }
                                        if (!_.isUndefined(addToBookShipping) && addToBookShipping) {
                                            addressTypes.push('Shipping');
                                        }

                                        if (!_.isUndefined(contactAdrrSFID) && contactAdrrSFID && addressTypes.length > 0) {
                                            LLIPaymentView.addToBook(contactAdrrSFID, addressTypes);
                                        }
                                        v.render();
                                    }
                                },
                                {
                                    buffer: false,
                                    escape: false,
                                    nmsp: false
                                });
                        }
                    };
                LLIPaymentView.addToBook = function (contactAdrrSFID, addressTypes) {
                    const remoteCreateNewAddress = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                    remoteCreateNewAddress.invokeCtx('createNewAddress', contactAdrrSFID, addressTypes, function (resp) {
                        if (resp && resp.success) {
                            console.log('Creating New Address was successful');
                        } else {
                            console.log('Creating New Address failed');
                        }
                    }, {
                        buffer: false,
                        escape: false,
                        nmsp: false
                    });
                };
                LLIPaymentView.handleCopyContactName = function(event) {
                    let isChecked = $('#copyContactName').prop('checked');
                    let cartData = this.model.get('cartData');
                    let firstName = cartData.buyerFirstName;
                    let lastName = cartData.buyerLastName;
                    let contactPhone = cartData.buyerPhone;
                    let contactEmail = cartData.buyerEmail;
                    if(isChecked) {
                        if(firstName != '') {
                            $('#buyerFirstName').val(firstName);
                        }
                        if(lastName != '') {
                            $('#buyerLastName').val(lastName);
                        }
                        if(contactPhone != '') {
                            $('#buyerPhone').val(contactPhone);
                        }
                        if(contactEmail != '') {
                            $('#buyerEmail').val(contactEmail);
                        }
                    }
                };
                LLIPaymentView.delegateEvents();
                LLIPaymentView.render();
            });

            CCRZ.pubSub.on('view:LLIPaymentView:refresh', function (LLIPaymentView) {
                UTIL.hideLoader();
            });
        },


    }
});