d("LLIShippingView", ['util', 'checkoutModel'], function (UTIL, checkoutModel) {

    return {
        extendLLIShippingView: function () {
            Handlebars.registerPartial("cartItemsShipLLI", $(CCRZ.uiProperties.LLIShippingDetailView.partial.CartItemShippingLLI).html());
            CCRZ.pubSub.once('view:LLIShippingDetailView:refresh', function (shipView) {
                UTIL.hideLoader();
                shipView.events['click .processLLIShippingInfo'] = 'handleProceedToReview';
                shipView.events['change .storePickupOthers'] = 'handlePickbyOthers';
                shipView.events['blur .otherInfo'] = 'handleOtherInfo';
                shipView.events['click .addItemGroupBtn'] = 'handleOpenCreateGroupModal';
                shipView.events['click .saveAddr'] = 'handleSaveAddrModal';
                shipView.events['click .deleteGrp'] = 'handleDeleteGroup';
                shipView.events['click .executeMove'] = 'handleExecuteMove';
                shipView.events['click .executeBulkMove'] = 'handleExecuteMove';
                shipView.events['change .contactField'] = 'handleBuyerInfoChange';
                shipView.events['change #shippingAddress'] = 'setShippingAddress';
                shipView.events['change #pickupPerson'] = 'setPickupPerson';
                shipView.events['click #createStoreContact'] = 'updateCustomFields';
                shipView.events['click #assignManagerPerm'] = 'updateCustomFields';
                shipView.events['click #textMsgOptIn'] = 'updateCustomFields';
                shipView.events['blur #customerOrderName'] = 'updateCustomFields';
                shipView.events['click #copyContactName'] = 'handleCopyContactName';

                shipView.setPickupPerson = function (event) {
                    var personId = event.currentTarget.value;
                    var groupId = $(event.currentTarget).find("option:selected").data('id');
                    let pickupPersons = this.model.attributes.cartData.pickupPersons;
                    let person = _.findWhere(pickupPersons, {sfid: personId});
                    
                    $('#othersFirstName'+groupId).attr('value', person.firstName);
                    $('#othersLastName'+groupId).attr('value', person.lastName);
                    $('#othersEmail'+groupId).attr('value', person.email);
                    $('#othersPhone'+groupId).attr('value', person.phone);

                    var cartGroups = CCRZ.LLIShippingDetailModel.get('cartData').ECartItemGroupsS.models
                    let groupModel = _.findWhere(cartGroups, {id: groupId});
                    groupModel.attributes.otherEmail = person.email;
                    groupModel.attributes.otherFirstName = person.firstName;
                    groupModel.attributes.otherLastName = person.lastName;
                    groupModel.attributes.otherPhone = person.phone;

                },
                shipView.setShippingAddress = function (event) {
                    var addressId = event.currentTarget.value;
                    var groupId = $(event.currentTarget).find("option:selected").data('id');
                    var selectedStoreZip = CCRZ.storeView.model.attributes.selectedStoreZip;

                    if (addressId != null && addressId != '' && groupId != null && groupId != '') {
                        const remoteUpdateShippingAddress = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                        remoteUpdateShippingAddress.invokeCtx('setShippingAddress', addressId, groupId, selectedStoreZip, function (resp) {
                            if (resp && resp.success) {
                                //Set the newly updated shipping address on the Cart Item Groups in the model.
                                var addressData = resp.data.addressData;
                                var promiseDates = resp.data.promiseDates;
                                jQuery.each(CCRZ.LLIShippingDetailModel.get('cartData').ECartItemGroupsS.models, function (igKey, igData) {
                                    if (igData.attributes.sfid === groupId) {
                                        igData.attributes.shipTo = addressData;
                                        
                                        if(promiseDates!=undefined) {
                                            jQuery.each(igData.attributes.ECartItemsS, function(key, cartItem) {
                                                if(promiseDates[cartItem.sfid] != undefined) {
                                                    let promiseDate = promiseDates[cartItem.sfid];
                                                    cartItem.b2bPromiseDate = promiseDate;
                                                }
                                            });
                                        }
                                    }
                                });

                                CCRZ.LLIcartCheckoutView.render();
                                $('.modal-backdrop.in').remove();
                                console.log('Updating Shipping Group Addresses was successful');
                            } else {
                                console.log('Updating Shipping Group Addresses failed');
                            }
                        }, {
                            buffer: false,
                            escape: false,
                            nmsp: false
                        });

                    }
                };

                shipView.handleExecuteMove = function (event) {
                    let _this = this;
                    _this.validateNewGroup();
                    var isValid = false;
                    $('#moveItemForm').append('<input type="hidden" name="shipTo.country" value="United States">');
                    $('#moveItemForm').append('<input type="hidden" name="shipTo.countryISOCode" value="US">');
                    isValid = $("#moveItemForm").valid();
                    if(isValid) {
                        UTIL.showLoader();
                        var moveForm = form2js('moveItemForm', '.', false, function(node) {}, false, true);
                        //console.log('LOG: JSON.stringify(moveForm) => ' + JSON.stringify(moveForm));
                        console.log('LOG => countryISOCode = ' + moveForm.shipTo.countryISOCode + ' ; country = ' + moveForm.shipTo.country);
                        var moveIds = new Array();
                        if (moveForm.moveSingleItem != '' ) {
                            var moveSingleItem = JSON.parse(moveForm.moveSingleItem);
                            moveIds.push(moveSingleItem.sfid);
                            console.log('moveSingleItem (moveIds) => ' + moveIds);
                        }
                        if (moveForm.moveBulkIds != '' ) {
                            var bulkIds = JSON.parse(moveForm.moveBulkIds);
                            moveIds = bulkIds;
                            console.log('bulkIds ...... (moveIds) => ' + moveIds);
                        }

                        var groupId = moveForm.moveToGroup;
                        var zipCode;
                        if (groupId.toLowerCase() == 'newgroup') {
                            zipCode = moveForm.shipTo.postalCode;
                        }
                        var storeHeaderZip = CCRZ.storeView.model.attributes.selectedStoreZip;
                        /*
                            bulkids should always exist
                            groupId if it is not newGroup then we queryr for that cart group in the backend to get zip
                            if groupId is newGroup then use the zipcode no soql needed.
                        */
                        const remoteController = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                        remoteController.invokeCtx('updateCartPromiseDates', moveIds, groupId, zipCode, storeHeaderZip, function (resp) {
                            if (resp && resp.success) {
                                _this.executeMove(event);
                            } else {
                                _this.executeMove(event);
                            }
                        }, {
                            buffer: false,
                            escape: false,
                            nmsp: false
                        });
                    }
                };
                shipView.handleBuyerInfoChange = function (event) {
                    let _this = this, value = event.target.value, name = event.target.name
                        , cartData = _this.model.get('cartData');

                    if ($(event.target).is(':checkbox')) {
                        value = event.target.checked;
                    }

                    cartData[name] = value;
                    _this.model.set('cartData', cartData);

                };
                shipView.handleDeleteGroup = function (event) {
                    let _this = this;
                    UTIL.showLoader();
                    _this.deleteGroup(event);

                };

                shipView.handleSaveAddrModal = function (event) {
                    let _this = this;
                    // var v = this;
                    _this.initValidation();
                    var isValid = false;
                    isValid = $(".addressForm").valid();
                    $('select.shippingField').prop('disabled', false);

                    if (isValid) {
                        var formData = form2js('addrEdit', '.', false, function (node) {
                        }, false, true);
                        var cartData = CCRZ.LLIShippingDetailModel.get('cartData');
                        var groupId = formData.groupId;

                        if(groupId !=undefined && groupId!=''){
                            var matchingGroup = cartData.ECartItemGroupsS.findWhere({sfid: groupId});
                            var cartIds = matchingGroup.attributes.ECartItemsS.map(function(item){return item.sfid});
                            var zipCode = formData.shipTo.postalCode;
                            var storeHeaderZip = CCRZ.storeView.model.attributes.selectedStoreZip;
                            const remoteController = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                            remoteController.invokeCtx('updateCartPromiseDates', cartIds, groupId, zipCode, storeHeaderZip, function (resp) {
                                if (resp && resp.success) {
                                    var respData = resp.data;
                                    jQuery.each(CCRZ.LLIShippingDetailModel.get('cartData').ECartItemGroupsS.models, function (itemKey, itemData) {
                                        if (itemData.attributes.sfid === groupId) {
                                            if(respData.promiseDates != undefined) {
                                                var promiseDates = respData.promiseDates;
                                                jQuery.each(itemData.attributes.ECartItemsS, function(promisKey, cartItem) {
                                                    if(promiseDates[cartItem.sfid] != undefined) {
                                                        let promiseDate = promiseDates[cartItem.sfid];
                                                        cartItem.b2bPromiseDate = promiseDate;
                                                    }
                                                });
                                            }
                                        }
                                    });
                                    shipView.handleSaveAddr(event);
                                } else {
                                    shipView.handleSaveAddr(event);
                                }
                            }, {
                                buffer: false,
                                escape: false,
                                nmsp: false
                            });
                        }else{
                            shipView.handleSaveAddr(event);
                        }
                    }
                    //_this.saveAddr(event);
                };
                shipView.handleSaveAddr = function (event) {
                    let _this = this;
                    var objLink = $(event.target);
                    var id = objLink.data("id");
                    UTIL.showLoader();
                    var formData = form2js('addrEdit', '.', false, function (node) {
                    }, false, true);
                    var cartData = CCRZ.LLIShippingDetailModel.get('cartData');
                    formData.cartId = cartData.sfid;
                    formData.shipTo.country = 'United States';
                    formData.shipTo.countryISOCode = 'US';
                    if (!_.isUndefined(formData.shipTo.stateCode)) {
                        formData.shipTo.stateISOCode = formData.shipTo.stateCode;
                        formData.shipTo.state = "";
                    } else {
                        formData.shipTo.stateISOCode = "";
                    }
                    formData.shipTo.daytimePhone = formData.shipTo.homePhone; //DEV-10487 - To sync homePhone with dayTimePhone

                    $("#editAddressMod_" + id).modal("hide");
                    var jsonData = JSON.stringify(formData);
                    var matchingGroup = cartData.ECartItemGroupsS.findWhere({sfid: formData.groupId});
                    if (!_.isUndefined(matchingGroup)) {
                        matchingGroup.attributes.groupName = formData.groupName;
                    }
                    _this.saveShippingDetailsToModel();
                    const remoteController = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                    remoteController.invokeCtx('saveAddress', jsonData, function (response) {
                        if (response.success) {
                            //Something changed these to strings upstream, so updating with duped values from earlier.
                            if (CCRZ.LLIShippingDetailModel.attributes.cartData.setAsManagerDupe != null) {
                                CCRZ.LLIShippingDetailModel.attributes.cartData.setAsManager = CCRZ.LLIShippingDetailModel.attributes.cartData.setAsManagerDupe;
                            }
                            if (CCRZ.LLIShippingDetailModel.attributes.cartData.createContactDupe != null) {
                                CCRZ.LLIShippingDetailModel.attributes.cartData.createContact = CCRZ.LLIShippingDetailModel.attributes.cartData.createContactDupe;
                            }
                            if (CCRZ.LLIShippingDetailModel.attributes.cartData.textMsgOptInDupe != null) {
                                CCRZ.LLIShippingDetailModel.attributes.cartData.textMessageOptIn = CCRZ.LLIShippingDetailModel.attributes.cartData.textMsgOptInDupe;
                            }
                            if (response && response.success && response.data.addressList && !_.isUndefined(matchingGroup)) {
                                matchingGroup.set("shipTo", response.data.addressList[0]);

                                var addToBookBilling = $('#addToBillingBook').prop('checked');
                                var addToBookShipping = $('#addToShippingBook').prop('checked');
                                var contactAdrrSFID = matchingGroup.attributes.shipTo.sfid;
                                let addressTypes = [];
                                if (!_.isUndefined(addToBookBilling) && addToBookBilling) {
                                    addressTypes.push('Billing');
                                }
                                if (!_.isUndefined(addToBookShipping) && addToBookShipping) {
                                    addressTypes.push('Shipping');
                                }
                                if (!_.isUndefined(contactAdrrSFID) && contactAdrrSFID && addressTypes.length > 0) {
                                    shipView.addToBook(contactAdrrSFID, addressTypes);
                                }
                            }
                            var ids = _.pluck(response.data.addressList, "sfid");
                            if (_.isUndefined(matchingGroup)) {
                                _this.model.fetch(function () {
                                    _this.shippingOptionsData.fetch(ids, function () {
                                        _this.requestDateData.fetch(ids, function () {
                                            _this.render();
                                        })
                                    });
                                });
                            } else {
                                _this.shippingOptionsData.fetch(ids, function () {
                                    _this.requestDateData.fetch(ids, function () {
                                        _this.render();
                                    })
                                });
                            }
                        } else {
                            CCRZ.pubSub.trigger('hideLoader');
                        }
                        
                    },
                    {
                        buffer: false,
                        escape: false,
                        nmsp: false
                    });

                };
                shipView.handleOtherInfo = function (event) {
                    let _this = this, value = event.target.value, type = event.target.dataset.type
                        , fieldName = event.target.dataset.apiname, sfid = event.target.dataset.sfid
                        , cartData = _this.model.get('cartData');
                    let isValid = UTIL.validate($(event.target)[0]);
                    _this.validateField(_this, cartData, false, value, isValid, fieldName, sfid);
                };
                shipView.handlePickbyOthers = function (event) {
                    let _this = this, cartData = _this.model.get('cartData'), sfid = event.target.dataset.sfid;
                    cartData.ECartItemGroupsS.models.forEach(function (cartItemGroup) {
                        if (cartItemGroup.attributes.sfid == sfid) {
                            cartItemGroup.attributes.isPickedByOthers = event.target.checked;
                        }
                    });
                    _this.model.get('cartData', cartData);
                    _this.render();
                };
                shipView.updateCustomFields = function (event) {
                    var createStoreContact = false;
                    var assignManagerPerm = false;
                    var textMsgOptIn = false;

                    if (!$('.storeAssociate').hasClass('hidden')) {
                        var createStoreContactChecked = $('#createStoreContact').prop('checked');
                        if (createStoreContactChecked) {
                            createStoreContact = true;
                            $('.assignManagerSection').removeClass('hidden');
                        } else {
                            $('.assignManagerSection').addClass('hidden');
                            $('#assignManagerPerm').prop('checked', false);
                        }

                        var assignManagerPermChecked = $('#assignManagerPerm:checked').prop('checked');
                        if (assignManagerPermChecked) {
                            assignManagerPerm = true;
                        }
                        
                        var textMsgOptInChecked = $('#textMsgOptIn:checked').prop('checked');
                        if(textMsgOptInChecked) {
                            textMsgOptIn = true;
                        }
                    }

                    let remote = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                    remote.invokeCtx(
                        'addCustomerOrderName', //method name
                        $("#customerOrderName").val(), // parameters to method call
                        createStoreContact,// Value of Create Store Contact
                        assignManagerPerm,// Value of Assign Manager Permission
                        textMsgOptIn,
                        function (resp) {
                            // no callback needed since it's an update call and we're now outside of the subscriber extension list.
                            console.log('LPM_BB_CheckoutController response:  ' + resp);
                            if (resp && resp.success) {
                                //Something changes these to strings downstream, so duplicating for use later.
                                CCRZ.LLIShippingDetailModel.attributes.cartData.createContactDupe = createStoreContact;
                                CCRZ.LLIShippingDetailModel.attributes.cartData.setAsManagerDupe = assignManagerPerm;
                                CCRZ.LLIShippingDetailModel.attributes.cartData.textMsgOptInDupe = textMsgOptIn;
                            }
                        },
                        {
                            nmsp: false, escape: false, buffer: false
                        });
                };
                shipView.addToBook = function (contactAdrrSFID, addressTypes) {
                    const remoteCreateNewAddress = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                    remoteCreateNewAddress.invokeCtx('createNewAddress', contactAdrrSFID, addressTypes, function (resp) {
                        if (resp && resp.success) {
                            console.log('Creating New Address was successful');
                        } else {
                            console.log('Creating New Address failed');
                        }
                    }, {
                        buffer: false,
                        escape: false,
                        nmsp: false
                    });
                }
                shipView.postRender = function () {
                    UTIL.hideLoader();
                    var v = this;
                    v.initValidation();
                    if (CCRZ.ga) {
                        CCRZ.ga.sendPageview(_.extend({'source': 'Checkout'}, CCRZ.pagevars), {
                            'title': 'Checkout - Shipping Information'
                            , 'page': [window.location.pathname, CCRZ.ga.safeParams()].join('?')
                        });
                    }
                    let cartData = v.model.get('cartData');
                    console.log("***");
                    console.log(cartData);
                    if (v.model.get('isProceed')) {
                        let isValidation = v.validateAllFields(cartData);
                        if (!isValidation) {
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'All the required fields should be filled before proceeding!'));
                        }
                        v.model.set('isProceed', false);
                    }
                };
                shipView.handleOpenCreateGroupModal = function (event) {
                    let checkoutMod = new checkoutModel(), _this = this, cartData = _this.model.get('cartData');
                    let reqData = _this.createInput(cartData.ECartItemGroupsS.models);
                    checkoutMod.updateCartItemGroups(JSON.stringify(reqData), function (res, evt) {
                        if (res && res.success) {
                            _this.addItemGroup(event);
                        } else {
                            // Error Handling
                        }
                    });
                };
                shipView.initValidation = function () {
                    $.validator.addMethod( "regex", function(value, element, regexp) {
                            return this.optional(element) || regexp.test(value);
                        },
                        "Please check your input."
                    );
                    $('.addressForm').each(function () {
                        $(this).validate({
                            invalidHandler: function (event1, validator1) {
                                CCRZ.handleValidationErrors(event1, validator1, 'shipModal-messagingSection-Error', false);
                            },
                            //TODO Client side validation for item group name?
                            rules: {
                                "groupName": {
                                    required: true
                                },
                                "shipTo.firstName": {
                                    regex: /^-?[a-zA-Z]{1,}[a-zA-Z0-9\s]*$/,
                                    required: true
                                },
                                "shipTo.lastName": {
                                    regex: /^-?[a-zA-Z]{1,}[a-zA-Z0-9\s]*$/,
                                    required: true
                                },
                                "shipTo.addressFirstline": {
                                    minlength: 3,
                                    regex: /^-?[a-zA-Z0-9]{1,}[a-zA-Z0-9\s]*$/,
                                    required: true
                                },
                                "shipTo.city": {
                                    minlength: 2,
                                    regex: /^-?[a-zA-Z]{2,}[a-zA-Z\s]*$/,
                                    required: true
                                },
                                "shipTo.postalCode": {
                                    minlength: 5,
                                    maxlength: 10,
                                    regex: /^(\d{5}|\d{5}-\d{4})$/,
                                    required: true
                                },
                                "shipTo.email": {
                                    regex: /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,})+$/,
                                    required: true
                                },
                                "shipTo.homePhone": {
                                    minlength: 10,
                                    maxlength: 10,
                                    regex: /^([1-9]\d{9})$/,
                                    required: true
                                },
                                "shipTo.stateCode": {
                                    required: true
                                }
                            },
                            messages: {
                                "groupName": {
                                    required: 'LPM_BB_Shipping_Group_Name'
                                },
                                "shipTo.firstName": {
                                    regex: 'LPM_BB_First_Name_Regex',
                                    required: 'LPM_BB_First_Name'
                                },
                                "shipTo.lastName": {
                                    regex: 'LPM_BB_Last_Name_Regex',
                                    required: 'LPM_BB_Last_Name'
                                },
                                "shipTo.addressFirstline": {
                                    regex: "LPM_BB_Address_Line_Regex",
                                    required: "LPM_BB_Address_Line"
                                },
                                "shipTo.city": {
                                    regex: "LPM_BB_City_Name_Regex",
                                    required: "LPM_BB_City_Name"
                                },
                                "shipTo.postalCode": {
                                    regex: 'LPM_BB_Postal_Code_Regex',
                                    required: 'LPM_BB_Postal_Code'
                                },
                                "shipTo.email": {
                                    regex: 'LPM_BB_Email_Address_Regex',
                                    required: 'LPM_BB_Email_Address'
                                },
                                "shipTo.homePhone": {
                                    regex: 'LPM_BB_Phone_Number_Regex',
                                    required: 'LPM_BB_Phone_Number'
                                },
                                "shipTo.stateCode": {
                                    required: "State is required" 
                                }
                            },
                            errorPlacement: function (error, element) {
                            }
                        });
                    });

                    $('#buyerInfo').validate({
                        invalidHandler: function (event2, validator2) {
                            CCRZ.handleValidationErrors(event2, validator2, 'messagingSection-Error', false);
                        },
                        //TODO Client side validation for item group name?
                        rules: {
                            "buyerFirstName": {
                                required: CCRZ.getPageConfig('Info.ReqFirstName', true)
                            },
                            "buyerLastName": {
                                required: CCRZ.getPageConfig('Info.ReqLastName', true)
                            },
                            "buyerEmail": {
                                required: CCRZ.getPageConfig('Info.ReqEmail', true),
                                email: true
                            },
                            "buyerPhone": {
                                required: CCRZ.getPageConfig('Info.ReqPhone', false)
                            }
                        },
                        messages: {
                            buyerFirstName: {
                                required: "MISSING_FIRST_NAME"
                            },
                            buyerLastName: {
                                required: "MISSING_LAST_NAME"
                            },
                            buyerEmail: {
                                required: "MISSING_EMAIL_ADDRESS",
                                email: "FORMATTING_EMAIL"
                            },
                            buyerPhone: {
                                required: "MISSING_PHONE"
                            }
                        },
                        errorPlacement: function (error, element) {
                        }
                    });

                };
                shipView.handleProceedToReview = function (event) {
                    this.model.set('isProceed', true);
                    let checkoutMod = new checkoutModel(), _this = this, isAddressValidation = true,
                        isExtraFields = true, cartData = _this.model.get('cartData');
                    var buyerValid = false;
                    if (!_.isUndefined(cartData) && cartData.ECartItemGroupsS && cartData.ECartItemGroupsS.length > 0) {
                        cartData.ECartItemGroupsS.models.forEach(function (cartItemGroup) {
                            if (_.isUndefined(cartItemGroup.attributes.shipTo.addressFirstline) || _.isUndefined(cartItemGroup.attributes.shipTo.city)
                                || _.isUndefined(cartItemGroup.attributes.shipTo.stateISOCode) || _.isUndefined(cartItemGroup.attributes.shipTo.postalCode) 
                                || $('.groupAdd' + cartItemGroup.attributes.sfid + ' .cc_addr_city').html() == ''
                                || $('.groupAdd' + cartItemGroup.attributes.sfid + ' .addr_line1.cc_addr_line').html() == '') {
                                isAddressValidation = false;
                            }
                        })
                        isExtraFields = _this.validateAllFields(cartData);
                        buyerValid = $("#buyerInfo").valid();
                    } else {
                        isAddressValidation = false;
                    }
                    if (isAddressValidation && isExtraFields && buyerValid) {
                        UTIL.showLoader();
                        shipView.updateCustomFields();
                        _this.checkForGroupDuplicate(_this, cartData);
                        let reqData = _this.createInput(cartData.ECartItemGroupsS.models);
                        checkoutMod.updateCartItemGroups(JSON.stringify(reqData), function (res, evt) {
                            if (res && res.success) {
                                _this.processLLIShippingInfo(event);
                            } else {
                                // Error Handling
                                UTIL.hideLoader();
                            }
                        });
                    } else {
                        window.scroll(0, 0);
                        if (!isExtraFields) {
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'All the required fields should be filled before proceeding!'));
                            _this.render();
                        }
                        if (!isAddressValidation) {
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error", 'All the groups should be populated with an address to proceed!'));
                        }
                        UTIL.hideLoader();
                    }

                };
                shipView.checkForGroupDuplicate = function (_this, cartData) {
                    let groupMap = new Map(), groupList = [];
                    cartData.ECartItemGroupsS.models.forEach(function (cartItemGroup) {
                        if (!cartItemGroup.attributes.isStorePickup) {
                            groupList.push(cartItemGroup.attributes.groupName);
                            if (groupMap.has(cartItemGroup.attributes.groupName)) {
                                let counter = groupMap.get(cartItemGroup.attributes.groupName);
                                counter++;
                                cartItemGroup.attributes.groupName += ' ' + counter;
                                groupMap.set(cartItemGroup.attributes.groupName, counter);
                            } else {
                                groupMap.set(cartItemGroup.attributes.groupName, 0);
                            }
                        }
                    });
                    _this.model.get('cartData', cartData);
                };
                shipView.createInput = function (cartItemGroups) {
                    let ciGroups = [], cartItemGroupIds = [];
                    cartItemGroups.forEach(function (cartItemGroup) {
                        cartItemGroupIds.push(cartItemGroup.attributes.sfid);
                        let savePerson = $('#savePickOthers'+cartItemGroup.attributes.sfid).is(':checked');;
                        ciGroups.push({
                            'sfid': cartItemGroup.attributes.sfid,
                            'isPickedByOthers': cartItemGroup.attributes.isPickedByOthers,
                            'otherFirstName': cartItemGroup.attributes.otherFirstName,
                            'otherLastName': cartItemGroup.attributes.otherLastName,
                            'otherEmail': cartItemGroup.attributes.otherEmail,
                            'otherPhone': cartItemGroup.attributes.otherPhone,
                            'groupName': cartItemGroup.attributes.groupName,
                            'savePickupPerson': savePerson
                        });
                    });
                    return {
                        'cartItemGroups': ciGroups,
                        'cartItemGroupIds': cartItemGroupIds
                    }
                };
                shipView.validateAllFields = function (cartData) {
                    let _this = this, isValidAll = true;
                    $('.inputValidate input').each(function (index, input) {
                        let sfid = $(input).data('sfid'), apiname = $(input).data('apiname'),
                            isValid = UTIL.validate(input);
                        _this.validateField(_this, cartData, true, '', isValid, apiname, sfid);
                        if (isValidAll) {
                            isValidAll = isValid;
                        }
                    });
                    return isValidAll;
                };
                shipView.validateField = function (_this, cartData, isProceed, value, isValid, fieldName, sfid) {
                    cartData.ECartItemGroupsS.models.forEach(function (cartItemGroup) {
                        if (cartItemGroup.attributes.sfid == sfid) {
                            if (!isProceed) {
                                cartItemGroup.attributes[fieldName] = value;
                            }
                            cartItemGroup.attributes[('isError' + fieldName)] = !isValid;
                        }
                    });
                    _this.model.get('cartData', cartData);
                    if (!isProceed) {
                        //_this.render();
                    }
                };
                shipView.saveShippingDetailsToModel = function (event) {
                    // loop through the item groups
                    if (CCRZ.LLIShippingDetailModel.get('cartData').ECartItemGroupsS && CCRZ.LLIShippingDetailModel.get('cartData').ECartItemGroupsS.models) {
                        jQuery.each(CCRZ.LLIShippingDetailModel.get('cartData').ECartItemGroupsS.models, function (index, group) {
                            var sfid = group.get("sfid");
                            // save the shipping detail to the model
                            if (group.get('ECartItemsS').length != 0 && !_.isUndefined(group.attributes.shipTo) && !group.attributes.isStorePickup) {
                                var shipOptionsData = CCRZ.LLIShippingDetailModel.get('shippingOptionsData');
                                if (CCRZ.pagevars.pageConfig.isTrue('SO.DsplShipOptions') && shipOptionsData) {
                                    var groupShipOptions = shipOptionsData.data.shippingOptions[group.attributes.shipTo.sfid];
                                    var selectedOption = $(".cc_shipping_group_panel[data-id=" + sfid + "] .shippingOptions").find('option:selected');
                                    var selectedMethod = selectedOption.val();
                                    if (!_.isUndefined(selectedMethod)) {
                                        var shipAmount = _.find(groupShipOptions, {uniqueId: selectedMethod}).price;
                                        group.set("shipMethod", selectedMethod);
                                        group.set("shipAmount", shipAmount);
                                    }
                                }

                                if (CCRZ.pagevars.pageConfig.isTrue('SO.ShowReqDate')) {
                                    var requestDate = $(".cc_shipping_group_panel[data-id=" + sfid + "] .requestedDate").val();
                                    if (!requestDate) {
                                        requestDate = null;
                                    } else {
                                        // probably should do some verification here
                                        // convert to UTC
                                        // this also fixes the bug found during development, CCRZ-11405
                                        var dateObj = new Date($(".cc_shipping_group_panel[data-id=" + sfid + "] .requestedDate").datepicker('getDate'));
                                        requestDate = dateObj.toISOString();
                                        // Salesforce wants an ISO 8601 without the time
                                        requestDate = requestDate.substr(0, requestDate.indexOf('T'));
                                    }
                                    group.set("requestDate", requestDate);
                                }

                                if (CCRZ.pagevars.pageConfig.isTrue('SO.DsplShipNotes')) {
                                    var shipNotes = $("#shippingInst_" + sfid).val();
                                    group.set("note", shipNotes);
                                }
                            } else {
                                //var shipOptionsData = CCRZ.LLIShippingDetailModel.get('shippingOptionsData');
                                let isPickOthers = $('.pickOthers' + group.attributes.sfid).is(':checked');
                                group.set("shipMethod", 'Free Shipping Applied');
                                group.set("requestDate", null);
                                group.set("shipAmount", 0);
                                group.set("note", isPickOthers ? 'Pickup By Other Person' : null);
                            }
                        });
                    }
                };
                shipView.handleCopyContactName = function(event) {
                    let isChecked = $('#copyContactName').prop('checked');
                    let firstName = $('#buyerFirstName').val();
                    let lastName = $('#buyerLastName').val();
                    let contactPhone = $('#buyerPhone').val();
                    let contactEmail = $('#buyerEmail').val();
                    if(isChecked) {
                        if(firstName != '') {
                            
                            $('#shipToFirstName').attr('value', firstName);
                        }
                        if(lastName != '') {
                            $('#shipToLastName').attr('value', lastName);
                        }
                        if(contactPhone != '') {
                            $('#shipToPhone').attr('value', contactPhone);
                        }
                        if(contactEmail != '') {
                            $('#shipToEmail').attr('value', contactEmail);
                        }
                    }                
                };
                shipView.delegateEvents();
                shipView.render();
            });

            CCRZ.pubSub.once('view:addressEditModal:refresh', function (addressEditView) {
                UTIL.hideLoader();
                addressEditView.setAddress = function (addressData) {
                    if ($("#addrEditCarousel").is(":visible")) {
                        var v = this;
                        if (_.isUndefined(v.dataSet.shipTo)) {
                            // new shipping group
                            v.dataSet.shipTo = {};
                        }
                        var formData = form2js('addrEdit', '.', false, function (node) {
                        }, false, true);
                        if (formData.groupName) {
                            v.dataSet.groupName = formData.groupName;
                        }
                        // if we just set v.dataSet = addressData we'll end up saving our changes to the address book
                        v.dataSet.shipTo.addressFirstline = addressData.addressFirstline;
                        v.dataSet.shipTo.addressSecondline = addressData.addressSecondline;
                        v.dataSet.shipTo.addressThirdline = addressData.addressThirdline;
                        v.dataSet.shipTo.city = addressData.city;
                        v.dataSet.shipTo.companyName = addressData.companyName;
                        v.dataSet.shipTo.country = 'United States';
                        v.dataSet.shipTo.countryISOCode = 'US';
                        v.dataSet.shipTo.firstName = addressData.firstName;
                        v.dataSet.shipTo.lastName = addressData.lastName;
                        v.dataSet.shipTo.postalCode = addressData.postalCode;
                        v.dataSet.shipTo.email = addressData.email;
                        v.dataSet.shipTo.homePhone = addressData.homePhone;
                        v.dataSet.shipTo.stateISOCode = addressData.stateISOCode;
                        v.dataSet.shipTo.state = addressData.state;
                        v.dataSet.shipTo.addrReadOnly = addressData.addrReadOnly;
                        v.dataSet.shipTo.partnerId = addressData.partnerId;
                        v.dataSet.shipTo.origsfid = addressData.sfid;
                        v.addressFormView.render(v.dataSet, '.addrEditForm');
                    }
                };
            });
        }
    }
});