d("LLIOrderReviewView", ['util'], function (UTIL, LLIOrderReviewView) {

    return {
        extendLLIOrderReviewView: function () {

            CCRZ.pubSub.once('view:LLIOrderReviewView:refresh', function (LLIOrderReviewView) {
                UTIL.hideLoader();
                LLIOrderReviewView.events['click .processReview'] = 'overridenCheckTnC';
                LLIOrderReviewView.events['keypress #storeAssociate_storeId'] = 'validateStoreInput';

                LLIOrderReviewView.overridenCheckTnC = function (event) {
                    debugger;
                    //UTIL.showLoader();
                    var isError = false;
                    $(".error").remove();
                    if (!($('.terms_and_conditions').prop('checked'))) {
                        $('.TnC_error').append('<div class="error tncErrorMsg">Accept Terms and Conditions</div>');
                        isError = true;
                        $(".terms_and_conditions").change(function () {
                            if (this.checked) {
                                $(".tncErrorMsg").remove();
                            }
                        });
                    }

                    var isStoreContact = this.model.get('cartData').contactR.storeContact;
                    if(isStoreContact) {
                        var employeeId = $('#storeAssociate_employeeId').val();                    
                        if(employeeId == '') {
                            $('.employeeId_error').append('<div class="error employeeErrorMsg">Employee ID Required</div>');
                            isError = true;
                            $("#storeAssociate_employeeId").change(function () {
                                if (this.value != '') {
                                    $(".employeeErrorMsg").remove();
                                }
                            });
                        }
                        var storeId = $('#storeAssociate_storeId').val();
                        if(storeId == '') {
                            $('.storeId_error').append('<div class="error storeErrorMsg">Store ID Required</div>');
                            isError = true;
                            $("#storeAssociate_storeId").change(function () {
                                if (this.value != '') {
                                    $(".storeErrorMsg").remove();
                                }
                            });
                        }
                        if (!isError) {
                            var reqData = {
                                "employeeId" : employeeId,
                                "storeId" : storeId
                            };
                            const remoteUpdateContactInfo = _.extend(CCRZ.RemoteInvocation, {className: 'LPM_BB_CheckoutController'});
                            remoteUpdateContactInfo.invokeCtx('updateStoreContactInfo', JSON.stringify(reqData), function (resp) {
                                if (resp && resp.success) {
                                    console.log('Updating store contact was successful');
                                    UTIL.showLoader();
                                    CCRZ.LLIcartCheckoutView.slideRight(event);
                                } else {
                                    console.log('Updating store contactfailed');
                                    $('.storeId_error').append('<div class="error storeErrorMsg">Sorry, no store with this store ID was found</div>');
                                }
                            }, {
                                buffer: false,
                                escape: false,
                                nmsp: false
                            });
                        }
                    } else {
                        if(!isError) {
                            UTIL.showLoader();
                            CCRZ.LLIcartCheckoutView.slideRight(event);
                        }
                    }
                };

                LLIOrderReviewView.validateStoreInput = function (event) {
                    var v = this;
                    return CCRZ.util.isValidNumericInput(event);
                };
                LLIOrderReviewView.delegateEvents();
                LLIOrderReviewView.render();
            });
        },
    }
});