d("AddressListing", ['util'], function (UTIL, AddressListing) {

    return {
        extendAddressListing: function (AddressListing) {
            CCRZ.pubSub.on("view:AddressListing:refresh", function (view) {
                jQuery("select.billingField").attr("readonly", (CCRZ.cartCheckoutModel.get('preventBillingEdit')));
                view.delegateEvents(_.extend(view.events, {
                    'click .processUserInfo': processUserInfoCustom,
                    'click .selectAddress': processAddressSelectionCustom,
                    'click .copyAddress': copyAddressCustom,


                }));
            });
        }
    }

    function processUserInfoCustom(event) {
        // debugger;
        if (this.validateInfo()) {
            var isValidPhone = validationPhoneOnly();
            if (!isValidPhone) {
                window.scrollTo(0, 0);
                $('.shipping-messagingSection-Error').html('');
                $('.shipping-messagingSection-Error').append('<div class="alert alert-danger">Not a valid Phone Number.</div>');
                $('.shipping-messagingSection-Error').show();
                return false;
            }
            var isValidEmail = validateEmailOnly();
            if (!isValidEmail) {
                window.scrollTo(0, 0);
                $('.shipping-messagingSection-Error').html('');
                $('.shipping-messagingSection-Error').append('<div class="alert alert-danger">You have entered an invalid email address.</div>');
                $('.shipping-messagingSection-Error').show();
                return false;
            }

            var formData = form2js('mainform', '.', false, function (node) {
            }, false, true);
            CCRZ.cartCheckoutModel.set(formData);
            if ($("#ccEmailForm").length > 0) {
                var ccFormData = form2js('ccEmailForm', '.', false, function (node) {
                }, false, true);
                CCRZ.cartCheckoutModel.set(ccFormData);
            }
            //if (!CCRZ.display.isPhone()){
            var billData = form2js('billingAddressForm', '.', false, function (node) {
            }, false, true);
            billData.billingAddress.country = $(".billingcountry option:selected").text();
            billData.billingAddress.addrReadOnly = ('true' == billData.billingAddress.addrReadOnly) ? true : false;
            CCRZ.cartCheckoutModel.set(billData);
            var shipData = form2js('shippingAddressForm', '.', false, function (node) {
            }, false, true);
            shipData.shippingAddress.country = $(".shippingcountry option:selected").text();
            shipData.shippingAddress.addrReadOnly = Boolean(shipData.shippingAddress.addrReadOnly);
            CCRZ.cartCheckoutModel.set(shipData);
            this.initAddresses();
            //}
            CCRZ.cartCheckoutView.slideRight();
        } else {
            window.scrollTo(0, 0);
        }

        $(".shippingfirstNameField").keyup(function (e) {
            $('.error_ship').css("display", "none");
        });

        $(".shippinglastNameField").keyup(function (e) {
            $('.error_shippinglname').css("display", "none");
        });

        $(".shippinghomePhoneField").keyup(function (e) {
            $('.error_shippinghomePhoneField').css("display", "none");
        });
        $(".shippinghomePhoneField").keyup(function (e) {
            $('.error_shippinghomePhoneField_Regx').css("display", "none");
        });

        $(".shippingemailField").keyup(function (e) {
            $('.error_shippingemailField').css("display", "none");
        });

        $(".shippingemailField").keyup(function (e) {
            $('.error_shippingemailField_Regx').css("display", "none");
        });

        $(".shippingAddress1").keyup(function (e) {
            $('.error_shippingAddress1').css("display", "none");
        });
        $(".shippingCity").keyup(function (e) {
            $('.error_shippingCity').css("display", "none");
        });
        $(".shippingPostalCode").keyup(function (e) {
            $('.error_shippingPostalCode').css("display", "none");
        });


        $(".error_ship").remove();
        $(".error_shippinghomePhoneField").remove();
        $(".error_shippinglname").remove();
        $(".error_shippinghomePhoneField_Regx").remove();
        $(".error_shippingemailField").remove();
        $(".error_shippingemailField_Regx").remove();
        $(".error_shippingAddress1").remove();
        $(".error_shippingCity").remove();
        $(".error_shippingPostalCode").remove();


    }

    function processAddressSelectionCustom(event) {
        var obj = $(event.target);
        var id = obj.data("id");
        if (obj.hasClass('billingField')) {
            var selectedEntry = this.addressBook.billingAddresses.get(id);
            CCRZ.cartCheckoutModel.attributes.billingAddress = selectedEntry.toJSON();
            this.applyAddressData('billing', selectedEntry.attributes);
            if (!selectedEntry.attributes.stateCode)
                this.renderBillStates(selectedEntry.attributes.state, selectedEntry.attributes.countryCode);
            else
                this.renderBillStates(selectedEntry.attributes.stateCode, selectedEntry.attributes.countryCode);
        } else {
            var selectedEntry = this.addressBook.shippingAddresses.get(id);
            CCRZ.cartCheckoutModel.attributes.shippingAddress = selectedEntry.toJSON();
            //this.applyAddressData('shipping', selectedEntry.attributes);
            applyAddressDataCustom('shipping', selectedEntry.attributes);
            if (!selectedEntry.attributes.stateCode)
                this.renderShipStates(selectedEntry.attributes.state, selectedEntry.attributes.countryCode);
            else
                this.renderShipStates(selectedEntry.attributes.stateCode, selectedEntry.attributes.countryCode);
        }
        this.processReadOnly();
    }

    function applyAddressDataCustom(prefix, addressBean) {
        $('.' + prefix + 'firstNameField').val(addressBean.firstName);
        $('.' + prefix + 'lastNameField').val(addressBean.lastName);
        $('.' + prefix + 'homePhoneField').val(addressBean.homePhone);
        $('.' + prefix + 'emailField').val(addressBean.email);
        $('.' + prefix + 'companyField').val(addressBean.companyName);
        $('.' + prefix + 'acctIdField').val(addressBean.partnerId);
        $('.' + prefix + 'Address1').val(addressBean.address1);
        $('.' + prefix + 'Address2').val(addressBean.address2);
        $('.' + prefix + 'Address3').val(addressBean.address3);
        $('.' + prefix + 'City').val(addressBean.city);
        $('.' + prefix + 'PostalCode').val(addressBean.postalCode);
        $('.' + prefix + 'country').val(addressBean.countryCode);
        $('.' + prefix + 'addrReadOnly').val(addressBean.addrReadOnly);
        $('.' + prefix + 'partnerId').val(addressBean.partnerId);
        $('.' + prefix + 'sfid').val(addressBean.sfid);
        $("#modal_" + prefix).modal("hide");
        $('.modal-backdrop').removeClass('in');
        $('.modal-backdrop').css('pointer-events', 'none');
    }

    function copyAddressCustom() {
        var billData = form2js('billingAddressForm', '.', false, function (node) {
        }, false, true);
        //this.applyAddressData('shipping', billData.billingAddress);
        billData.billingAddress.countryCode = billData.billingAddress.country;
        applyAddressDataCustom('shipping', billData.billingAddress);
        if (!billData.billingAddress.stateCode)
            this.renderShipStates(billData.billingAddress.state, billData.billingAddress.countryCode);
        else
            this.renderShipStates(billData.billingAddress.stateCode, billData.billingAddress.countryCode);
        return false;
    }

    function validationPhoneOnly() {
        debugger;
        var inputtxt = $('.shippinghomePhoneField')[0];
        /*var phoneno = /^\d{10}$/;
        // If we need phone number like XXX-XXX-XXXX use below code
        //var phoneno = /^\(?([0-9]{3})\)?[-. ]?([0-9]{3})[-]?([0-9]{4})$/;
        if(inputtxt.value.match(phoneno))
        {
            return true;
        }
        else
        {
            //alert("Not a valid Phone Number");
            return false;
        }*/
        /*This function will allow phone numbers entered in the formats like this

        (123) 456-7890
        (123)456-7890
        123-456-7890
        1234567890
        */
        var re = /^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$/im;

        return re.test(inputtxt.value);

    }

    function validateEmailOnly() {
        debugger;
        var inputtxt = $('.shippingemailField')[0];
        //var mailformat = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;
        var mailformat = /^(?:[a-z0-9!#$%&amp;'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&amp;'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])$/;
        if (inputtxt.value.match(mailformat)) {
            return true;
        } else {
            //alert("You have entered an invalid email address!");
            return false;
        }
    }


});